// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated with protocol_gen.go -- do not edit this file.
//   go run scripts/protocol_gen/protocol_gen.go
//
// DAP version 1.65.0

#include "dap/protocol.h"

namespace dap {

DAP_IMPLEMENT_STRUCT_TYPEINFO(BreakpointEvent,
                              "breakpoint",
                              DAP_FIELD(breakpoint, "breakpoint"),
                              DAP_FIELD(reason, "reason"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(CapabilitiesEvent,
                              "capabilities",
                              DAP_FIELD(capabilities, "capabilities"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ContinuedEvent,
                              "continued",
                              DAP_FIELD(allThreadsContinued,
                                        "allThreadsContinued"),
                              DAP_FIELD(threadId, "threadId"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ExitedEvent,
                              "exited",
                              DAP_FIELD(exitCode, "exitCode"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(InitializedEvent, "initialized");

DAP_IMPLEMENT_STRUCT_TYPEINFO(InvalidatedEvent,
                              "invalidated",
                              DAP_FIELD(areas, "areas"),
                              DAP_FIELD(stackFrameId, "stackFrameId"),
                              DAP_FIELD(threadId, "threadId"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(LoadedSourceEvent,
                              "loadedSource",
                              DAP_FIELD(reason, "reason"),
                              DAP_FIELD(source, "source"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(MemoryEvent,
                              "memory",
                              DAP_FIELD(count, "count"),
                              DAP_FIELD(memoryReference, "memoryReference"),
                              DAP_FIELD(offset, "offset"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ModuleEvent,
                              "module",
                              DAP_FIELD(module, "module"),
                              DAP_FIELD(reason, "reason"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(OutputEvent,
                              "output",
                              DAP_FIELD(category, "category"),
                              DAP_FIELD(column, "column"),
                              DAP_FIELD(data, "data"),
                              DAP_FIELD(group, "group"),
                              DAP_FIELD(line, "line"),
                              DAP_FIELD(output, "output"),
                              DAP_FIELD(source, "source"),
                              DAP_FIELD(variablesReference,
                                        "variablesReference"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ProcessEvent,
                              "process",
                              DAP_FIELD(isLocalProcess, "isLocalProcess"),
                              DAP_FIELD(name, "name"),
                              DAP_FIELD(pointerSize, "pointerSize"),
                              DAP_FIELD(startMethod, "startMethod"),
                              DAP_FIELD(systemProcessId, "systemProcessId"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ProgressEndEvent,
                              "progressEnd",
                              DAP_FIELD(message, "message"),
                              DAP_FIELD(progressId, "progressId"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ProgressStartEvent,
                              "progressStart",
                              DAP_FIELD(cancellable, "cancellable"),
                              DAP_FIELD(message, "message"),
                              DAP_FIELD(percentage, "percentage"),
                              DAP_FIELD(progressId, "progressId"),
                              DAP_FIELD(requestId, "requestId"),
                              DAP_FIELD(title, "title"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ProgressUpdateEvent,
                              "progressUpdate",
                              DAP_FIELD(message, "message"),
                              DAP_FIELD(percentage, "percentage"),
                              DAP_FIELD(progressId, "progressId"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(StoppedEvent,
                              "stopped",
                              DAP_FIELD(allThreadsStopped, "allThreadsStopped"),
                              DAP_FIELD(description, "description"),
                              DAP_FIELD(hitBreakpointIds, "hitBreakpointIds"),
                              DAP_FIELD(preserveFocusHint, "preserveFocusHint"),
                              DAP_FIELD(reason, "reason"),
                              DAP_FIELD(text, "text"),
                              DAP_FIELD(threadId, "threadId"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(TerminatedEvent,
                              "terminated",
                              DAP_FIELD(restart, "restart"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ThreadEvent,
                              "thread",
                              DAP_FIELD(reason, "reason"),
                              DAP_FIELD(threadId, "threadId"));

}  // namespace dap
