/*
 * Copyright (C) 2017 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors:
 *    Zhao, Yakui <yakui.zhao@intel.com>
 *    Chen, Peng  <peng.c.chen@intel.com>
 *
 */

#ifndef _GEN10_HEVC_ENC_CONST_H
#define _GEN10_HEVC_ENC_CONST_H

#define GEN10_HEVC_ENC_INTRA_CONST_LUT_SIZE 24576
#define GEN10_HEVC_ENC_INTER_CONST_LUT32_SIZE 582240
#define GEN10_HEVC_ENC_INTER_CONST_LUT64_SIZE 1003520

#define GEN10_HEVC_IME_REF_WINDOW_MODE_BIG       1
#define GEN10_HEVC_IME_REF_WINDOW_MODE_MEDIUM    2
#define GEN10_HEVC_IME_REF_WINDOW_MODE_SMALL     3

#define GEN10_HEVC_QP_TYPE_CONSTANT                0
#define GEN10_HEVC_QP_TYPE_FRAME                   1
#define GEN10_HEVC_QP_TYPE_CU_LEVEL                2

#define GEN10_HEVC_BRC_QP_ADJUST_SIZE        576
#define GEN10_HEVC_BRC_LCU_LAMBDA_COST       1664

enum GEN10_HEVC_TU_BASED_PARAMS {
	GEN10_ENABLE_CU64_CHECK_TU_PARAM,
	GEN10_CU64_SKIP_CHECK_ONLY_TU_PARAM,
	GEN10_ENC_QT_DECISION_MODE_TU_PARAM,
	GEN10_ENC_TU_DECISION_MODE_TU_PARAM,
	GEN10_ENC_TU_DECISION_FOR_ALL_QT_TU_PARAM,
	GEN10_ENC_RD_DECISION_MODE_FOR_ALL_QT_TU_PARAM,
	GEN10_COEF_BIT_EST_MODE_TU_PARAM,
	GEN10_MAX_NUM_IME_SEARCH_CENTER_TU_PARAM,
	GEN10_ENC_SKIP_DECISION_MODE_TU_PARAM,
	GEN10_ENC_TRANSFORM_SIMPLIFY_TU_PARAM,
	GEN10_LOG2_TU_MAX_DEPTH_INTER_TU_PARAM,
	GEN10_LOG2_TU_MAX_DEPTH_INTRA_TU_PARAM,
	GEN10_TOTAL_THREAD_NUM_PER_LCU_TU_PARAM,
	GEN10_SIC_DYNAMIC_RUN_PATH_MODE,
	GEN10_TOTOAL_TU_PARAMS
};

const static uint32_t
gen10_hevc_me_search_path[16] = {
	0x0101F00F,
	0x0F0F1010,
	0xF0F0F00F,
	0x01010101,
	0x10101010,
	0x0F0F0F0F,
	0xF0F0F00F,
	0x0101F0F0,
	0x01010101,
	0x10101010,
	0x0F0F1010,
	0x0F0F0F0F,
	0xF0F0F00F,
	0xF0F0F0F0,
	0x01010101,
	0x01010101
};

const static uint8_t
gen10_hevc_ime_ref_window_size[4][2] = {
	{ 0,  0},
	{64, 64},
	{48, 48},
	{48, 40}
};

const static double
gen10_hevc_mode_bits[2][3][15] = {
	{
		{ 3.50, 9.50, 9.75, 9.81, 18.00, 12.75, 18.25, 11.81, 12.50, 0.00, 1.00, 1.50, 0.00, 0.00, 3.50 },
		{ 3.50, 9.50, 9.75, 9.81, 15.00, 11.25, 15.25, 10.31, 11.00, 0.00, 1.00, 1.50, 0.00, 0.00, 3.50 },
		{ 3.50, 7.50, 7.75, 7.81, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 1.50, 0.00, 0.00, 0.00 },
	},
	{
		{ 3.50, 9.75, 9.81, 9.83, 18.25, 12.81, 18.31, 11.83, 12.75, 0.00, 1.00, 1.50, 20.50, 26.00, 3.50 },
		{ 3.50, 9.75, 9.81, 9.83, 15.25, 11.31, 15.31, 10.33, 11.25, 0.00, 1.00, 1.50, 19.00, 23.00, 3.50 },
		{ 3.50, 7.75, 7.80, 7.83, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 1.50, 0.00, 0.00, 0.00 },
	}
};

const static double
gen10_hevc_lambda_factor[3][52] = {
	{
		0.1, 0.1, 0.1, 0.1, 0.1, 0.4, 0.4, 0.4, 0.4, 0.4,
		1.0, 1.0, 1.0, 1.0, 1.0, 1.1, 1.1, 1.1, 1.1, 1.1,
		1.1, 1.1, 1.1, 1.1, 1.1, 1.3, 1.3, 1.3, 1.3, 1.3,
		1.4, 1.4, 1.4, 1.4, 1.4, 1.4, 1.4, 1.4, 1.4, 1.4,
		1.8, 1.8, 1.8, 1.8, 1.8, 1.8, 1.8, 1.8, 1.8, 1.8,
		1.8, 1.8
	},
	{
		0.1, 0.1, 0.1, 0.1, 0.1, 0.4, 0.4, 0.4, 0.4, 0.4,
		1.0, 1.0, 1.0, 1.0, 1.0, 1.1, 1.1, 1.1, 1.1, 1.1,
		1.1, 1.1, 1.1, 1.1, 1.1, 1.3, 1.3, 1.3, 1.3, 1.3,
		1.4, 1.4, 1.4, 1.4, 1.4, 1.4, 1.4, 1.4, 1.4, 1.4,
		1.8, 1.8, 1.8, 1.8, 1.8, 1.8, 1.8, 1.8, 1.8, 1.8,
		1.8, 1.8
	},
	{
		1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
		1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
		1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
		1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
		1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
		1.0, 1.0
	}
};

const static uint8_t
gen10_hevc_tu_settings[GEN10_TOTOAL_TU_PARAMS][3] = {
	{  1,   1,   0},
	{  0,   1,   0},
	{  1,   1,   0},
	{  3,   3,   0},
	{  1,   1,   0},
	{  1,   0,   0},
	{  1,   1,   0},
	{  6,   4,   2},
	{  2,   2,   0},
	{  0,   3,   0},
	{  1,   1,   0},
	{  1,   1,   0},
	{  5,   3,   1},
	{  0,   0,   2},
};

const static uint8_t
gen10_hevc_brc_qp_adjust_data[GEN10_HEVC_BRC_QP_ADJUST_SIZE] = {
	0x01, 0x02, 0x03, 0x05, 0x06, 0x01, 0x01, 0x02, 0x03, 0x05, 0x00, 0x00, 0x01, 0x02, 0x03, 0xff,
	0x00, 0x00, 0x01, 0x02, 0xff, 0x00, 0x00, 0x00, 0x01, 0xfe, 0xfe, 0xff, 0x00, 0x01, 0xfd, 0xfd,
	0xff, 0xff, 0x00, 0xfb, 0xfd, 0xfe, 0xff, 0xff, 0xfa, 0xfb, 0xfd, 0xfe, 0xff, 0x00, 0x04, 0x1e,
	0x3c, 0x50, 0x78, 0x8c, 0xc8, 0xff, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x02, 0x03, 0x05, 0x06, 0x01, 0x01, 0x02, 0x03, 0x05, 0x00, 0x01, 0x01, 0x02, 0x03, 0xff,
	0x00, 0x00, 0x01, 0x02, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0x00, 0x01, 0xfe, 0xff,
	0xff, 0xff, 0x00, 0xfc, 0xfe, 0xff, 0xff, 0x00, 0xfb, 0xfc, 0xfe, 0xff, 0xff, 0x00, 0x04, 0x1e,
	0x3c, 0x50, 0x78, 0x8c, 0xc8, 0xff, 0x04, 0x05, 0x06, 0x06, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x01, 0x02, 0x04, 0x05, 0x01, 0x01, 0x01, 0x02, 0x04, 0x00, 0x00, 0x01, 0x01, 0x02, 0xff,
	0x00, 0x00, 0x01, 0x01, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x01, 0xfe, 0xff,
	0xff, 0xff, 0x00, 0xfd, 0xfe, 0xff, 0xff, 0x00, 0xfb, 0xfc, 0xfe, 0xff, 0xff, 0x00, 0x02, 0x14,
	0x28, 0x46, 0x82, 0xa0, 0xc8, 0xff, 0x04, 0x04, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03,
	0x03, 0x04, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x03, 0x03, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x02, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0xfe, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe,
	0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfe, 0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03,
	0x03, 0x04, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x03, 0x03, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x02, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0xfe, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe,
	0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfe, 0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,


	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03,
	0x03, 0x04, 0xff, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x03, 0x03, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x02, 0x02, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x02, 0x02, 0xfe, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0x01, 0x02, 0xfe,
	0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x01, 0xfe, 0xfe, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const static uint32_t
gen10_hevc_brc_lcu32_lambda_cost[GEN10_HEVC_BRC_LCU_LAMBDA_COST / 4] = {
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000001, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000002, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000003, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000004, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000005, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000006, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000007, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000008, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000009, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000a, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000b, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191807, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000c, 0xFFFFFFFF, 0xFFFFFFFF,
	0x1a1a1908, 0x00000000, 0x03000000, 0x0000064d, 0x00000283, 0x0000000d, 0xFFFFFFFF, 0xFFFFFFFF,
	0x1b1b1b09, 0x00000000, 0x04000000, 0x000007f0, 0x000002d1, 0x0000000e, 0xFFFFFFFF, 0xFFFFFFFF,
	0x1c1c1c0b, 0x00000000, 0x04000000, 0x00000a00, 0x0000032a, 0x0000000f, 0xFFFFFFFF, 0xFFFFFFFF,
	0x1e1e1d0c, 0x00000000, 0x05000000, 0x00000c99, 0x0000038d, 0x00000010, 0xFFFFFFFF, 0xFFFFFFFF,
	0x281f1f0d, 0x00000000, 0x05000000, 0x00000fe0, 0x000003fc, 0x00000011, 0xFFFFFFFF, 0xFFFFFFFF,
	0x2929280f, 0x00000000, 0x06000000, 0x00001400, 0x00000479, 0x00000012, 0xFFFFFFFF, 0xFFFFFFFF,
	0x2a2a2919, 0x00000000, 0x07000000, 0x00001933, 0x00000505, 0x00000013, 0xFFFFFFFF, 0xFFFFFFFF,
	0x2b2b2b1a, 0x00000000, 0x08000000, 0x00001fbf, 0x000005a2, 0x00000014, 0xFFFFFFFF, 0xFFFFFFFF,
	0x2c2c2c1b, 0x00000000, 0x09000000, 0x00002800, 0x00000653, 0x00000015, 0xFFFFFFFF, 0xFFFFFFFF,
	0x2e2e2d1c, 0x00000000, 0x0a000000, 0x00003266, 0x00000719, 0x00000016, 0xFFFFFFFF, 0xFFFFFFFF,
	0x382f2f1e, 0x00000000, 0x0b000000, 0x00003f7f, 0x000007f8, 0x00000017, 0xFFFFFFFF, 0xFFFFFFFF,
	0x39393828, 0x00000000, 0x0d000000, 0x00005000, 0x000008f2, 0x00000018, 0xFFFFFFFF, 0xFFFFFFFF,
	0x3a3a3929, 0x00000000, 0x0f000000, 0x000064cb, 0x00000a0a, 0x00000019, 0xFFFFFFFF, 0xFFFFFFFF,
	0x3b3b3b2a, 0x00000000, 0x18000000, 0x00007efe, 0x00000b45, 0x0000001a, 0xFFFFFFFF, 0xFFFFFFFF,
	0x3c3c3c2b, 0x00000000, 0x19000000, 0x0000a000, 0x00000ca6, 0x0000001b, 0xFFFFFFFF, 0xFFFFFFFF,
	0x3e3e3d2c, 0x00000000, 0x1b000000, 0x0000c996, 0x00000e33, 0x0000001c, 0xFFFFFFFF, 0xFFFFFFFF,
	0x483f3f2e, 0x00000000, 0x1c000000, 0x0000fdfc, 0x00000ff0, 0x0000001d, 0xFFFFFFFF, 0xFFFFFFFF,
	0x49494838, 0x00000000, 0x1d000000, 0x00014000, 0x000011e3, 0x0000001e, 0xFFFFFFFF, 0xFFFFFFFF,
	0x4a4a4939, 0x00000000, 0x1f000000, 0x0001932d, 0x00001414, 0x0000001f, 0xFFFFFFFF, 0xFFFFFFFF,
	0x4b4b4b3a, 0x00000000, 0x28000000, 0x0001fbf8, 0x0000168a, 0x00000020, 0xFFFFFFFF, 0xFFFFFFFF,
	0x4c4c4c3b, 0x00000000, 0x29000000, 0x00028000, 0x0000194c, 0x00000021, 0xFFFFFFFF, 0xFFFFFFFF,
	0x4e4e4d3c, 0x00000000, 0x2b000000, 0x00032659, 0x00001c65, 0x00000022, 0xFFFFFFFF, 0xFFFFFFFF,
	0x584f4f3e, 0x00000000, 0x2c000000, 0x0003f7f0, 0x00001fe0, 0x00000023, 0xFFFFFFFF, 0xFFFFFFFF,
	0x59595848, 0x00000000, 0x2d000000, 0x00050000, 0x000023c7, 0x00000024, 0xFFFFFFFF, 0xFFFFFFFF,
	0x5a5a5949, 0x00000000, 0x2f000000, 0x00064cb3, 0x00002829, 0x00000025, 0xFFFFFFFF, 0xFFFFFFFF,
	0x5b5b5b4a, 0x00000000, 0x38000000, 0x0007efe0, 0x00002d14, 0x00000026, 0xFFFFFFFF, 0xFFFFFFFF,
	0x5c5c5c4b, 0x00000000, 0x39000000, 0x000a0000, 0x00003299, 0x00000027, 0xFFFFFFFF, 0xFFFFFFFF,
	0x5e5e5d4c, 0x00000000, 0x3b000000, 0x000c9966, 0x000038cb, 0x00000028, 0xFFFFFFFF, 0xFFFFFFFF,
	0x685f5f4e, 0x00000000, 0x3c000000, 0x000fdfbf, 0x00003fbf, 0x00000029, 0xFFFFFFFF, 0xFFFFFFFF,
	0x69696858, 0x00000000, 0x3d000000, 0x00140000, 0x0000478e, 0x0000002a, 0xFFFFFFFF, 0xFFFFFFFF,
	0x6a6a6959, 0x00000000, 0x3f000000, 0x001932cc, 0x00005051, 0x0000002b, 0xFFFFFFFF, 0xFFFFFFFF,
	0x6b6b6b5a, 0x00000000, 0x48000000, 0x001fbf7e, 0x00005a27, 0x0000002c, 0xFFFFFFFF, 0xFFFFFFFF,
	0x6c6c6c5b, 0x00000000, 0x49000000, 0x00280000, 0x00006531, 0x0000002d, 0xFFFFFFFF, 0xFFFFFFFF,
	0x6e6e6d5c, 0x00000000, 0x4b000000, 0x00326597, 0x00007196, 0x0000002e, 0xFFFFFFFF, 0xFFFFFFFF,
	0x786f6f5e, 0x00000000, 0x4c000000, 0x003f7efd, 0x00007f7f, 0x0000002f, 0xFFFFFFFF, 0xFFFFFFFF,
	0x79797868, 0x00000000, 0x4d000000, 0x00500000, 0x00008f1c, 0x00000030, 0xFFFFFFFF, 0xFFFFFFFF,
	0x7a7a7969, 0x00000000, 0x4f000000, 0x0064cb2f, 0x0000a0a2, 0x00000031, 0xFFFFFFFF, 0xFFFFFFFF,
	0x7b7b7b6a, 0x00000000, 0x58000000, 0x007efdf9, 0x0000b44e, 0x00000032, 0xFFFFFFFF, 0xFFFFFFFF,
	0x7c7c7c6b, 0x00000000, 0x59000000, 0x00a00000, 0x0000ca63, 0x00000033, 0xFFFFFFFF, 0xFFFFFFFF
};

const static uint32_t
gen10_hevc_brc_lcu64_lambda_cost[GEN10_HEVC_BRC_LCU_LAMBDA_COST / 4] = {
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000001, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000002, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000003, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000004, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000005, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000006, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000007, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000008, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x00000009, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000a, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000b, 0xFFFFFFFF, 0xFFFFFFFF,
	0x19191907, 0x00000000, 0x03000000, 0x00000500, 0x0000023c, 0x0000000c, 0xFFFFFFFF, 0xFFFFFFFF,
	0x1a1a1a08, 0x00000000, 0x03000000, 0x0000064d, 0x00000283, 0x0000000d, 0xFFFFFFFF, 0xFFFFFFFF,
	0x1b1b1b09, 0x00000000, 0x04000000, 0x000007f0, 0x000002d1, 0x0000000e, 0xFFFFFFFF, 0xFFFFFFFF,
	0x1c1c1c0b, 0x00000000, 0x04000000, 0x00000a00, 0x0000032a, 0x0000000f, 0xFFFFFFFF, 0xFFFFFFFF,
	0x1e1e1e0c, 0x00000000, 0x05000000, 0x00000c99, 0x0000038d, 0x00000010, 0xFFFFFFFF, 0xFFFFFFFF,
	0x28281f0d, 0x00000000, 0x05000000, 0x00000fe0, 0x000003fc, 0x00000011, 0xFFFFFFFF, 0xFFFFFFFF,
	0x2929290f, 0x00000000, 0x06000000, 0x00001400, 0x00000479, 0x00000012, 0xFFFFFFFF, 0xFFFFFFFF,
	0x2a2a2a19, 0x00000000, 0x07000000, 0x00001933, 0x00000505, 0x00000013, 0xFFFFFFFF, 0xFFFFFFFF,
	0x2b2b2b1a, 0x00000000, 0x08000000, 0x00001fbf, 0x000005a2, 0x00000014, 0xFFFFFFFF, 0xFFFFFFFF,
	0x2c2c2c1b, 0x00000000, 0x09000000, 0x00002800, 0x00000653, 0x00000015, 0xFFFFFFFF, 0xFFFFFFFF,
	0x2e2e2e1c, 0x00000000, 0x0a000000, 0x00003266, 0x00000719, 0x00000016, 0xFFFFFFFF, 0xFFFFFFFF,
	0x38382f1e, 0x00000000, 0x0b000000, 0x00003f7f, 0x000007f8, 0x00000017, 0xFFFFFFFF, 0xFFFFFFFF,
	0x39393928, 0x00000000, 0x0d000000, 0x00005000, 0x000008f2, 0x00000018, 0xFFFFFFFF, 0xFFFFFFFF,
	0x3a3a3a29, 0x00000000, 0x0f000000, 0x000064cb, 0x00000a0a, 0x00000019, 0xFFFFFFFF, 0xFFFFFFFF,
	0x3b3b3b2a, 0x00000000, 0x18000000, 0x00007efe, 0x00000b45, 0x0000001a, 0xFFFFFFFF, 0xFFFFFFFF,
	0x3c3c3c2b, 0x00000000, 0x19000000, 0x0000a000, 0x00000ca6, 0x0000001b, 0xFFFFFFFF, 0xFFFFFFFF,
	0x3e3e3e2c, 0x00000000, 0x1b000000, 0x0000c996, 0x00000e33, 0x0000001c, 0xFFFFFFFF, 0xFFFFFFFF,
	0x48483f2e, 0x00000000, 0x1c000000, 0x0000fdfc, 0x00000ff0, 0x0000001d, 0xFFFFFFFF, 0xFFFFFFFF,
	0x49494938, 0x00000000, 0x1d000000, 0x00014000, 0x000011e3, 0x0000001e, 0xFFFFFFFF, 0xFFFFFFFF,
	0x4a4a4a39, 0x00000000, 0x1f000000, 0x0001932d, 0x00001414, 0x0000001f, 0xFFFFFFFF, 0xFFFFFFFF,
	0x4b4b4b3a, 0x00000000, 0x28000000, 0x0001fbf8, 0x0000168a, 0x00000020, 0xFFFFFFFF, 0xFFFFFFFF,
	0x4c4c4c3b, 0x00000000, 0x29000000, 0x00028000, 0x0000194c, 0x00000021, 0xFFFFFFFF, 0xFFFFFFFF,
	0x4e4e4e3c, 0x00000000, 0x2b000000, 0x00032659, 0x00001c65, 0x00000022, 0xFFFFFFFF, 0xFFFFFFFF,
	0x58584f3e, 0x00000000, 0x2c000000, 0x0003f7f0, 0x00001fe0, 0x00000023, 0xFFFFFFFF, 0xFFFFFFFF,
	0x59595948, 0x00000000, 0x2d000000, 0x00050000, 0x000023c7, 0x00000024, 0xFFFFFFFF, 0xFFFFFFFF,
	0x5a5a5a49, 0x00000000, 0x2f000000, 0x00064cb3, 0x00002829, 0x00000025, 0xFFFFFFFF, 0xFFFFFFFF,
	0x5b5b5b4a, 0x00000000, 0x38000000, 0x0007efe0, 0x00002d14, 0x00000026, 0xFFFFFFFF, 0xFFFFFFFF,
	0x5c5c5c4b, 0x00000000, 0x39000000, 0x000a0000, 0x00003299, 0x00000027, 0xFFFFFFFF, 0xFFFFFFFF,
	0x5e5e5e4c, 0x00000000, 0x3b000000, 0x000c9966, 0x000038cb, 0x00000028, 0xFFFFFFFF, 0xFFFFFFFF,
	0x68685f4e, 0x00000000, 0x3c000000, 0x000fdfbf, 0x00003fbf, 0x00000029, 0xFFFFFFFF, 0xFFFFFFFF,
	0x69696958, 0x00000000, 0x3d000000, 0x00140000, 0x0000478e, 0x0000002a, 0xFFFFFFFF, 0xFFFFFFFF,
	0x6a6a6a59, 0x00000000, 0x3f000000, 0x001932cc, 0x00005051, 0x0000002b, 0xFFFFFFFF, 0xFFFFFFFF,
	0x6b6b6b5a, 0x00000000, 0x48000000, 0x001fbf7e, 0x00005a27, 0x0000002c, 0xFFFFFFFF, 0xFFFFFFFF,
	0x6c6c6c5b, 0x00000000, 0x49000000, 0x00280000, 0x00006531, 0x0000002d, 0xFFFFFFFF, 0xFFFFFFFF,
	0x6e6e6e5c, 0x00000000, 0x4b000000, 0x00326597, 0x00007196, 0x0000002e, 0xFFFFFFFF, 0xFFFFFFFF,
	0x78786f5e, 0x00000000, 0x4c000000, 0x003f7efd, 0x00007f7f, 0x0000002f, 0xFFFFFFFF, 0xFFFFFFFF,
	0x79797968, 0x00000000, 0x4d000000, 0x00500000, 0x00008f1c, 0x00000030, 0xFFFFFFFF, 0xFFFFFFFF,
	0x7a7a7a69, 0x00000000, 0x4f000000, 0x0064cb2f, 0x0000a0a2, 0x00000031, 0xFFFFFFFF, 0xFFFFFFFF,
	0x7b7b7b6a, 0x00000000, 0x58000000, 0x007efdf9, 0x0000b44e, 0x00000032, 0xFFFFFFFF, 0xFFFFFFFF,
	0x7c7c7c6b, 0x00000000, 0x59000000, 0x00a00000, 0x0000ca63, 0x00000033, 0xFFFFFFFF, 0xFFFFFFFF
};

const static uint32_t
gen10_hevc_enc_intra_const_lut[GEN10_HEVC_ENC_INTRA_CONST_LUT_SIZE / 4 ] = {
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x1a1a1908, 0x00000000, 0x03000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x1b1b1b09, 0x00000000, 0x04000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x1c1c1c0b, 0x00000000, 0x04000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x1e1e1d0c, 0x00000000, 0x05000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x281f1f0d, 0x00000000, 0x05000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x2929280f, 0x00000000, 0x06000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x2a2a2919, 0x00000000, 0x07000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x2b2b2b1a, 0x00000000, 0x08000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x2c2c2c1b, 0x00000000, 0x09000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x2e2e2d1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x382f2f1e, 0x00000000, 0x0b000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x39393828, 0x00000000, 0x0d000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x3a3a3929, 0x00000000, 0x0f000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x3b3b3b2a, 0x00000000, 0x18000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x3c3c3c2b, 0x00000000, 0x19000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x3e3e3d2c, 0x00000000, 0x1b000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x483f3f2e, 0x00000000, 0x1c000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x49494838, 0x00000000, 0x1d000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x4a4a4939, 0x00000000, 0x1f000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x4b4b4b3a, 0x00000000, 0x28000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x4c4c4c3b, 0x00000000, 0x29000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x4e4e4d3c, 0x00000000, 0x2b000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x584f4f3e, 0x00000000, 0x2c000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x59595848, 0x00000000, 0x2d000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x5a5a5949, 0x00000000, 0x2f000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x5b5b5b4a, 0x00000000, 0x38000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x5c5c5c4b, 0x00000000, 0x39000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x5e5e5d4c, 0x00000000, 0x3b000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x685f5f4e, 0x00000000, 0x3c000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x69696858, 0x00000000, 0x3d000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x6a6a6959, 0x00000000, 0x3f000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x6b6b6b5a, 0x00000000, 0x48000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x6c6c6c5b, 0x00000000, 0x49000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x6e6e6d5c, 0x00000000, 0x4b000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x786f6f5e, 0x00000000, 0x4c000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x79797868, 0x00000000, 0x4d000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x7a7a7969, 0x00000000, 0x4f000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x7b7b7b6a, 0x00000000, 0x58000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x7c7c7c6b, 0x00000000, 0x59000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x060d1807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070f1908, 0x00000000, 0x03000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x08191b09, 0x00000000, 0x04000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x091a1c0b, 0x00000000, 0x04000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x0b1b1d0c, 0x00000000, 0x05000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x0c1c1f0d, 0x00000000, 0x05000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x0f282919, 0x00000000, 0x07000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x19292b1a, 0x00000000, 0x08000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x1a2a2c1b, 0x00000000, 0x09000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x1b2b2d1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x1c2c2f1e, 0x00000000, 0x0b000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x1e2e3828, 0x00000000, 0x0d000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x28383929, 0x00000000, 0x0f000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x29393b2a, 0x00000000, 0x18000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x2a3a3c2b, 0x00000000, 0x19000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x2b3b3d2c, 0x00000000, 0x1b000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x2c3c3f2e, 0x00000000, 0x1c000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x2e3e4838, 0x00000000, 0x1d000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x38484939, 0x00000000, 0x1f000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x39494b3a, 0x00000000, 0x28000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x3a4a4c3b, 0x00000000, 0x29000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x3b4b4d3c, 0x00000000, 0x2b000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x3c4c4f3e, 0x00000000, 0x2c000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x3e4e5848, 0x00000000, 0x2d000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x48585949, 0x00000000, 0x2f000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x49595b4a, 0x00000000, 0x38000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x4a5a5c4b, 0x00000000, 0x39000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x4b5b5d4c, 0x00000000, 0x3b000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x4c5c5f4e, 0x00000000, 0x3c000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x4e5e6858, 0x00000000, 0x3d000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x58686959, 0x00000000, 0x3f000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x59696b5a, 0x00000000, 0x48000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x5a6a6c5b, 0x00000000, 0x49000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x5b6b6d5c, 0x00000000, 0x4b000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x5c6c6f5e, 0x00000000, 0x4c000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x5e6e7868, 0x00000000, 0x4d000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x68787969, 0x00000000, 0x4f000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x69797b6a, 0x00000000, 0x58000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x6a7a7c6b, 0x00000000, 0x59000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031807, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031908, 0x00000000, 0x03000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x02041b09, 0x00000000, 0x04000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x02041c0b, 0x00000000, 0x04000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x02051d0c, 0x00000000, 0x05000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x03061f0d, 0x00000000, 0x05000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x0306280f, 0x00000000, 0x06000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x03072919, 0x00000000, 0x07000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x04082b1a, 0x00000000, 0x08000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x04092c1b, 0x00000000, 0x09000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x050b2d1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x060c2f1e, 0x00000000, 0x0b000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x060d3828, 0x00000000, 0x0d000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x070f3929, 0x00000000, 0x0f000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x08193b2a, 0x00000000, 0x18000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x091a3c2b, 0x00000000, 0x19000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x0b1b3d2c, 0x00000000, 0x1b000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x0c1c3f2e, 0x00000000, 0x1c000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x0d1e4838, 0x00000000, 0x1d000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x0f284939, 0x00000000, 0x1f000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x19294b3a, 0x00000000, 0x28000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x1a2a4c3b, 0x00000000, 0x29000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x1b2b4d3c, 0x00000000, 0x2b000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x1c2c4f3e, 0x00000000, 0x2c000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x1e2e5848, 0x00000000, 0x2d000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x28385949, 0x00000000, 0x2f000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x29395b4a, 0x00000000, 0x38000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x2a3a5c4b, 0x00000000, 0x39000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x2b3b5d4c, 0x00000000, 0x3b000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x2c3c5f4e, 0x00000000, 0x3c000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x2e3e6858, 0x00000000, 0x3d000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x38486959, 0x00000000, 0x3f000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x39496b5a, 0x00000000, 0x48000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x3a4a6c5b, 0x00000000, 0x49000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x3b4b6d5c, 0x00000000, 0x4b000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x3c4c6f5e, 0x00000000, 0x4c000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x3e4e7868, 0x00000000, 0x4d000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x48587969, 0x00000000, 0x4f000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x49597b6a, 0x00000000, 0x58000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x4a5a7c6b, 0x00000000, 0x59000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x191c2919, 0x00000000, 0x07000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x1a1d2b1a, 0x00000000, 0x08000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x1b1f2c1b, 0x00000000, 0x09000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x1c282d1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x1e292f1e, 0x00000000, 0x0b000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x282a3828, 0x00000000, 0x0d000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x292c3929, 0x00000000, 0x0f000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x2a2d3b2a, 0x00000000, 0x18000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x2b2f3c2b, 0x00000000, 0x19000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x2c383d2c, 0x00000000, 0x1b000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x2e393f2e, 0x00000000, 0x1c000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x383a4838, 0x00000000, 0x1d000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x393c4939, 0x00000000, 0x1f000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x3a3d4b3a, 0x00000000, 0x28000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x3b3f4c3b, 0x00000000, 0x29000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x3c484d3c, 0x00000000, 0x2b000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x3e494f3e, 0x00000000, 0x2c000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x484a5848, 0x00000000, 0x2d000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x494c5949, 0x00000000, 0x2f000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x4a4d5b4a, 0x00000000, 0x38000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x4b4f5c4b, 0x00000000, 0x39000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x4c585d4c, 0x00000000, 0x3b000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x4e595f4e, 0x00000000, 0x3c000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x585a6858, 0x00000000, 0x3d000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x595c6959, 0x00000000, 0x3f000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x5a5d6b5a, 0x00000000, 0x48000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x5b5f6c5b, 0x00000000, 0x49000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x5c686d5c, 0x00000000, 0x4b000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x5e696f5e, 0x00000000, 0x4c000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x686a7868, 0x00000000, 0x4d000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x696c7969, 0x00000000, 0x4f000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x6a6d7b6a, 0x00000000, 0x58000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x6b6f7c6b, 0x00000000, 0x59000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x6c787d6c, 0x00000000, 0x5b000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x6e797f6e, 0x00000000, 0x5c000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x787a886f, 0x00000000, 0x5d000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x797c896f, 0x00000000, 0x5f000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x7a7d8b6f, 0x00000000, 0x68000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x7b7f8c6f, 0x00000000, 0x69000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0d1e280f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f282919, 0x00000000, 0x07000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x19292b1a, 0x00000000, 0x08000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x1a2a2c1b, 0x00000000, 0x09000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x1b2b2d1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x1c2c2f1e, 0x00000000, 0x0b000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x1e2e3828, 0x00000000, 0x0d000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x28383929, 0x00000000, 0x0f000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x29393b2a, 0x00000000, 0x18000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x2a3a3c2b, 0x00000000, 0x19000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x2b3b3d2c, 0x00000000, 0x1b000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x2c3c3f2e, 0x00000000, 0x1c000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x2e3e4838, 0x00000000, 0x1d000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x38484939, 0x00000000, 0x1f000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x39494b3a, 0x00000000, 0x28000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x3a4a4c3b, 0x00000000, 0x29000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x3b4b4d3c, 0x00000000, 0x2b000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x3c4c4f3e, 0x00000000, 0x2c000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x3e4e5848, 0x00000000, 0x2d000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x48585949, 0x00000000, 0x2f000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x49595b4a, 0x00000000, 0x38000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x4a5a5c4b, 0x00000000, 0x39000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x4b5b5d4c, 0x00000000, 0x3b000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x4c5c5f4e, 0x00000000, 0x3c000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x4e5e6858, 0x00000000, 0x3d000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x58686959, 0x00000000, 0x3f000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x59696b5a, 0x00000000, 0x48000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x5a6a6c5b, 0x00000000, 0x49000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x5b6b6d5c, 0x00000000, 0x4b000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x5c6c6f5e, 0x00000000, 0x4c000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x5e6e7868, 0x00000000, 0x4d000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x68787969, 0x00000000, 0x4f000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x69797b6a, 0x00000000, 0x58000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x6a7a7c6b, 0x00000000, 0x59000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x6b7b7d6c, 0x00000000, 0x5b000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x6c7c7f6e, 0x00000000, 0x5c000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x6e7e886f, 0x00000000, 0x5d000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x7888896f, 0x00000000, 0x5f000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x79898b6f, 0x00000000, 0x68000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x7a8a8c6f, 0x00000000, 0x69000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041b0a, 0x00000000, 0x04000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x02051d0b, 0x00000000, 0x05000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x02051e0d, 0x00000000, 0x05000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x0306280e, 0x00000000, 0x06000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x03072918, 0x00000000, 0x07000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x04082a19, 0x00000000, 0x08000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x04092b1b, 0x00000000, 0x09000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x050a2d1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x050b2e1d, 0x00000000, 0x0b000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x060d381f, 0x00000000, 0x0c000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x070e3928, 0x00000000, 0x0e000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x08183a29, 0x00000000, 0x18000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x09193b2b, 0x00000000, 0x19000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x0a1a3d2c, 0x00000000, 0x1a000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x0b1c3e2d, 0x00000000, 0x1b000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x0d1d482f, 0x00000000, 0x1d000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x0e1f4938, 0x00000000, 0x1e000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x18284a39, 0x00000000, 0x28000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x19294b3b, 0x00000000, 0x29000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x1b2a4d3c, 0x00000000, 0x2a000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x1c2c4e3d, 0x00000000, 0x2b000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x1d2d583f, 0x00000000, 0x2d000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x1f2f5948, 0x00000000, 0x2e000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x28385a49, 0x00000000, 0x38000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x29395b4b, 0x00000000, 0x39000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x2b3a5d4c, 0x00000000, 0x3a000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x2c3c5e4d, 0x00000000, 0x3b000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x2d3d684f, 0x00000000, 0x3d000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x2f3f6958, 0x00000000, 0x3e000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x38486a59, 0x00000000, 0x48000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x39496b5b, 0x00000000, 0x49000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x3b4a6d5c, 0x00000000, 0x4a000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x3c4c6e5d, 0x00000000, 0x4b000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x3d4d785f, 0x00000000, 0x4d000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x3f4f7968, 0x00000000, 0x4e000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x48587a69, 0x00000000, 0x58000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x49597b6b, 0x00000000, 0x59000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x4b5a7d6c, 0x00000000, 0x5a000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x4c5c7e6d, 0x00000000, 0x5b000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x19191907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x1a1a1a08, 0x00000000, 0x03000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x1b1b1b09, 0x00000000, 0x04000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x1c1c1c0b, 0x00000000, 0x04000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x1e1e1e0c, 0x00000000, 0x05000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x28281f0d, 0x00000000, 0x05000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x2929290f, 0x00000000, 0x06000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x2a2a2a19, 0x00000000, 0x07000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x2b2b2b1a, 0x00000000, 0x08000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x2c2c2c1b, 0x00000000, 0x09000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x2e2e2e1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x38382f1e, 0x00000000, 0x0b000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x39393928, 0x00000000, 0x0d000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x3a3a3a29, 0x00000000, 0x0f000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x3b3b3b2a, 0x00000000, 0x18000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x3c3c3c2b, 0x00000000, 0x19000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x3e3e3e2c, 0x00000000, 0x1b000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x48483f2e, 0x00000000, 0x1c000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x49494938, 0x00000000, 0x1d000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x4a4a4a39, 0x00000000, 0x1f000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x4b4b4b3a, 0x00000000, 0x28000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x4c4c4c3b, 0x00000000, 0x29000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x4e4e4e3c, 0x00000000, 0x2b000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x58584f3e, 0x00000000, 0x2c000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x59595948, 0x00000000, 0x2d000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x5a5a5a49, 0x00000000, 0x2f000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x5b5b5b4a, 0x00000000, 0x38000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x5c5c5c4b, 0x00000000, 0x39000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x5e5e5e4c, 0x00000000, 0x3b000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x68685f4e, 0x00000000, 0x3c000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x69696958, 0x00000000, 0x3d000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x6a6a6a59, 0x00000000, 0x3f000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x6b6b6b5a, 0x00000000, 0x48000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x6c6c6c5b, 0x00000000, 0x49000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x6e6e6e5c, 0x00000000, 0x4b000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x78786f5e, 0x00000000, 0x4c000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x79797968, 0x00000000, 0x4d000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x7a7a7a69, 0x00000000, 0x4f000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x7b7b7b6a, 0x00000000, 0x58000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x7c7c7c6b, 0x00000000, 0x59000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070d1907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x070f1a08, 0x00000000, 0x03000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x08191b09, 0x00000000, 0x04000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x091a1c0b, 0x00000000, 0x04000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x0b1b1e0c, 0x00000000, 0x05000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x0c1c1f0d, 0x00000000, 0x05000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x0f282a19, 0x00000000, 0x07000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x19292b1a, 0x00000000, 0x08000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x1a2a2c1b, 0x00000000, 0x09000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x1b2b2e1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x1c2c2f1e, 0x00000000, 0x0b000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x1e2e3928, 0x00000000, 0x0d000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x28383a29, 0x00000000, 0x0f000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x29393b2a, 0x00000000, 0x18000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x2a3a3c2b, 0x00000000, 0x19000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x2b3b3e2c, 0x00000000, 0x1b000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x2c3c3f2e, 0x00000000, 0x1c000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x2e3e4938, 0x00000000, 0x1d000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x38484a39, 0x00000000, 0x1f000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x39494b3a, 0x00000000, 0x28000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x3a4a4c3b, 0x00000000, 0x29000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x3b4b4e3c, 0x00000000, 0x2b000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x3c4c4f3e, 0x00000000, 0x2c000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x3e4e5948, 0x00000000, 0x2d000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x48585a49, 0x00000000, 0x2f000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x49595b4a, 0x00000000, 0x38000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x4a5a5c4b, 0x00000000, 0x39000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x4b5b5e4c, 0x00000000, 0x3b000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x4c5c5f4e, 0x00000000, 0x3c000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x4e5e6958, 0x00000000, 0x3d000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x58686a59, 0x00000000, 0x3f000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x59696b5a, 0x00000000, 0x48000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x5a6a6c5b, 0x00000000, 0x49000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x5b6b6e5c, 0x00000000, 0x4b000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x5c6c6f5e, 0x00000000, 0x4c000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x5e6e7968, 0x00000000, 0x4d000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x68787a69, 0x00000000, 0x4f000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x69797b6a, 0x00000000, 0x58000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x6a7a7c6b, 0x00000000, 0x59000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031907, 0x00000000, 0x03000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x01031a08, 0x00000000, 0x03000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x02041b09, 0x00000000, 0x04000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x02041c0b, 0x00000000, 0x04000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x02051e0c, 0x00000000, 0x05000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x03061f0d, 0x00000000, 0x05000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x0306290f, 0x00000000, 0x06000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x03072a19, 0x00000000, 0x07000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x04082b1a, 0x00000000, 0x08000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x04092c1b, 0x00000000, 0x09000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x050b2e1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x060c2f1e, 0x00000000, 0x0b000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x070d3928, 0x00000000, 0x0d000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x070f3a29, 0x00000000, 0x0f000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x08193b2a, 0x00000000, 0x18000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x091a3c2b, 0x00000000, 0x19000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x0b1b3e2c, 0x00000000, 0x1b000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x0c1c3f2e, 0x00000000, 0x1c000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x0e1e4938, 0x00000000, 0x1d000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x0f284a39, 0x00000000, 0x1f000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x19294b3a, 0x00000000, 0x28000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x1a2a4c3b, 0x00000000, 0x29000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x1b2b4e3c, 0x00000000, 0x2b000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x1c2c4f3e, 0x00000000, 0x2c000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x1e2e5948, 0x00000000, 0x2d000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x28385a49, 0x00000000, 0x2f000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x29395b4a, 0x00000000, 0x38000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x2a3a5c4b, 0x00000000, 0x39000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x2b3b5e4c, 0x00000000, 0x3b000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x2c3c5f4e, 0x00000000, 0x3c000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x2e3e6958, 0x00000000, 0x3d000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x38486a59, 0x00000000, 0x3f000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x39496b5a, 0x00000000, 0x48000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x3a4a6c5b, 0x00000000, 0x49000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x3b4b6e5c, 0x00000000, 0x4b000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x3c4c6f5e, 0x00000000, 0x4c000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x3e4e7968, 0x00000000, 0x4d000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x48587a69, 0x00000000, 0x4f000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x49597b6a, 0x00000000, 0x58000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x4a5a7c6b, 0x00000000, 0x59000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f1a290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x191c2a19, 0x00000000, 0x07000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x1a1d2b1a, 0x00000000, 0x08000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x1b1f2c1b, 0x00000000, 0x09000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x1d282e1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x1e292f1e, 0x00000000, 0x0b000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x282a3928, 0x00000000, 0x0d000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x292c3a29, 0x00000000, 0x0f000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x2a2d3b2a, 0x00000000, 0x18000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x2b2f3c2b, 0x00000000, 0x19000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x2d383e2c, 0x00000000, 0x1b000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x2e393f2e, 0x00000000, 0x1c000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x383a4938, 0x00000000, 0x1d000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x393c4a39, 0x00000000, 0x1f000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x3a3d4b3a, 0x00000000, 0x28000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x3b3f4c3b, 0x00000000, 0x29000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x3d484e3c, 0x00000000, 0x2b000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x3e494f3e, 0x00000000, 0x2c000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x484a5948, 0x00000000, 0x2d000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x494c5a49, 0x00000000, 0x2f000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x4a4d5b4a, 0x00000000, 0x38000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x4b4f5c4b, 0x00000000, 0x39000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x4d585e4c, 0x00000000, 0x3b000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x4e595f4e, 0x00000000, 0x3c000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x585a6958, 0x00000000, 0x3d000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x595c6a59, 0x00000000, 0x3f000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x5a5d6b5a, 0x00000000, 0x48000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x5b5f6c5b, 0x00000000, 0x49000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x5d686e5c, 0x00000000, 0x4b000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x5e696f5e, 0x00000000, 0x4c000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x686a7968, 0x00000000, 0x4d000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x696c7a69, 0x00000000, 0x4f000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x6a6d7b6a, 0x00000000, 0x58000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x6b6f7c6b, 0x00000000, 0x59000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x6d787e6c, 0x00000000, 0x5b000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x6e797f6e, 0x00000000, 0x5c000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x787a896f, 0x00000000, 0x5d000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x797c8a6f, 0x00000000, 0x5f000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x7a7d8b6f, 0x00000000, 0x68000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x7b7f8c6f, 0x00000000, 0x69000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0e1e290f, 0x00000000, 0x06000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x0f282a19, 0x00000000, 0x07000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x19292b1a, 0x00000000, 0x08000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x1a2a2c1b, 0x00000000, 0x09000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x1b2b2e1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x1c2c2f1e, 0x00000000, 0x0b000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x1e2e3928, 0x00000000, 0x0d000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x28383a29, 0x00000000, 0x0f000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x29393b2a, 0x00000000, 0x18000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x2a3a3c2b, 0x00000000, 0x19000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x2b3b3e2c, 0x00000000, 0x1b000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x2c3c3f2e, 0x00000000, 0x1c000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x2e3e4938, 0x00000000, 0x1d000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x38484a39, 0x00000000, 0x1f000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x39494b3a, 0x00000000, 0x28000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x3a4a4c3b, 0x00000000, 0x29000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x3b4b4e3c, 0x00000000, 0x2b000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x3c4c4f3e, 0x00000000, 0x2c000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x3e4e5948, 0x00000000, 0x2d000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x48585a49, 0x00000000, 0x2f000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x49595b4a, 0x00000000, 0x38000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x4a5a5c4b, 0x00000000, 0x39000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x4b5b5e4c, 0x00000000, 0x3b000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x4c5c5f4e, 0x00000000, 0x3c000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x4e5e6958, 0x00000000, 0x3d000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x58686a59, 0x00000000, 0x3f000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x59696b5a, 0x00000000, 0x48000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x5a6a6c5b, 0x00000000, 0x49000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x5b6b6e5c, 0x00000000, 0x4b000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x5c6c6f5e, 0x00000000, 0x4c000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x5e6e7968, 0x00000000, 0x4d000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x68787a69, 0x00000000, 0x4f000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x69797b6a, 0x00000000, 0x58000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x6a7a7c6b, 0x00000000, 0x59000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x6b7b7e6c, 0x00000000, 0x5b000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x6c7c7f6e, 0x00000000, 0x5c000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x6e7e896f, 0x00000000, 0x5d000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x78888a6f, 0x00000000, 0x5f000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x79898b6f, 0x00000000, 0x68000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x7a8a8c6f, 0x00000000, 0x69000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041a09, 0x00000000, 0x04000000, 0x040c2400, 0x00000500, 0x0000023c, 0x0000005e, 0x00000000,
	0x02041c0a, 0x00000000, 0x04000000, 0x040c2400, 0x0000064d, 0x00000283, 0x0000006a, 0x00000000,
	0x02051d0b, 0x00000000, 0x05000000, 0x040c2400, 0x000007f0, 0x000002d1, 0x00000077, 0x00000000,
	0x02051f0d, 0x00000000, 0x05000000, 0x040c2400, 0x00000a00, 0x0000032a, 0x00000086, 0x00000000,
	0x0306280e, 0x00000000, 0x06000000, 0x040c2400, 0x00000c99, 0x0000038d, 0x00000096, 0x00000000,
	0x03072918, 0x00000000, 0x07000000, 0x040c2400, 0x00000fe0, 0x000003fc, 0x000000a8, 0x00000000,
	0x04082a19, 0x00000000, 0x08000000, 0x040c2400, 0x00001400, 0x00000479, 0x000000bd, 0x00000000,
	0x04092c1b, 0x00000000, 0x09000000, 0x040c2400, 0x00001933, 0x00000505, 0x000000d4, 0x00000000,
	0x050a2d1c, 0x00000000, 0x0a000000, 0x040c2400, 0x00001fbf, 0x000005a2, 0x000000ee, 0x00000000,
	0x050b2f1d, 0x00000000, 0x0b000000, 0x040c2400, 0x00002800, 0x00000653, 0x0000010b, 0x00000000,
	0x060d381f, 0x00000000, 0x0c000000, 0x040c2400, 0x00003266, 0x00000719, 0x0000012c, 0x00000000,
	0x070e3928, 0x00000000, 0x0e000000, 0x040c2400, 0x00003f7f, 0x000007f8, 0x00000150, 0x00000000,
	0x08183a29, 0x00000000, 0x18000000, 0x040c2400, 0x00005000, 0x000008f2, 0x0000017a, 0x00000000,
	0x09193c2b, 0x00000000, 0x19000000, 0x040c2400, 0x000064cb, 0x00000a0a, 0x000001a8, 0x00000000,
	0x0a1b3d2c, 0x00000000, 0x1a000000, 0x040c2400, 0x00007efe, 0x00000b45, 0x000001dc, 0x00000000,
	0x0b1c3f2d, 0x00000000, 0x1b000000, 0x040c2400, 0x0000a000, 0x00000ca6, 0x00000216, 0x00000000,
	0x0d1d482f, 0x00000000, 0x1d000000, 0x040c2400, 0x0000c996, 0x00000e33, 0x00000257, 0x00000000,
	0x0e1f4938, 0x00000000, 0x1e000000, 0x040c2400, 0x0000fdfc, 0x00000ff0, 0x000002a1, 0x00000000,
	0x18284a39, 0x00000000, 0x28000000, 0x040c2400, 0x00014000, 0x000011e3, 0x000002f3, 0x00000000,
	0x19294c3b, 0x00000000, 0x29000000, 0x040c2400, 0x0001932d, 0x00001414, 0x00000350, 0x00000000,
	0x1b2b4d3c, 0x00000000, 0x2a000000, 0x040c2400, 0x0001fbf8, 0x0000168a, 0x000003b8, 0x00000000,
	0x1c2c4f3d, 0x00000000, 0x2b000000, 0x040c2400, 0x00028000, 0x0000194c, 0x0000042c, 0x00000000,
	0x1d2d583f, 0x00000000, 0x2d000000, 0x040c2400, 0x00032659, 0x00001c65, 0x000004af, 0x00000000,
	0x1f2f5948, 0x00000000, 0x2e000000, 0x040c2400, 0x0003f7f0, 0x00001fe0, 0x00000542, 0x00000000,
	0x28385a49, 0x00000000, 0x38000000, 0x040c2400, 0x00050000, 0x000023c7, 0x000005e7, 0x00000000,
	0x29395c4b, 0x00000000, 0x39000000, 0x040c2400, 0x00064cb3, 0x00002829, 0x000006a0, 0x00000000,
	0x2b3b5d4c, 0x00000000, 0x3a000000, 0x040c2400, 0x0007efe0, 0x00002d14, 0x0000076f, 0x00000000,
	0x2c3c5f4d, 0x00000000, 0x3b000000, 0x040c2400, 0x000a0000, 0x00003299, 0x00000858, 0x00000000,
	0x2d3d684f, 0x00000000, 0x3d000000, 0x040c2400, 0x000c9966, 0x000038cb, 0x0000095e, 0x00000000,
	0x2f3f6958, 0x00000000, 0x3e000000, 0x040c2400, 0x000fdfbf, 0x00003fbf, 0x00000a83, 0x00000000,
	0x38486a59, 0x00000000, 0x48000000, 0x040c2400, 0x00140000, 0x0000478e, 0x00000bcd, 0x00000000,
	0x39496c5b, 0x00000000, 0x49000000, 0x040c2400, 0x001932cc, 0x00005051, 0x00000d3f, 0x00000000,
	0x3b4b6d5c, 0x00000000, 0x4a000000, 0x040c2400, 0x001fbf7e, 0x00005a27, 0x00000ede, 0x00000000,
	0x3c4c6f5d, 0x00000000, 0x4b000000, 0x040c2400, 0x00280000, 0x00006531, 0x000010b0, 0x00000000,
	0x3d4d785f, 0x00000000, 0x4d000000, 0x040c2400, 0x00326597, 0x00007196, 0x000012bc, 0x00000000,
	0x3f4f7968, 0x00000000, 0x4e000000, 0x040c2400, 0x003f7efd, 0x00007f7f, 0x00001507, 0x00000000,
	0x48587a69, 0x00000000, 0x58000000, 0x040c2400, 0x00500000, 0x00008f1c, 0x0000179a, 0x00000000,
	0x49597c6b, 0x00000000, 0x59000000, 0x040c2400, 0x0064cb2f, 0x0000a0a2, 0x00001a7e, 0x00000000,
	0x4b5b7d6c, 0x00000000, 0x5a000000, 0x040c2400, 0x007efdf9, 0x0000b44e, 0x00001dbd, 0x00000000,
	0x4c5c7f6d, 0x00000000, 0x5b000000, 0x040c2400, 0x00a00000, 0x0000ca63, 0x00002161, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00c9965e, 0x0000e32c, 0x00002577, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x00fdfbf2, 0x0000fefd, 0x00002a0e, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01400000, 0x00001e37, 0x00002f34, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01932cbb, 0x00004144, 0x000034fc, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x01fbf7e5, 0x0000689c, 0x00003b79, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x02800000, 0x000094c6, 0x000042c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03265977, 0x0000c657, 0x00004aef, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x03f7efca, 0x0000fdfb, 0x0000541c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x05000000, 0x00003c6f, 0x00005e68, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x064cb2ee, 0x00008289, 0x000069f8, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x07efdf94, 0x0000d139, 0x000076f2, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x040c2400, 0x0a000000, 0x0000298b, 0x00008583, 0x00000000
};

const static uint32_t
gen10_hevc_enc_inter_const_lut32[GEN10_HEVC_ENC_INTER_CONST_LUT32_SIZE / 4] = {
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2c4a3b4a, 0x0001003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2a483948, 0x0001003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x283e2f3d, 0x00010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x1c3a2b3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x0f2e1f2d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0f2e292d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2c4a3b4a, 0x0001003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2a483948, 0x0001003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x283e2f3d, 0x00010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x1c3a2b3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x0f2e1f2d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0f2e292d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2c4a3b4a, 0x0001003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2a483948, 0x0001003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x283e2f3d, 0x00010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x1c3a2b3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x0f2e1f2d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0f2e292d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2c4a3b4a, 0x0001003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2a483948, 0x0001003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x283e2f3d, 0x00010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x1c3a2b3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x0f2e1f2d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0f2e292d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2c4a3b4a, 0x0001003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2a483948, 0x0001003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x283e2f3d, 0x00010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x1c3a2b3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x0f2e1f2d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0f2e292d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x2c4a3b4a, 0x0101003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x2a483948, 0x0101003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x283e2f3d, 0x01010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x1c3a2b3a, 0x0101002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x0f2e1f2d, 0x01010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x09281928, 0x0101001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x0f2e292d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x2c4a3b4a, 0x0101003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x2a483948, 0x0101003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x283e2f3d, 0x01010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x1c3a2b3a, 0x0101002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x0f2e1f2d, 0x01010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x09281928, 0x0101001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x0f2e292d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x2c4a3b4a, 0x0101003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x2a483948, 0x0101003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x283e2f3d, 0x01010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x1c3a2b3a, 0x0101002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x0f2e1f2d, 0x01010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x09281928, 0x0101001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x0f2e292d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x2c4a3b4a, 0x0101003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x2a483948, 0x0101003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x283e2f3d, 0x01010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x1c3a2b3a, 0x0101002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x0f2e1f2d, 0x01010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x09281928, 0x0101001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x0f2e292d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x2c4a3b4a, 0x0101003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x2a483948, 0x0101003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x283e2f3d, 0x01010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x1c3a2b3a, 0x0101002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x0f2e1f2d, 0x01010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05060b04, 0x09281928, 0x0101001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x09281928, 0x0001001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x0f2e292d, 0x00010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e191d, 0x00010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x2c4a3b4a, 0x0401003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x2a483948, 0x0401003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x283e2f3d, 0x04010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x1c3a2b3a, 0x0401002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x0f2e1f2d, 0x04010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x09281928, 0x0401001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x09281928, 0x0101001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x1c3a2e3a, 0x0201002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x1a382c38, 0x0201002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x0f2e292d, 0x02010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x0b2a1e2a, 0x0201001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x2c4a3b4a, 0x0401003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x2a483948, 0x0401003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x283e2f3d, 0x04010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x1c3a2b3a, 0x0401002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x0f2e1f2d, 0x04010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x09281928, 0x0401001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x09281928, 0x0101001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x1c3a2e3a, 0x0201002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x1a382c38, 0x0201002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x0f2e292d, 0x02010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x0b2a1e2a, 0x0201001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x2c4a3b4a, 0x0401003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x2a483948, 0x0401003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x283e2f3d, 0x04010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x1c3a2b3a, 0x0401002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x0f2e1f2d, 0x04010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0d191e0a, 0x09281928, 0x0401001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x09281928, 0x0101001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x1c3a2e3a, 0x0201002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x1a382c38, 0x0201002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x0f2e292d, 0x02010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x0b2a1e2a, 0x0201001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e0e0e05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020b04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x01020c04, 0x081f1b1f, 0x0101001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x01020c04, 0x081f1b1f, 0x0101001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x01020c04, 0x081f1b1f, 0x0101001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x0e1a280b, 0x2d4b3d4b, 0x04010048, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x0e1a280b, 0x2b493b49, 0x0401003d, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x0e1a280b, 0x293f383f, 0x0401003a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x0e1a280b, 0x1d3b2d3b, 0x04010038, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x0e1a280b, 0x192f282f, 0x0401002a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x0e1a280b, 0x0a291a29, 0x0401001c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x01020c04, 0x0a291a29, 0x0101001c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x1d3b383b, 0x02010038, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x1b392d39, 0x0201002d, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x192f2b2f, 0x0201002a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x0d2b282b, 0x02010028, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x18180f05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x01020c04, 0x081f1b1f, 0x0101001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x00d50001, 0x000000b1, 0x0000006a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x01020e05, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x01020e05, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x01020e05, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x181b290d, 0x2f4d3e4d, 0x05010049, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x181b290d, 0x2c4b3c4b, 0x0501003f, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x181b290d, 0x2a493a48, 0x0501003c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x181b290d, 0x1f3d2e3d, 0x05010039, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x181b290d, 0x1a392a38, 0x0501002c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x181b290d, 0x0b2a1b2a, 0x0501001e, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x01020e05, 0x0b2a1b2a, 0x0201001e, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x1f3d393d, 0x02010039, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x1c3b2f3b, 0x0201002f, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x1a392c38, 0x0201002c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x0e2d292d, 0x02010029, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x19191906, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x01020e05, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x00ef0001, 0x000000e0, 0x00000077, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x01031906, 0x0b2a1d29, 0x0202001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x01031906, 0x0b2a1d29, 0x0202001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x01031906, 0x0b2a1d29, 0x0202001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x384e484e, 0x0601004a, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x2e4c3d4c, 0x06010048, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x2b4a3b49, 0x0601003d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x283e383e, 0x0601003a, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x1b3a2b39, 0x0601002d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x0d2b1d2b, 0x06010028, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x01031906, 0x0d2b1d2b, 0x02010028, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x283e3a3e, 0x0302003a, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x1e3c383c, 0x03020038, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x1b3a2d39, 0x0302002d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x182e2a2e, 0x0302002a, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x01031906, 0x0b2a1d29, 0x0202001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x010c0002, 0x0000011a, 0x00000086, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x02041a07, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x02041a07, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x02041a07, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x39584958, 0x0702004b, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x384d3f4d, 0x07020049, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x2d4b3c4b, 0x0702003f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x29483948, 0x0702003b, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x1d3b2c3b, 0x0702002f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x0f2d1e2d, 0x07020029, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x02041a07, 0x0f2d1e2d, 0x03020029, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x29483b48, 0x0302003b, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x283d393d, 0x03020039, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x1d3b2f3b, 0x0302002f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x19382b38, 0x0302002b, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x02041a07, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x012d0002, 0x00000163, 0x00000096, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x02041b08, 0x0e2c282c, 0x03020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x02041b08, 0x0e2c282c, 0x03020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x02041b08, 0x0e2c282c, 0x03020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x3b594a59, 0x0802004c, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x394f484f, 0x0802004a, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x2e4c3d4c, 0x08020048, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x2b493a49, 0x0802003c, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x1e3c2d3c, 0x08020038, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x182e282e, 0x0802002a, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x02041b08, 0x182e282e, 0x0302002a, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x2b493d49, 0x0402003c, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x293f3b3f, 0x0402003a, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x1e3c383c, 0x04020038, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x1b392d39, 0x0402002c, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x02041b08, 0x0e2c282c, 0x03020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x01520002, 0x000001bf, 0x000000a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x02051c09, 0x0f2e292d, 0x03020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x02051c09, 0x0f2e292d, 0x03020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x02051c09, 0x0f2e292d, 0x03020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x3c5a4b5a, 0x0902004e, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x3a584958, 0x0902004c, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x384e3f4d, 0x09020049, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x2c4a3b4a, 0x0902003e, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x283e2f3d, 0x09020039, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x19382938, 0x0902002b, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x02051c09, 0x19382938, 0x0302002b, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x2c4a3e4a, 0x0402003e, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x2a483c48, 0x0402003c, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x283e393d, 0x04020039, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x1c3a2e3a, 0x0402002e, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x02051c09, 0x0f2e292d, 0x03020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x017c0002, 0x00000233, 0x000000bd, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x02051e0a, 0x192f2b2f, 0x0403002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x02051e0a, 0x192f2b2f, 0x0403002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x02051e0a, 0x192f2b2f, 0x0403002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x282b391d, 0x3d5b4d5b, 0x0a020058, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x282b391d, 0x3b594b59, 0x0a02004d, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x282b391d, 0x394f484f, 0x0a02004a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x282b391d, 0x2d4b3d4b, 0x0a020048, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x282b391d, 0x293f383f, 0x0a02003a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x282b391d, 0x1b392a39, 0x0a02002c, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x02051e0a, 0x1b392a39, 0x0402002c, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x2d4b484b, 0x05030048, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x2b493d49, 0x0503003d, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x293f3b3f, 0x0503003a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x1d3b383b, 0x05030038, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2929290c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x02051e0a, 0x192f2b2f, 0x0403002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x01aa0003, 0x000002c6, 0x000000d4, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x0306280b, 0x1a392c38, 0x0403002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x0306280b, 0x1a392c38, 0x0403002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x0306280b, 0x1a392c38, 0x0403002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x292c3a1e, 0x3f5d4e5d, 0x0c030059, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x292c3a1e, 0x3c5b4c5b, 0x0c03004f, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x292c3a1e, 0x3a594a58, 0x0c03004c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x292c3a1e, 0x2f4d3e4d, 0x0c030049, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x292c3a1e, 0x2a493a48, 0x0c03003c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x292c3a1e, 0x1c3a2b3a, 0x0c03002e, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x0306280b, 0x1c3a2b3a, 0x0403002e, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x2f4d494d, 0x06030049, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x2c4b3f4b, 0x0603003f, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x2a493c48, 0x0603003c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1f3d393d, 0x06030039, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2a2a2a0e, 0x1a392c38, 0x0603002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x0306280b, 0x1a392c38, 0x0403002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x01de0003, 0x0000037e, 0x000000ee, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x0307290c, 0x1b3a2d39, 0x0504002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x0307290c, 0x1b3a2d39, 0x0504002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x0307290c, 0x1b3a2d39, 0x0504002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2a2d3b28, 0x485e585e, 0x0d03005a, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2a2d3b28, 0x3e5c4d5c, 0x0d030058, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2a2d3b28, 0x3b5a4b59, 0x0d03004d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2a2d3b28, 0x384e484e, 0x0d03004a, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2a2d3b28, 0x2b4a3b49, 0x0d03003d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2a2d3b28, 0x1d3b2d3b, 0x0d030038, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x0307290c, 0x1d3b2d3b, 0x05030038, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x384e4a4e, 0x0604004a, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x2e4c484c, 0x06040048, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x2b4a3d49, 0x0604003d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x283e3a3e, 0x0604003a, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2b2b2b18, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x0307290c, 0x1b3a2d39, 0x0504002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x02190004, 0x00000466, 0x0000010b, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x04082a0e, 0x1d3b2f3b, 0x0604002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x04082a0e, 0x1d3b2f3b, 0x0604002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x04082a0e, 0x1d3b2f3b, 0x0604002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2b2f3c29, 0x49685968, 0x0f04005b, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2b2f3c29, 0x485d4f5d, 0x0f040059, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2b2f3c29, 0x3d5b4c5b, 0x0f04004f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2b2f3c29, 0x39584958, 0x0f04004b, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2b2f3c29, 0x2d4b3c4b, 0x0f04003f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2b2f3c29, 0x1f3d2e3d, 0x0f040039, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x04082a0e, 0x1f3d2e3d, 0x06040039, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x39584b58, 0x0704004b, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x384d494d, 0x07040049, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x2d4b3f4b, 0x0704003f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x29483b48, 0x0704003b, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2d2d2c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x04082a0e, 0x1d3b2f3b, 0x0604002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x025b0004, 0x0000058b, 0x0000012c, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x04092b18, 0x1e3c383c, 0x06050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x04092b18, 0x1e3c383c, 0x06050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x04092b18, 0x1e3c383c, 0x06050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2d393e2a, 0x4b695a69, 0x1904005c, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2d393e2a, 0x495f585f, 0x1904005a, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2d393e2a, 0x3e5c4d5c, 0x19040058, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2d393e2a, 0x3b594a59, 0x1904004c, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2d393e2a, 0x2e4c3d4c, 0x19040048, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2d393e2a, 0x283e383e, 0x1904003a, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x04092b18, 0x283e383e, 0x0604003a, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x3b594d59, 0x0805004c, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x394f4b4f, 0x0805004a, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x2e4c484c, 0x08050048, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x2b493d49, 0x0805003c, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2e2e2e1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x04092b18, 0x1e3c383c, 0x06050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x02a50005, 0x000006fc, 0x00000150, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x050a2c19, 0x283e393d, 0x07050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x050a2c19, 0x283e393d, 0x07050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x050a2c19, 0x283e393d, 0x07050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x2e3a3f2b, 0x4c6a5b6a, 0x1a05005e, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x2e3a3f2b, 0x4a685968, 0x1a05005c, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x2e3a3f2b, 0x485e4f5d, 0x1a050059, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x2e3a3f2b, 0x3c5a4b5a, 0x1a05004e, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x2e3a3f2b, 0x384e3f4d, 0x1a050049, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x2e3a3f2b, 0x29483948, 0x1a05003b, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x050a2c19, 0x29483948, 0x0705003b, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x3c5a4e5a, 0x0905004e, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x3a584c58, 0x0905004c, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x384e494d, 0x09050049, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x2c4a3e4a, 0x0905003e, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x38382f1b, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x050a2c19, 0x283e393d, 0x07050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x02f70005, 0x000008cd, 0x0000017a, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x060d381c, 0x293f3b3f, 0x0a06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x060d381c, 0x293f3b3f, 0x0a06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x060d381c, 0x293f3b3f, 0x0a06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3d4a2f, 0x4d6b5d6b, 0x1d050068, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3d4a2f, 0x4b695b69, 0x1d05005d, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3d4a2f, 0x495f585f, 0x1d05005a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3d4a2f, 0x3d5b4d5b, 0x1d050058, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3d4a2f, 0x394f484f, 0x1d05004a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3d4a2f, 0x2b493a49, 0x1d05003c, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x060d381c, 0x2b493a49, 0x0a05003c, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x3d5b585b, 0x0c060058, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x3b594d59, 0x0c06004d, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x394f4b4f, 0x0c06004a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x2d4b484b, 0x0c060048, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3a1f, 0x293f3b3f, 0x0c06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x060d381c, 0x293f3b3f, 0x0a06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x03540006, 0x00000b16, 0x000001a8, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x070f391e, 0x2a493c48, 0x0b07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x070f391e, 0x2a493c48, 0x0b07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x070f391e, 0x2a493c48, 0x0b07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3b3e4c39, 0x4f6d5e6d, 0x1f060069, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3b3e4c39, 0x4c6b5c6b, 0x1f06005f, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3b3e4c39, 0x4a695a68, 0x1f06005c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3b3e4c39, 0x3f5d4e5d, 0x1f060059, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3b3e4c39, 0x3a594a58, 0x1f06004c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3b3e4c39, 0x2c4a3b4a, 0x1f06003e, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x070f391e, 0x2c4a3b4a, 0x0b06003e, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x3f5d595d, 0x0e070059, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x3c5b4f5b, 0x0e07004f, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x3a594c58, 0x0e07004c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2f4d494d, 0x0e070049, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3c3c29, 0x2a493c48, 0x0e07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x070f391e, 0x2a493c48, 0x0b07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x03bd0007, 0x00000df8, 0x000001dc, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x08193a1f, 0x2b4a3d49, 0x0d08003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x08193a1f, 0x2b4a3d49, 0x0d08003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x08193a1f, 0x2b4a3d49, 0x0d08003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3c484d3a, 0x586e686e, 0x2807006a, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3c484d3a, 0x4e6c5d6c, 0x28070068, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3c484d3a, 0x4b6a5b69, 0x2807005d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3c484d3a, 0x485e585e, 0x2807005a, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3c484d3a, 0x3b5a4b59, 0x2807004d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3c484d3a, 0x2d4b3d4b, 0x28070048, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x08193a1f, 0x2d4b3d4b, 0x0d070048, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x485e5a5e, 0x1808005a, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x3e5c585c, 0x18080058, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x3b5a4d59, 0x1808004d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x384e4a4e, 0x1808004a, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d3d3d2a, 0x2b4a3d49, 0x1808003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x08193a1f, 0x2b4a3d49, 0x0d08003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x04320008, 0x0000119a, 0x00000216, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x091a3c29, 0x2d4b3f4b, 0x0e09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x091a3c29, 0x2d4b3f4b, 0x0e09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x091a3c29, 0x2d4b3f4b, 0x0e09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3e494f3b, 0x596f6978, 0x2908006b, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3e494f3b, 0x586d5f6d, 0x29080069, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3e494f3b, 0x4d6b5c6b, 0x2908005f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3e494f3b, 0x49685968, 0x2908005b, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3e494f3b, 0x3d5b4c5b, 0x2908004f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3e494f3b, 0x2f4d3e4d, 0x29080049, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x091a3c29, 0x2f4d3e4d, 0x0e080049, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x49685b68, 0x1909005b, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x485d595d, 0x19090059, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x3d5b4f5b, 0x1909004f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x39584b58, 0x1909004b, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f3f3f2b, 0x2d4b3f4b, 0x1909003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x091a3c29, 0x2d4b3f4b, 0x0e09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x04b60009, 0x0000162d, 0x00000257, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x0a1b3d2a, 0x2e4c484c, 0x180a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x0a1b3d2a, 0x2e4c484c, 0x180a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x0a1b3d2a, 0x2e4c484c, 0x180a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x3f4a583c, 0x5b6f6a79, 0x2a09006c, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x3f4a583c, 0x596f686f, 0x2a09006a, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x3f4a583c, 0x4e6c5d6c, 0x2a090068, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x3f4a583c, 0x4b695a69, 0x2a09005c, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x3f4a583c, 0x3e5c4d5c, 0x2a090058, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x3f4a583c, 0x384e484e, 0x2a09004a, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x0a1b3d2a, 0x384e484e, 0x1809004a, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x4b695d69, 0x1a0a005c, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x495f5b5f, 0x1a0a005a, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x3e5c585c, 0x1a0a0058, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x3b594d59, 0x1a0a004c, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4848482c, 0x2e4c484c, 0x1a0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x0a1b3d2a, 0x2e4c484c, 0x180a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0549000a, 0x00001bf0, 0x000002a1, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x0d1d482c, 0x384e494d, 0x1a0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x0d1d482c, 0x384e494d, 0x1a0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x0d1d482c, 0x384e494d, 0x1a0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x5c6f6b7a, 0x2c0a006e, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x5a6f6978, 0x2c0a006c, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x586e5f6d, 0x2c0a0069, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x4c6a5b6a, 0x2c0a005e, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x485e4f5d, 0x2c0a0059, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x39584958, 0x2c0a004b, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x0d1d482c, 0x39584958, 0x1a0a004b, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x4c6a5e6a, 0x1c0b005e, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x4a685c68, 0x1c0b005c, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x485e595d, 0x1c0b0059, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x3c5a4e5a, 0x1c0b004e, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x0d1d482c, 0x384e494d, 0x1a0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x05ef000b, 0x00002333, 0x000002f3, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x0e1f492d, 0x394f4b4f, 0x1b0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x0e1f492d, 0x394f4b4f, 0x1b0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x0e1f492d, 0x394f4b4f, 0x1b0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x5d6f6d7b, 0x2e0b0078, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x5b6f6b79, 0x2e0b006d, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x596f686f, 0x2e0b006a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x4d6b5d6b, 0x2e0b0068, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x495f585f, 0x2e0b005a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x3b594a59, 0x2e0b004c, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x0e1f492d, 0x3b594a59, 0x1b0b004c, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x4d6b686b, 0x1e0d0068, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x4b695d69, 0x1e0d005d, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x495f5b5f, 0x1e0d005a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x3d5b585b, 0x1e0d0058, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x0e1f492d, 0x394f4b4f, 0x1b0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x06a9000d, 0x00002c59, 0x00000350, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x18284a2f, 0x3a594c58, 0x1d0e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x18284a2f, 0x3a594c58, 0x1d0e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x18284a2f, 0x3a594c58, 0x1d0e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x5f6f6e7d, 0x380d0079, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x5c6f6c7b, 0x380d006f, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x5a6f6a78, 0x380d006c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x4f6d5e6d, 0x380d0069, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x4a695a68, 0x380d005c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x3c5a4b5a, 0x380d004e, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x18284a2f, 0x3c5a4b5a, 0x1d0d004e, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x4f6d696d, 0x280e0069, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x4c6b5f6b, 0x280e005f, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x4a695c68, 0x280e005c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3f5d595d, 0x280e0059, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x18284a2f, 0x3a594c58, 0x1d0e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x077a000e, 0x000037e0, 0x000003b8, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x19294b38, 0x3b5a4d59, 0x1e18004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x19294b38, 0x3b5a4d59, 0x1e18004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x19294b38, 0x3b5a4d59, 0x1e18004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x686f6f7e, 0x390f007a, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x5e6f6d7c, 0x390f0078, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x5b6f6b79, 0x390f006d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x586e686e, 0x390f006a, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x4b6a5b69, 0x390f005d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x3d5b4d5b, 0x390f0058, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x19294b38, 0x3d5b4d5b, 0x1e0f0058, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x586e6a6e, 0x2918006a, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x4e6c686c, 0x29180068, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x4b6a5d69, 0x2918005d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x485e5a5e, 0x2918005a, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x19294b38, 0x3b5a4d59, 0x1e18004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x08640010, 0x00004666, 0x0000042c, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x1a2a4d39, 0x3d5b4f5b, 0x2819004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x1a2a4d39, 0x3d5b4f5b, 0x2819004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x1a2a4d39, 0x3d5b4f5b, 0x2819004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x4f5a684c, 0x696f6f88, 0x3a18007b, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x4f5a684c, 0x686f6f7d, 0x3a180079, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x4f5a684c, 0x5d6f6c7b, 0x3a18006f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x4f5a684c, 0x596f6978, 0x3a18006b, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x4f5a684c, 0x4d6b5c6b, 0x3a18005f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x4f5a684c, 0x3f5d4e5d, 0x3a180059, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x1a2a4d39, 0x3f5d4e5d, 0x28180059, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x596f6b78, 0x2a19006b, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x586d696d, 0x2a190069, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x4d6b5f6b, 0x2a19005f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x49685b68, 0x2a19005b, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5858583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x1a2a4d39, 0x3d5b4f5b, 0x2819004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x096b0012, 0x000058b3, 0x000004af, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x1c2c4e3a, 0x3e5c585c, 0x291b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x1c2c4e3a, 0x3e5c585c, 0x291b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x1c2c4e3a, 0x3e5c585c, 0x291b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x585b694d, 0x6b6f6f89, 0x3b1a007c, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x585b694d, 0x696f6f7f, 0x3b1a007a, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x585b694d, 0x5e6f6d7c, 0x3b1a0078, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x585b694d, 0x5b6f6a79, 0x3b1a006c, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x585b694d, 0x4e6c5d6c, 0x3b1a0068, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x585b694d, 0x485e585e, 0x3b1a005a, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x1c2c4e3a, 0x485e585e, 0x291a005a, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x5b6f6d79, 0x2b1b006c, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x596f6b6f, 0x2b1b006a, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x4e6c686c, 0x2b1b0068, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x4b695d69, 0x2b1b005c, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5959593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x1c2c4e3a, 0x3e5c585c, 0x291b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x0a920015, 0x00006fc1, 0x00000542, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x1d2d583c, 0x485e595d, 0x2a1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x1d2d583c, 0x485e595d, 0x2a1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x1d2d583c, 0x485e595d, 0x2a1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x595c6a4f, 0x6c6f6f8a, 0x3c1b007e, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x595c6a4f, 0x6a6f6f88, 0x3c1b007c, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x595c6a4f, 0x686f6f7d, 0x3c1b0079, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x595c6a4f, 0x5c6f6b7a, 0x3c1b006e, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x595c6a4f, 0x586e5f6d, 0x3c1b0069, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x595c6a4f, 0x49685968, 0x3c1b005b, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x1d2d583c, 0x49685968, 0x2a1b005b, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x5c6f6e7a, 0x2c1c006e, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x5a6f6c78, 0x2c1c006c, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x586e696d, 0x2c1c0069, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x4c6a5e6a, 0x2c1c005e, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5a5a5a3f, 0x485e595d, 0x2c1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x1d2d583c, 0x485e595d, 0x2a1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x0bde0017, 0x00008ccd, 0x000005e7, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x1f2f593d, 0x495f5b5f, 0x2b1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x1f2f593d, 0x495f5b5f, 0x2b1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x1f2f593d, 0x495f5b5f, 0x2b1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5a5e6b58, 0x6d6f6f8b, 0x3e1c0088, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5a5e6b58, 0x6b6f6f89, 0x3e1c007d, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5a5e6b58, 0x696f6f7f, 0x3e1c007a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5a5e6b58, 0x5d6f6d7b, 0x3e1c0078, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5a5e6b58, 0x596f686f, 0x3e1c006a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5a5e6b58, 0x4b695a69, 0x3e1c005c, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x1f2f593d, 0x4b695a69, 0x2b1c005c, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x5d6f6f7b, 0x2e1d0078, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x5b6f6d79, 0x2e1d006d, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x596f6b6f, 0x2e1d006a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x4d6b686b, 0x2e1d0068, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5b5b5b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x1f2f593d, 0x495f5b5f, 0x2b1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x0d52001a, 0x0000b166, 0x000006a0, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x28385a3f, 0x4a695c68, 0x2d1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x28385a3f, 0x4a695c68, 0x2d1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x28385a3f, 0x4a695c68, 0x2d1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5c5f6c59, 0x6f6f6f8d, 0x481d0089, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5c5f6c59, 0x6c6f6f8b, 0x481d007f, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5c5f6c59, 0x6a6f6f88, 0x481d007c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5c5f6c59, 0x5f6f6e7d, 0x481d0079, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5c5f6c59, 0x5a6f6a78, 0x481d006c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5c5f6c59, 0x4c6a5b6a, 0x481d005e, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x28385a3f, 0x4c6a5b6a, 0x2d1d005e, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x5f6f6f7d, 0x381f0079, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x5c6f6f7b, 0x381f006f, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x5a6f6c78, 0x381f006c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4f6d696d, 0x381f0069, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5d5d5c49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x28385a3f, 0x4a695c68, 0x2d1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x0ef3001d, 0x0000df82, 0x0000076f, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x29395b48, 0x4b6a5d69, 0x2e28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x29395b48, 0x4b6a5d69, 0x2e28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x29395b48, 0x4b6a5d69, 0x2e28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5d696e5a, 0x6f6f6f8e, 0x491f008a, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5d696e5a, 0x6e6f6f8c, 0x491f0088, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5d696e5a, 0x6b6f6f89, 0x491f007d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5d696e5a, 0x686f6f7e, 0x491f007a, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5d696e5a, 0x5b6f6b79, 0x491f006d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5d696e5a, 0x4d6b5d6b, 0x491f0068, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x29395b48, 0x4d6b5d6b, 0x2e1f0068, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x686f6f7e, 0x3928007a, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x5e6f6f7c, 0x39280078, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x5b6f6d79, 0x3928006d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x586e6a6e, 0x3928006a, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x5e5e5e4a, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x29395b48, 0x4b6a5d69, 0x2e28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x10c80021, 0x0001199a, 0x00000858, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x2d3d684c, 0x4d6b5f6b, 0x3a29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x2d3d684c, 0x4d6b5f6b, 0x3a29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x2d3d684c, 0x4d6b5f6b, 0x3a29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x6f6f6f8f, 0x4d28008b, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x6f6f6f8d, 0x4d280089, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x6d6f6f8b, 0x4d28007f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x696f6f88, 0x4d28007b, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x5d6f6c7b, 0x4d28006f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x4f6d5e6d, 0x4d280069, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x2d3d684c, 0x4f6d5e6d, 0x3a280069, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x696f6f88, 0x3d29007b, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x686f6f7d, 0x3d290079, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x5d6f6f7b, 0x3d29006f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x596f6b78, 0x3d29006b, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x2d3d684c, 0x4d6b5f6b, 0x3a29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x12d60025, 0x000162cb, 0x0000095e, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x2f3f694d, 0x4e6c686c, 0x3b2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x2f3f694d, 0x4e6c686c, 0x3b2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x2f3f694d, 0x4e6c686c, 0x3b2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x6f6f6f8f, 0x4e2a008c, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x6f6f6f8f, 0x4e2a008a, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x6e6f6f8c, 0x4e2a0088, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x6b6f6f89, 0x4e2a007c, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x5e6f6d7c, 0x4e2a0078, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x586e686e, 0x4e2a006a, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x2f3f694d, 0x586e686e, 0x3b2a006a, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x6b6f6f89, 0x3e2b007c, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x696f6f7f, 0x3e2b007a, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x5e6f6f7c, 0x3e2b0078, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x5b6f6d79, 0x3e2b006c, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x2f3f694d, 0x4e6c686c, 0x3b2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x1525002a, 0x0001bf03, 0x00000a83, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x38486a4f, 0x586e696d, 0x3d2c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x38486a4f, 0x586e696d, 0x3d2c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x38486a4f, 0x586e696d, 0x3d2c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x6f6f6f8f, 0x582b008e, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x6f6f6f8f, 0x582b008c, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x6f6f6f8d, 0x582b0089, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x6c6f6f8a, 0x582b007e, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x686f6f7d, 0x582b0079, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x596f6978, 0x582b006b, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x38486a4f, 0x596f6978, 0x3d2b006b, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x6c6f6f8a, 0x482c007e, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x6a6f6f88, 0x482c007c, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x686f6f7d, 0x482c0079, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x5c6f6e7a, 0x482c006e, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x38486a4f, 0x586e696d, 0x3d2c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x17bb002f, 0x00023333, 0x00000bcd, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x39496b58, 0x596f6b6f, 0x3e2d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x39496b58, 0x596f6b6f, 0x3e2d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x39496b58, 0x596f6b6f, 0x3e2d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x6f6f6f8f, 0x592c008f, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x6f6f6f8f, 0x592c008d, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x6f6f6f8f, 0x592c008a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x6d6f6f8b, 0x592c0088, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x696f6f7f, 0x592c007a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x5b6f6a79, 0x592c006c, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x39496b58, 0x5b6f6a79, 0x3e2c006c, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x6d6f6f8b, 0x492d0088, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x6b6f6f89, 0x492d007d, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x696f6f7f, 0x492d007a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x5d6f6f7b, 0x492d0078, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x39496b58, 0x596f6b6f, 0x3e2d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x1aa30035, 0x0002c596, 0x00000d3f, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x3b4a6d59, 0x5a6f6c78, 0x482f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x3b4a6d59, 0x5a6f6c78, 0x482f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x3b4a6d59, 0x5a6f6c78, 0x482f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x6f6f6f8f, 0x5a2d008f, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x6f6f6f8f, 0x5a2d008f, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x6f6f6f8f, 0x5a2d008c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x6f6f6f8d, 0x5a2d0089, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x6a6f6f88, 0x5a2d007c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x5c6f6b7a, 0x5a2d006e, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x3b4a6d59, 0x5c6f6b7a, 0x482d006e, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x6f6f6f8d, 0x4a2f0089, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x6c6f6f8b, 0x4a2f007f, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x6a6f6f88, 0x4a2f007c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5f6f6f7d, 0x4a2f0079, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x3b4a6d59, 0x5a6f6c78, 0x482f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x1de6003b, 0x00037e06, 0x00000ede, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x21900043, 0x00046666, 0x000010b0, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x3d4d785c, 0x5d6f6f7b, 0x4a39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x3d4d785c, 0x5d6f6f7b, 0x4a39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x3d4d785c, 0x5d6f6f7b, 0x4a39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x797c8a6f, 0x6f6f6f8f, 0x5d38008f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x797c8a6f, 0x6f6f6f8f, 0x5d38008f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x797c8a6f, 0x6f6f6f8f, 0x5d38008f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x797c8a6f, 0x6f6f6f8f, 0x5d38008b, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x797c8a6f, 0x6d6f6f8b, 0x5d38007f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x797c8a6f, 0x5f6f6e7d, 0x5d380079, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x3d4d785c, 0x5f6f6e7d, 0x4a380079, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x6f6f6f8f, 0x4d39008b, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x6f6f6f8d, 0x4d390089, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x6d6f6f8b, 0x4d39007f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x696f6f88, 0x4d39007b, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x7a7a7a5f, 0x5d6f6f7b, 0x4d39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x685c4e39, 0x6f6f6d6b, 0x3d4d785c, 0x5d6f6f7b, 0x4a39006f, 0x0107cdcd, 0x00000000, 0x040c2458,
	0x02800280, 0x25ac004b, 0x00058b2d, 0x000012bc, 0x00000021, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x3f4f795d, 0x5e6f6f7c, 0x4b3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x3f4f795d, 0x5e6f6f7c, 0x4b3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x3f4f795d, 0x5e6f6f7c, 0x4b3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7b7e8b6f, 0x6f6f6f8f, 0x5e3a008f, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7b7e8b6f, 0x6f6f6f8f, 0x5e3a008f, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7b7e8b6f, 0x6f6f6f8f, 0x5e3a008f, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7b7e8b6f, 0x6f6f6f8f, 0x5e3a008c, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7b7e8b6f, 0x6e6f6f8c, 0x5e3a0088, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7b7e8b6f, 0x686f6f7e, 0x5e3a007a, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x3f4f795d, 0x686f6f7e, 0x4b3a007a, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x6f6f6f8f, 0x4e3b008c, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x6f6f6f8f, 0x4e3b008a, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x6e6f6f8c, 0x4e3b0088, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x6b6f6f89, 0x4e3b007c, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x7c7c7b68, 0x5e6f6f7c, 0x4e3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x695d583b, 0x6f6f6f6c, 0x3f4f795d, 0x5e6f6f7c, 0x4b3b0078, 0x0127cdcd, 0x00000000, 0x040c2459,
	0x02ce02ce, 0x2a490054, 0x0006fc0c, 0x00001507, 0x00000025, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x48587a5f, 0x686f6f7d, 0x4d3c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x48587a5f, 0x686f6f7d, 0x4d3c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x48587a5f, 0x686f6f7d, 0x4d3c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7c888d6f, 0x6f6f6f8f, 0x683b008f, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7c888d6f, 0x6f6f6f8f, 0x683b008f, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7c888d6f, 0x6f6f6f8f, 0x683b008f, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7c888d6f, 0x6f6f6f8f, 0x683b008e, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7c888d6f, 0x6f6f6f8d, 0x683b0089, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7c888d6f, 0x696f6f88, 0x683b007b, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x48587a5f, 0x696f6f88, 0x4d3b007b, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x6f6f6f8f, 0x583c008e, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x6f6f6f8f, 0x583c008c, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x6f6f6f8d, 0x583c0089, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x6c6f6f8a, 0x583c007e, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x7d7d7d69, 0x686f6f7d, 0x583c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6a5f593c, 0x6f6f6f6d, 0x48587a5f, 0x686f6f7d, 0x4d3c0079, 0x014ccdcd, 0x00000000, 0x040c245a,
	0x03260326, 0x2f77005e, 0x0008cccd, 0x0000179a, 0x00000029, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x49597b68, 0x696f6f7f, 0x4e3d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x49597b68, 0x696f6f7f, 0x4e3d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x49597b68, 0x696f6f7f, 0x4e3d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7d898e6f, 0x6f6f6f8f, 0x693c008f, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7d898e6f, 0x6f6f6f8f, 0x693c008f, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7d898e6f, 0x6f6f6f8f, 0x693c008f, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7d898e6f, 0x6f6f6f8f, 0x693c008f, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7d898e6f, 0x6f6f6f8f, 0x693c008a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7d898e6f, 0x6b6f6f89, 0x693c007c, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x49597b68, 0x6b6f6f89, 0x4e3c007c, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x6f6f6f8f, 0x593d008f, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x6f6f6f8f, 0x593d008d, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x6f6f6f8f, 0x593d008a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x6d6f6f8b, 0x593d0088, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x7f7f7e6a, 0x696f6f7f, 0x593d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6c685a3d, 0x6f6f6f6f, 0x49597b68, 0x696f6f7f, 0x4e3d007a, 0x0174cdcd, 0x00000000, 0x040c245c,
	0x03890389, 0x3547006a, 0x000b165a, 0x00001a7e, 0x0000002e, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x4b5a7d69, 0x6a6f6f88, 0x583f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x4b5a7d69, 0x6a6f6f88, 0x583f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x4b5a7d69, 0x6a6f6f88, 0x583f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x7f8a8f6f, 0x6f6f6f8f, 0x6a3d008f, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x7f8a8f6f, 0x6f6f6f8f, 0x6a3d008f, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x7f8a8f6f, 0x6f6f6f8f, 0x6a3d008f, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x7f8a8f6f, 0x6f6f6f8f, 0x6a3d008f, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x7f8a8f6f, 0x6f6f6f8f, 0x6a3d008c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x7f8a8f6f, 0x6c6f6f8a, 0x6a3d007e, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x4b5a7d69, 0x6c6f6f8a, 0x583d007e, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6f6f6f8f, 0x5a3f008f, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6f6f6f8f, 0x5a3f008f, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6f6f6f8f, 0x5a3f008c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6f6f6f8d, 0x5a3f0089, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x8888886c, 0x6a6f6f88, 0x5a3f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6d695b3f, 0x6f6f6f6f, 0x4b5a7d69, 0x6a6f6f88, 0x583f007c, 0x01a2cdcd, 0x00000000, 0x040c245d,
	0x03f803f8, 0x3bcd0077, 0x000df819, 0x00001dbd, 0x00000034, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6f6f6f8f, 0x6b3f008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x888b8f6f, 0x6d6f6f8b, 0x6b3f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6d6f6f8b, 0x593f0088, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008f, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8f, 0x5b48008d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6f6f6f8e, 0x5b48008a, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x8989896d, 0x6b6f6f89, 0x5b48007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x6f6a5d48, 0x6f6f6f6f, 0x4c5c7e6b, 0x6b6f6f89, 0x5948007d, 0x01d5cdcd, 0x00000000, 0x040c245f,
	0x04750475, 0x43200086, 0x0011999a, 0x00002161, 0x0000003a, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x1c3a2b3a, 0x0000002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x1a382938, 0x0000002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x0f2e1f2d, 0x00000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x0b2a1b2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x071e0f1d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x0b2a1e2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x09281c28, 0x0000001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x071e191d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x051a0e1a, 0x0000000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x1c3a2b3a, 0x0000002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x1a382938, 0x0000002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x0f2e1f2d, 0x00000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x0b2a1b2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x071e0f1d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x0b2a1e2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x09281c28, 0x0000001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x071e191d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x051a0e1a, 0x0000000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x1c3a2b3a, 0x0000002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x1a382938, 0x0000002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x0f2e1f2d, 0x00000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x0b2a1b2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x071e0f1d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x0b2a1e2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x09281c28, 0x0000001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x071e191d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x051a0e1a, 0x0000000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x1c3a2b3a, 0x0000002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x1a382938, 0x0000002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x0f2e1f2d, 0x00000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x0b2a1b2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x071e0f1d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x0b2a1e2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x09281c28, 0x0000001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x071e191d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x051a0e1a, 0x0000000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x1c3a2b3a, 0x0000002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x1a382938, 0x0000002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x0f2e1f2d, 0x00000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x0b2a1b2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x071e0f1d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000100, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x0b2a1e2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x09281c28, 0x0000001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x071e191d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x051a0e1a, 0x0000000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000000, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x1c3a2b3a, 0x0000002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x1a382938, 0x0000002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x0f2e1f2d, 0x00000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x0b2a1b2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x071e0f1d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x0b2a1e2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x09281c28, 0x0000001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x071e191d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x051a0e1a, 0x0000000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x1c3a2b3a, 0x0000002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x1a382938, 0x0000002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x0f2e1f2d, 0x00000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x0b2a1b2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x071e0f1d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x0b2a1e2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x09281c28, 0x0000001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x071e191d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x051a0e1a, 0x0000000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x1c3a2b3a, 0x0000002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x1a382938, 0x0000002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x0f2e1f2d, 0x00000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x0b2a1b2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x071e0f1d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x0b2a1e2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x09281c28, 0x0000001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x071e191d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x051a0e1a, 0x0000000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x1c3a2b3a, 0x0000002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x1a382938, 0x0000002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x0f2e1f2d, 0x00000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x0b2a1b2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x071e0f1d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x0b2a1e2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x09281c28, 0x0000001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x071e191d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x051a0e1a, 0x0000000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x1c3a2b3a, 0x0000002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x1a382938, 0x0000002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x0f2e1f2d, 0x00000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x0b2a1b2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x071e0f1d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02030502, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x0b2a1e2a, 0x0000001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x09281c28, 0x0000001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x071e191d, 0x00000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x051a0e1a, 0x0000000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x02020201, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00000200, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x1c3a2b3a, 0x0200002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x1a382938, 0x0200002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x0f2e1f2d, 0x02000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x0b2a1b2a, 0x0200001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x071e0f1d, 0x02000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x04180918, 0x0200000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x0b2a1e2a, 0x0100001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x09281c28, 0x0100001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x071e191d, 0x01000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x051a0e1a, 0x0100000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x1c3a2b3a, 0x0200002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x1a382938, 0x0200002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x0f2e1f2d, 0x02000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x0b2a1b2a, 0x0200001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x071e0f1d, 0x02000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x04180918, 0x0200000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x0b2a1e2a, 0x0100001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x09281c28, 0x0100001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x071e191d, 0x01000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x051a0e1a, 0x0100000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x1c3a2b3a, 0x0200002e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x1a382938, 0x0200002c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x0f2e1f2d, 0x02000029, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x0b2a1b2a, 0x0200001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x071e0f1d, 0x02000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x06080e05, 0x04180918, 0x0200000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x04180918, 0x0000000b, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x0b2a1e2a, 0x0100001e, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x09281c28, 0x0100001c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x071e191d, 0x01000019, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x051a0e1a, 0x0100000d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x07070702, 0x030d090d, 0x01000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05030200, 0x0b090806, 0x00010502, 0x030d090d, 0x00000009, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00060006, 0x00be0000, 0x0000008d, 0x0000005e, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x00010602, 0x040f0a0e, 0x0000000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x00010602, 0x040f0a0e, 0x0000000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x00010602, 0x040f0a0e, 0x0000000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x07090f05, 0x1d3b2d3b, 0x02000038, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x07090f05, 0x1b392b39, 0x0200002d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x07090f05, 0x192f282f, 0x0200002a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x07090f05, 0x0d2b1d2b, 0x02000028, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x07090f05, 0x081f181f, 0x0200001a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x07090f05, 0x05190a19, 0x0200000c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x00010602, 0x05190a19, 0x0000000c, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x0d2b282b, 0x01000028, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x0b291d29, 0x0100001d, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x081f1b1f, 0x0100001a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x061b0f1b, 0x0100000f, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x08080702, 0x040f0a0e, 0x0100000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x05040200, 0x0c0a0907, 0x00010602, 0x040f0a0e, 0x0000000a, 0x0002cdcd, 0x00000000, 0x040c2402,
	0x00070007, 0x00d50000, 0x000000b1, 0x0000006a, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x00010702, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x00010702, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x00010702, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x080a1906, 0x1f3d2e3d, 0x02000039, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x080a1906, 0x1c3b2c3b, 0x0200002f, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x080a1906, 0x1a392a38, 0x0200002c, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x080a1906, 0x0e2d1e2d, 0x02000029, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x080a1906, 0x09291a28, 0x0200001c, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x080a1906, 0x051a0b1a, 0x0200000e, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x00010702, 0x051a0b1a, 0x0100000e, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x0e2d292d, 0x01000029, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x0c2b1f2b, 0x0100001f, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x09291c28, 0x0100001c, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x071d191d, 0x01000019, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x09090803, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x06040200, 0x0e0c0a08, 0x00010702, 0x04190b18, 0x0100000b, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00070007, 0x00ef0000, 0x000000e0, 0x00000077, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x00010803, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x00010803, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x00010803, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0a0d1b08, 0x283e383e, 0x0300003a, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0a0d1b08, 0x1e3c2d3c, 0x03000038, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0a0d1b08, 0x1b3a2b39, 0x0300002d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0a0d1b08, 0x182e282e, 0x0300002a, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0a0d1b08, 0x0b2a1b29, 0x0300001d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0a0d1b08, 0x061b0c1b, 0x0300000f, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x00010803, 0x061b0c1b, 0x0100000f, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x182e2a2e, 0x0101002a, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x0d2c282c, 0x01010028, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x0b2a1d29, 0x0101001d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x081e1a1e, 0x0101001a, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x0b0b0a04, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x07050301, 0x0f0d0b09, 0x00010803, 0x051a0d19, 0x0101000d, 0x0003cdcd, 0x00000000, 0x040c2403,
	0x00080008, 0x010c0001, 0x0000011a, 0x00000086, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x01020903, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x01020903, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x01020903, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0b0f1c09, 0x29483948, 0x0301003b, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0b0f1c09, 0x283d2f3d, 0x03010039, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0b0f1c09, 0x1d3b2c3b, 0x0301002f, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0b0f1c09, 0x19382938, 0x0301002b, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0b0f1c09, 0x0c2b1c2b, 0x0301001f, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0b0f1c09, 0x071d0e1d, 0x03010019, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x01020903, 0x071d0e1d, 0x01010019, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x19382b38, 0x0101002b, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x0f2d292d, 0x01010029, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x0c2b1f2b, 0x0101001f, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x09281b28, 0x0101001b, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x0c0c0c04, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x08050301, 0x190f0c0a, 0x01020903, 0x061b0f1b, 0x0101000e, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000a000a, 0x012d0001, 0x00000163, 0x00000096, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x01020b04, 0x071c181c, 0x01010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x01020b04, 0x071c181c, 0x01010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x01020b04, 0x071c181c, 0x01010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0c191e0a, 0x2b493a49, 0x0401003c, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0c191e0a, 0x293f383f, 0x0401003a, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0c191e0a, 0x1e3c2d3c, 0x04010038, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0c191e0a, 0x1b392a39, 0x0401002c, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0c191e0a, 0x0e2c1d2c, 0x04010028, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0c191e0a, 0x081e181e, 0x0401001a, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x01020b04, 0x081e181e, 0x0101001a, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x1b392d39, 0x0201002c, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x192f2b2f, 0x0201002a, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x0e2c282c, 0x02010028, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x0a291d29, 0x0201001c, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x0e0e0d05, 0x071c181c, 0x02010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x09060301, 0x1a190e0b, 0x01020b04, 0x071c181c, 0x01010018, 0x0004cdcd, 0x00000000, 0x040c2404,
	0x000b000b, 0x01520001, 0x000001bf, 0x000000a8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020c04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020c04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020c04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e1a1f0b, 0x2c4a3b4a, 0x0401003e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e1a1f0b, 0x2a483948, 0x0401003c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e1a1f0b, 0x283e2f3d, 0x04010039, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e1a1f0b, 0x1c3a2b3a, 0x0401002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e1a1f0b, 0x0f2e1f2d, 0x04010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x0e1a1f0b, 0x09281928, 0x0401001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020c04, 0x09281928, 0x0101001b, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x1c3a2e3a, 0x0201002e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x1a382c38, 0x0201002c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x0f2e292d, 0x02010029, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x0b2a1e2a, 0x0201001e, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x180f0f05, 0x071e191d, 0x02010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01020c04, 0x071e191d, 0x01010019, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000c000c, 0x017c0001, 0x00000233, 0x000000bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x01020d05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x01020d05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x01020d05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x181b290c, 0x2d4b3d4b, 0x05010048, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x181b290c, 0x2b493b49, 0x0501003d, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x181b290c, 0x293f383f, 0x0501003a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x181b290c, 0x1d3b2d3b, 0x05010038, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x181b290c, 0x192f282f, 0x0501002a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x181b290c, 0x0a291a29, 0x0501001c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x01020d05, 0x0a291a29, 0x0201001c, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x1d3b383b, 0x02010038, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x1b392d39, 0x0201002d, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x192f2b2f, 0x0201002a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x0d2b282b, 0x02010028, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x19191906, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0b080401, 0x1c1b190e, 0x01020d05, 0x081f1b1f, 0x0201001a, 0x0005cdcd, 0x00000000, 0x040c2405,
	0x000e000e, 0x01aa0001, 0x000002c6, 0x000000d4, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x01030f05, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x01030f05, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x01030f05, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x191c2a0e, 0x2f4d3e4d, 0x06010049, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x191c2a0e, 0x2c4b3c4b, 0x0601003f, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x191c2a0e, 0x2a493a48, 0x0601003c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x191c2a0e, 0x1f3d2e3d, 0x06010039, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x191c2a0e, 0x1a392a38, 0x0601002c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x191c2a0e, 0x0b2a1b2a, 0x0601001e, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x01030f05, 0x0b2a1b2a, 0x0201001e, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x1f3d393d, 0x03010039, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x1c3b2f3b, 0x0301002f, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x1a392c38, 0x0301002c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x0e2d292d, 0x03010029, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x1a1a1a07, 0x09291c28, 0x0301001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0d090501, 0x1e1c1a18, 0x01030f05, 0x09291c28, 0x0201001c, 0x0006cdcd, 0x00000000, 0x040c2406,
	0x000f000f, 0x01de0001, 0x0000037e, 0x000000ee, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x01031906, 0x0b2a1d29, 0x0202001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x01031906, 0x0b2a1d29, 0x0202001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x01031906, 0x0b2a1d29, 0x0202001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x384e484e, 0x0601004a, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x2e4c3d4c, 0x06010048, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x2b4a3b49, 0x0601003d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x283e383e, 0x0601003a, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x1b3a2b39, 0x0601002d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1a1d2b18, 0x0d2b1d2b, 0x06010028, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x01031906, 0x0d2b1d2b, 0x02010028, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x283e3a3e, 0x0302003a, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x1e3c383c, 0x03020038, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x1b3a2d39, 0x0302002d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x182e2a2e, 0x0302002a, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x1b1b1b08, 0x0b2a1d29, 0x0302001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0e0a0602, 0x281e1c19, 0x01031906, 0x0b2a1d29, 0x0202001d, 0x0007cdcd, 0x00000000, 0x040c2407,
	0x00110011, 0x02190002, 0x00000466, 0x0000010b, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x02041a07, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x02041a07, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x02041a07, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x39584958, 0x0702004b, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x384d3f4d, 0x07020049, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x2d4b3c4b, 0x0702003f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x29483948, 0x0702003b, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x1d3b2c3b, 0x0702002f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1b1f2c19, 0x0f2d1e2d, 0x07020029, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x02041a07, 0x0f2d1e2d, 0x03020029, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x29483b48, 0x0302003b, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x283d393d, 0x03020039, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x1d3b2f3b, 0x0302002f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x19382b38, 0x0302002b, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x1d1d1c09, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x180b0702, 0x291f1d1b, 0x02041a07, 0x0c2b1f2b, 0x0302001f, 0x0008cdcd, 0x00000000, 0x040c2408,
	0x00140014, 0x025b0002, 0x0000058b, 0x0000012c, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x02041b08, 0x0e2c282c, 0x03020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x02041b08, 0x0e2c282c, 0x03020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x02041b08, 0x0e2c282c, 0x03020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x3b594a59, 0x0802004c, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x394f484f, 0x0802004a, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x2e4c3d4c, 0x08020048, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x2b493a49, 0x0802003c, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x1e3c2d3c, 0x08020038, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1d292e1a, 0x182e282e, 0x0802002a, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x02041b08, 0x182e282e, 0x0302002a, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x2b493d49, 0x0402003c, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x293f3b3f, 0x0402003a, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x1e3c383c, 0x04020038, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x1b392d39, 0x0402002c, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x1e1e1e0a, 0x0e2c282c, 0x04020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x190d0702, 0x2a291f1c, 0x02041b08, 0x0e2c282c, 0x03020028, 0x0009cdcd, 0x00000000, 0x040c2409,
	0x00160016, 0x02a50002, 0x000006fc, 0x00000150, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x02051c09, 0x0f2e292d, 0x03020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x02051c09, 0x0f2e292d, 0x03020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x02051c09, 0x0f2e292d, 0x03020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x3c5a4b5a, 0x0902004e, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x3a584958, 0x0902004c, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x384e3f4d, 0x09020049, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x2c4a3b4a, 0x0902003e, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x283e2f3d, 0x09020039, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x1e2a2f1b, 0x19382938, 0x0902002b, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x02051c09, 0x19382938, 0x0302002b, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x2c4a3e4a, 0x0402003e, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x2a483c48, 0x0402003c, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x283e393d, 0x04020039, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x1c3a2e3a, 0x0402002e, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x28281f0b, 0x0f2e292d, 0x04020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1a0e0802, 0x2b2a281d, 0x02051c09, 0x0f2e292d, 0x03020029, 0x000acdcd, 0x00000000, 0x040c240a,
	0x00190019, 0x02f70002, 0x000008cd, 0x0000017a, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x0306280c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x0306280c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x0306280c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2a2d3a1f, 0x3d5b4d5b, 0x0c020058, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2a2d3a1f, 0x3b594b59, 0x0c02004d, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2a2d3a1f, 0x394f484f, 0x0c02004a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2a2d3a1f, 0x2d4b3d4b, 0x0c020048, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2a2d3a1f, 0x293f383f, 0x0c02003a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2a2d3a1f, 0x1b392a39, 0x0c02002c, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x0306280c, 0x1b392a39, 0x0502002c, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x2d4b484b, 0x06030048, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x2b493d49, 0x0603003d, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x293f3b3f, 0x0603003a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x1d3b383b, 0x06030038, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x2b2b2a0f, 0x192f2b2f, 0x0603002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1c180903, 0x2c2b291f, 0x0306280c, 0x192f2b2f, 0x0503002a, 0x000bcdcd, 0x00000000, 0x040c240b,
	0x001c001c, 0x03540003, 0x00000b16, 0x000001a8, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x0307290d, 0x1a392c38, 0x0503002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x0307290d, 0x1a392c38, 0x0503002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x0307290d, 0x1a392c38, 0x0503002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2b2e3c29, 0x3f5d4e5d, 0x0e030059, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2b2e3c29, 0x3c5b4c5b, 0x0e03004f, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2b2e3c29, 0x3a594a58, 0x0e03004c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2b2e3c29, 0x2f4d3e4d, 0x0e030049, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2b2e3c29, 0x2a493a48, 0x0e03003c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2b2e3c29, 0x1c3a2b3a, 0x0e03002e, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x0307290d, 0x1c3a2b3a, 0x0503002e, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x2f4d494d, 0x07030049, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x2c4b3f4b, 0x0703003f, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x2a493c48, 0x0703003c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1f3d393d, 0x07030039, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x2c2c2c19, 0x1a392c38, 0x0703002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1d190b03, 0x2e2c2a28, 0x0307290d, 0x1a392c38, 0x0503002c, 0x000dcdcd, 0x00000000, 0x040c240d,
	0x001f001f, 0x03bd0003, 0x00000df8, 0x000001dc, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x04082a0f, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x04082a0f, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x04082a0f, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2c383d2a, 0x485e585e, 0x1803005a, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2c383d2a, 0x3e5c4d5c, 0x18030058, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2c383d2a, 0x3b5a4b59, 0x1803004d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2c383d2a, 0x384e484e, 0x1803004a, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2c383d2a, 0x2b4a3b49, 0x1803003d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2c383d2a, 0x1d3b2d3b, 0x18030038, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x04082a0f, 0x1d3b2d3b, 0x06030038, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x384e4a4e, 0x0804004a, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x2e4c484c, 0x08040048, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x2b4a3d49, 0x0804003d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x283e3a3e, 0x0804003a, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x2d2d2d1a, 0x1b3a2d39, 0x0804002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x1f1a0c04, 0x382e2c29, 0x04082a0f, 0x1b3a2d39, 0x0604002d, 0x000ecdcd, 0x00000000, 0x040c240e,
	0x00230023, 0x04320004, 0x0000119a, 0x00000216, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x04092c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x04092c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x04092c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2e393f2b, 0x49685968, 0x1904005b, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2e393f2b, 0x485d4f5d, 0x19040059, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2e393f2b, 0x3d5b4c5b, 0x1904004f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2e393f2b, 0x39584958, 0x1904004b, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2e393f2b, 0x2d4b3c4b, 0x1904003f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2e393f2b, 0x1f3d2e3d, 0x19040039, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x04092c19, 0x1f3d2e3d, 0x07040039, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x39584b58, 0x0904004b, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x384d494d, 0x09040049, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x2d4b3f4b, 0x0904003f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x29483b48, 0x0904003b, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x2f2f2f1b, 0x1d3b2f3b, 0x0904002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x281c0e04, 0x392f2d2b, 0x04092c19, 0x1d3b2f3b, 0x0704002f, 0x0010cdcd, 0x00000000, 0x040c2418,
	0x00280028, 0x04b60004, 0x0000162d, 0x00000257, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x050a2d1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x050a2d1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x050a2d1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2f3a482c, 0x4b695a69, 0x1a04005c, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2f3a482c, 0x495f585f, 0x1a04005a, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2f3a482c, 0x3e5c4d5c, 0x1a040058, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2f3a482c, 0x3b594a59, 0x1a04004c, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2f3a482c, 0x2e4c3d4c, 0x1a040048, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x2f3a482c, 0x283e383e, 0x1a04003a, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x050a2d1a, 0x283e383e, 0x0804003a, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x3b594d59, 0x0a05004c, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x394f4b4f, 0x0a05004a, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x2e4c484c, 0x0a050048, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x2b493d49, 0x0a05003c, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x3838381c, 0x1e3c383c, 0x0a050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x291d0f05, 0x3a392f2c, 0x050a2d1a, 0x1e3c383c, 0x08050038, 0x0012cdcd, 0x00000000, 0x040c2419,
	0x002c002c, 0x05490005, 0x00001bf0, 0x000002a1, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x060c381c, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x060c381c, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x060c381c, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x393c4a2f, 0x4c6a5b6a, 0x1c05005e, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x393c4a2f, 0x4a685968, 0x1c05005c, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x393c4a2f, 0x485e4f5d, 0x1c050059, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x393c4a2f, 0x3c5a4b5a, 0x1c05004e, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x393c4a2f, 0x384e3f4d, 0x1c050049, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x393c4a2f, 0x29483948, 0x1c05003b, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x060c381c, 0x29483948, 0x0905003b, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x3c5a4e5a, 0x0c05004e, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x3a584c58, 0x0c05004c, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x384e494d, 0x0c050049, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x2c4a3e4a, 0x0c05003e, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x3a3a3a1f, 0x283e393d, 0x0c050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2a1f1905, 0x3b3a382d, 0x060c381c, 0x283e393d, 0x09050039, 0x0014cdcd, 0x00000000, 0x040c241a,
	0x00320032, 0x05ef0005, 0x00002333, 0x000002f3, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x070e391d, 0x293f3b3f, 0x0b06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x070e391d, 0x293f3b3f, 0x0b06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x070e391d, 0x293f3b3f, 0x0b06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3e4b38, 0x4d6b5d6b, 0x1e050068, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3e4b38, 0x4b695b69, 0x1e05005d, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3e4b38, 0x495f585f, 0x1e05005a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3e4b38, 0x3d5b4d5b, 0x1e050058, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3e4b38, 0x394f484f, 0x1e05004a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3a3e4b38, 0x2b493a49, 0x1e05003c, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x070e391d, 0x2b493a49, 0x0b05003c, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x3d5b585b, 0x0d060058, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x3b594d59, 0x0d06004d, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x394f4b4f, 0x0d06004a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x2d4b484b, 0x0d060048, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x3b3b3b28, 0x293f3b3f, 0x0d06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2c281a06, 0x3c3b392f, 0x070e391d, 0x293f3b3f, 0x0b06003a, 0x0017cdcd, 0x00000000, 0x040c241c,
	0x00380038, 0x06a90006, 0x00002c59, 0x00000350, 0x00000002, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x08183a1f, 0x2a493c48, 0x0c07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x08183a1f, 0x2a493c48, 0x0c07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x08183a1f, 0x2a493c48, 0x0c07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3f4c39, 0x4f6d5e6d, 0x28060069, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3f4c39, 0x4c6b5c6b, 0x2806005f, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3f4c39, 0x4a695a68, 0x2806005c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3f4c39, 0x3f5d4e5d, 0x28060059, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3f4c39, 0x3a594a58, 0x2806004c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3c3f4c39, 0x2c4a3b4a, 0x2806003e, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x08183a1f, 0x2c4a3b4a, 0x0c06003e, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x3f5d595d, 0x0f070059, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x3c5b4f5b, 0x0f07004f, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x3a594c58, 0x0f07004c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2f4d494d, 0x0f070049, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x3d3d3c29, 0x2a493c48, 0x0f07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2d291b07, 0x3e3c3a38, 0x08183a1f, 0x2a493c48, 0x0c07003c, 0x001acdcd, 0x00000000, 0x040c241d,
	0x003f003f, 0x077a0007, 0x000037e0, 0x000003b8, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x09193b28, 0x2b4a3d49, 0x0e08003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x09193b28, 0x2b4a3d49, 0x0e08003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x09193b28, 0x2b4a3d49, 0x0e08003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d494e3a, 0x586e686e, 0x2907006a, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d494e3a, 0x4e6c5d6c, 0x29070068, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d494e3a, 0x4b6a5b69, 0x2907005d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d494e3a, 0x485e585e, 0x2907005a, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d494e3a, 0x3b5a4b59, 0x2907004d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3d494e3a, 0x2d4b3d4b, 0x29070048, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x09193b28, 0x2d4b3d4b, 0x0e070048, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x485e5a5e, 0x1908005a, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x3e5c585c, 0x19080058, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x3b5a4d59, 0x1908004d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x384e4a4e, 0x1908004a, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x3e3e3e2a, 0x2b4a3d49, 0x1908003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x2f2a1d08, 0x483e3c39, 0x09193b28, 0x2b4a3d49, 0x0e08003d, 0x001dcdcd, 0x00000000, 0x040c241f,
	0x00470047, 0x08640008, 0x00004666, 0x0000042c, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x0a1a3d29, 0x2d4b3f4b, 0x0f09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x0a1a3d29, 0x2d4b3f4b, 0x0f09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x0a1a3d29, 0x2d4b3f4b, 0x0f09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f4a583c, 0x596f6978, 0x2a08006b, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f4a583c, 0x586d5f6d, 0x2a080069, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f4a583c, 0x4d6b5c6b, 0x2a08005f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f4a583c, 0x49685968, 0x2a08005b, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f4a583c, 0x3d5b4c5b, 0x2a08004f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x3f4a583c, 0x2f4d3e4d, 0x2a080049, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x0a1a3d29, 0x2f4d3e4d, 0x0f080049, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x49685b68, 0x1a09005b, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x485d595d, 0x1a090059, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x3d5b4f5b, 0x1a09004f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x39584b58, 0x1a09004b, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x4848482c, 0x2d4b3f4b, 0x1a09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x382c1e09, 0x493f3d3b, 0x0a1a3d29, 0x2d4b3f4b, 0x0f09003f, 0x0020cdcd, 0x00000000, 0x040c2428,
	0x00500050, 0x096b0009, 0x000058b3, 0x000004af, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x0b1c3e2a, 0x2e4c484c, 0x190a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x0b1c3e2a, 0x2e4c484c, 0x190a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x0b1c3e2a, 0x2e4c484c, 0x190a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x484b593d, 0x5b6f6a79, 0x2b09006c, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x484b593d, 0x596f686f, 0x2b09006a, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x484b593d, 0x4e6c5d6c, 0x2b090068, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x484b593d, 0x4b695a69, 0x2b09005c, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x484b593d, 0x3e5c4d5c, 0x2b090058, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x484b593d, 0x384e484e, 0x2b09004a, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x0b1c3e2a, 0x384e484e, 0x1909004a, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x4b695d69, 0x1b0a005c, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x495f5b5f, 0x1b0a005a, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x3e5c585c, 0x1b0a0058, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x3b594d59, 0x1b0a004c, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x4949492d, 0x2e4c484c, 0x1b0a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x392d280a, 0x4a493f3c, 0x0b1c3e2a, 0x2e4c484c, 0x190a0048, 0x0024cdcd, 0x00000000, 0x040c2429,
	0x00590059, 0x0a92000a, 0x00006fc1, 0x00000542, 0x00000004, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x0d1d482c, 0x384e494d, 0x1a0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x0d1d482c, 0x384e494d, 0x1a0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x0d1d482c, 0x384e494d, 0x1a0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x5c6f6b7a, 0x2c0a006e, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x5a6f6978, 0x2c0a006c, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x586e5f6d, 0x2c0a0069, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x4c6a5b6a, 0x2c0a005e, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x485e4f5d, 0x2c0a0059, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x494c5a3f, 0x39584958, 0x2c0a004b, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x0d1d482c, 0x39584958, 0x1a0a004b, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x4c6a5e6a, 0x1c0b005e, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x4a685c68, 0x1c0b005c, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x485e595d, 0x1c0b0059, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x3c5a4e5a, 0x1c0b004e, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x4a4a4a2f, 0x384e494d, 0x1c0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3a2f290b, 0x4b4a483d, 0x0d1d482c, 0x384e494d, 0x1a0b0049, 0x0029cdcd, 0x00000000, 0x040c242a,
	0x00640064, 0x0bde000b, 0x00008ccd, 0x000005e7, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x0e1f492d, 0x394f4b4f, 0x1b0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x0e1f492d, 0x394f4b4f, 0x1b0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x0e1f492d, 0x394f4b4f, 0x1b0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x5d6f6d7b, 0x2e0b0078, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x5b6f6b79, 0x2e0b006d, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x596f686f, 0x2e0b006a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x4d6b5d6b, 0x2e0b0068, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x495f585f, 0x2e0b005a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4a4e5b48, 0x3b594a59, 0x2e0b004c, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x0e1f492d, 0x3b594a59, 0x1b0b004c, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x4d6b686b, 0x1e0d0068, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x4b695d69, 0x1e0d005d, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x495f5b5f, 0x1e0d005a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x3d5b585b, 0x1e0d0058, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x4b4b4b38, 0x394f4b4f, 0x1e0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3c382a0d, 0x4c4b493f, 0x0e1f492d, 0x394f4b4f, 0x1b0d004a, 0x002ecdcd, 0x00000000, 0x040c242c,
	0x00710071, 0x0d52000d, 0x0000b166, 0x000006a0, 0x00000005, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x18284a2f, 0x3a594c58, 0x1d0e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x18284a2f, 0x3a594c58, 0x1d0e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x18284a2f, 0x3a594c58, 0x1d0e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x5f6f6e7d, 0x380d0079, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x5c6f6c7b, 0x380d006f, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x5a6f6a78, 0x380d006c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x4f6d5e6d, 0x380d0069, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x4a695a68, 0x380d005c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4c4f5c49, 0x3c5a4b5a, 0x380d004e, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x18284a2f, 0x3c5a4b5a, 0x1d0d004e, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x4f6d696d, 0x280e0069, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x4c6b5f6b, 0x280e005f, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x4a695c68, 0x280e005c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3f5d595d, 0x280e0059, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x4d4d4c39, 0x3a594c58, 0x280e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3d392b0e, 0x4e4c4a48, 0x18284a2f, 0x3a594c58, 0x1d0e004c, 0x0034cdcd, 0x00000000, 0x040c242d,
	0x007f007f, 0x0ef3000e, 0x0000df82, 0x0000076f, 0x00000006, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x19294b38, 0x3b5a4d59, 0x1e18004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x19294b38, 0x3b5a4d59, 0x1e18004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x19294b38, 0x3b5a4d59, 0x1e18004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x686f6f7e, 0x390f007a, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x5e6f6d7c, 0x390f0078, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x5b6f6b79, 0x390f006d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x586e686e, 0x390f006a, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x4b6a5b69, 0x390f005d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4d595e4a, 0x3d5b4d5b, 0x390f0058, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x19294b38, 0x3d5b4d5b, 0x1e0f0058, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x586e6a6e, 0x2918006a, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x4e6c686c, 0x29180068, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x4b6a5d69, 0x2918005d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x485e5a5e, 0x2918005a, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x4e4e4e3a, 0x3b5a4d59, 0x2918004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x3f3a2d18, 0x584e4c49, 0x19294b38, 0x3b5a4d59, 0x1e18004d, 0x003acdcd, 0x00000000, 0x040c242f,
	0x008e008e, 0x10c80010, 0x0001199a, 0x00000858, 0x00000007, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x1d2d583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x1d2d583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x1d2d583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x595c6a4f, 0x696f6f88, 0x3d18007b, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x595c6a4f, 0x686f6f7d, 0x3d180079, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x595c6a4f, 0x5d6f6c7b, 0x3d18006f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x595c6a4f, 0x596f6978, 0x3d18006b, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x595c6a4f, 0x4d6b5c6b, 0x3d18005f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x595c6a4f, 0x3f5d4e5d, 0x3d180059, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x1d2d583c, 0x3f5d4e5d, 0x2a180059, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x596f6b78, 0x2d19006b, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x586d696d, 0x2d190069, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x4d6b5f6b, 0x2d19005f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x49685b68, 0x2d19005b, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x5a5a5a3f, 0x3d5b4f5b, 0x2d19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x483c2e19, 0x594f4d4b, 0x1d2d583c, 0x3d5b4f5b, 0x2a19004f, 0x0041cdcd, 0x00000000, 0x040c2438,
	0x00a000a0, 0x12d60012, 0x000162cb, 0x0000095e, 0x00000008, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x1f2f593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x1f2f593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x1f2f593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5b5e6b58, 0x6b6f6f89, 0x3e1a007c, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5b5e6b58, 0x696f6f7f, 0x3e1a007a, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5b5e6b58, 0x5e6f6d7c, 0x3e1a0078, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5b5e6b58, 0x5b6f6a79, 0x3e1a006c, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5b5e6b58, 0x4e6c5d6c, 0x3e1a0068, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5b5e6b58, 0x485e585e, 0x3e1a005a, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x1f2f593d, 0x485e585e, 0x2b1a005a, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x5b6f6d79, 0x2e1b006c, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x596f6b6f, 0x2e1b006a, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x4e6c686c, 0x2e1b0068, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x4b695d69, 0x2e1b005c, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x5c5c5b48, 0x3e5c585c, 0x2e1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x493d381b, 0x5a594f4c, 0x1f2f593d, 0x3e5c585c, 0x2b1b0058, 0x0049cdcd, 0x00000000, 0x040c2439,
	0x00b300b3, 0x15250015, 0x0001bf03, 0x00000a83, 0x00000009, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x28385a3f, 0x485e595d, 0x2d1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x28385a3f, 0x485e595d, 0x2d1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x28385a3f, 0x485e595d, 0x2d1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5c686d59, 0x6c6f6f8a, 0x481b007e, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5c686d59, 0x6a6f6f88, 0x481b007c, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5c686d59, 0x686f6f7d, 0x481b0079, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5c686d59, 0x5c6f6b7a, 0x481b006e, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5c686d59, 0x586e5f6d, 0x481b0069, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5c686d59, 0x49685968, 0x481b005b, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x28385a3f, 0x49685968, 0x2d1b005b, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x5c6f6e7a, 0x381c006e, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x5a6f6c78, 0x381c006c, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x586e696d, 0x381c0069, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x4c6a5e6a, 0x381c005e, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x5d5d5d49, 0x485e595d, 0x381c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4a3f391c, 0x5b5a584d, 0x28385a3f, 0x485e595d, 0x2d1c0059, 0x0053cdcd, 0x00000000, 0x040c243a,
	0x00c900c9, 0x17bb0017, 0x00023333, 0x00000bcd, 0x0000000a, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x29395b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x29395b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x29395b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5d696e5a, 0x6d6f6f8b, 0x491c0088, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5d696e5a, 0x6b6f6f89, 0x491c007d, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5d696e5a, 0x696f6f7f, 0x491c007a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5d696e5a, 0x5d6f6d7b, 0x491c0078, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5d696e5a, 0x596f686f, 0x491c006a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5d696e5a, 0x4b695a69, 0x491c005c, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x29395b48, 0x4b695a69, 0x2e1c005c, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x5d6f6f7b, 0x391d0078, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x5b6f6d79, 0x391d006d, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x596f6b6f, 0x391d006a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x4d6b686b, 0x391d0068, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x5f5f5e4a, 0x495f5b5f, 0x391d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4c483a1d, 0x5c5b594f, 0x29395b48, 0x495f5b5f, 0x2e1d005a, 0x005dcdcd, 0x00000000, 0x040c243c,
	0x00e200e2, 0x1aa3001a, 0x0002c596, 0x00000d3f, 0x0000000b, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x2b3a5d49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x2b3a5d49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x2b3a5d49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5f6a785c, 0x6f6f6f8d, 0x4a1d0089, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5f6a785c, 0x6c6f6f8b, 0x4a1d007f, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5f6a785c, 0x6a6f6f88, 0x4a1d007c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5f6a785c, 0x5f6f6e7d, 0x4a1d0079, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5f6a785c, 0x5a6f6a78, 0x4a1d006c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x5f6a785c, 0x4c6a5b6a, 0x4a1d005e, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x2b3a5d49, 0x4c6a5b6a, 0x381d005e, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x5f6f6f7d, 0x3a1f0079, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x5c6f6f7b, 0x3a1f006f, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x5a6f6c78, 0x3a1f006c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4f6d696d, 0x3a1f0069, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x6868684c, 0x4a695c68, 0x3a1f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4d493b1f, 0x5e5c5a58, 0x2b3a5d49, 0x4a695c68, 0x381f005c, 0x0068cdcd, 0x00000000, 0x040c243d,
	0x00fe00fe, 0x1de6001d, 0x00037e06, 0x00000ede, 0x0000000d, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x2c3c5e4b, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x2c3c5e4b, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x2c3c5e4b, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x686b795d, 0x6f6f6f8e, 0x4b1f008a, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x686b795d, 0x6e6f6f8c, 0x4b1f0088, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x686b795d, 0x6b6f6f89, 0x4b1f007d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x686b795d, 0x686f6f7e, 0x4b1f007a, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x686b795d, 0x5b6f6b79, 0x4b1f006d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x686b795d, 0x4d6b5d6b, 0x4b1f0068, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x2c3c5e4b, 0x4d6b5d6b, 0x391f0068, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x686f6f7e, 0x3b28007a, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x5e6f6f7c, 0x3b280078, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x5b6f6d79, 0x3b28006d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x586e6a6e, 0x3b28006a, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x6969694d, 0x4b6a5d69, 0x3b28005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x4f4a3d28, 0x685e5c59, 0x2c3c5e4b, 0x4b6a5d69, 0x3928005d, 0x0075cdcd, 0x00000000, 0x040c243f,
	0x011d011d, 0x21900021, 0x00046666, 0x000010b0, 0x0000000e, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x2d3d684c, 0x4d6b5f6b, 0x3a29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x2d3d684c, 0x4d6b5f6b, 0x3a29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x2d3d684c, 0x4d6b5f6b, 0x3a29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x6f6f6f8f, 0x4d28008b, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x6f6f6f8d, 0x4d280089, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x6d6f6f8b, 0x4d28007f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x696f6f88, 0x4d28007b, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x5d6f6c7b, 0x4d28006f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x696c7a5f, 0x4f6d5e6d, 0x4d280069, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x2d3d684c, 0x4f6d5e6d, 0x3a280069, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x696f6f88, 0x3d29007b, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x686f6f7d, 0x3d290079, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x5d6f6f7b, 0x3d29006f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x596f6b78, 0x3d29006b, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x6a6a6a4f, 0x4d6b5f6b, 0x3d29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x584c3e29, 0x695f5d5b, 0x2d3d684c, 0x4d6b5f6b, 0x3a29005f, 0x0083cdcd, 0x00000000, 0x040c2448,
	0x01400140, 0x25ac0025, 0x00058b2d, 0x000012bc, 0x00000010, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x2f3f694d, 0x4e6c686c, 0x3b2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x2f3f694d, 0x4e6c686c, 0x3b2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x2f3f694d, 0x4e6c686c, 0x3b2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x6f6f6f8f, 0x4e2a008c, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x6f6f6f8f, 0x4e2a008a, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x6e6f6f8c, 0x4e2a0088, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x6b6f6f89, 0x4e2a007c, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x5e6f6d7c, 0x4e2a0078, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6b6e7b68, 0x586e686e, 0x4e2a006a, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x2f3f694d, 0x586e686e, 0x3b2a006a, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x6b6f6f89, 0x3e2b007c, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x696f6f7f, 0x3e2b007a, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x5e6f6f7c, 0x3e2b0078, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x5b6f6d79, 0x3e2b006c, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x6c6c6b58, 0x4e6c686c, 0x3e2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x594d482b, 0x6a695f5c, 0x2f3f694d, 0x4e6c686c, 0x3b2b0068, 0x0093cdcd, 0x00000000, 0x040c2449,
	0x01670167, 0x2a49002a, 0x0006fc0c, 0x00001507, 0x00000012, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x38486a4f, 0x586e696d, 0x3d2c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x38486a4f, 0x586e696d, 0x3d2c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x38486a4f, 0x586e696d, 0x3d2c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x6f6f6f8f, 0x582b008e, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x6f6f6f8f, 0x582b008c, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x6f6f6f8d, 0x582b0089, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x6c6f6f8a, 0x582b007e, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x686f6f7d, 0x582b0079, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6c787d69, 0x596f6978, 0x582b006b, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x38486a4f, 0x596f6978, 0x3d2b006b, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x6c6f6f8a, 0x482c007e, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x6a6f6f88, 0x482c007c, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x686f6f7d, 0x482c0079, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x5c6f6e7a, 0x482c006e, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x6d6d6d59, 0x586e696d, 0x482c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5a4f492c, 0x6b6a685d, 0x38486a4f, 0x586e696d, 0x3d2c0069, 0x00a6cdcd, 0x00000000, 0x040c244a,
	0x01930193, 0x2f77002f, 0x0008cccd, 0x0000179a, 0x00000014, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x39496b58, 0x596f6b6f, 0x3e2d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x39496b58, 0x596f6b6f, 0x3e2d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x39496b58, 0x596f6b6f, 0x3e2d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x6f6f6f8f, 0x592c008f, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x6f6f6f8f, 0x592c008d, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x6f6f6f8f, 0x592c008a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x6d6f6f8b, 0x592c0088, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x696f6f7f, 0x592c007a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6d797e6a, 0x5b6f6a79, 0x592c006c, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x39496b58, 0x5b6f6a79, 0x3e2c006c, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x6d6f6f8b, 0x492d0088, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x6b6f6f89, 0x492d007d, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x696f6f7f, 0x492d007a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x5d6f6f7b, 0x492d0078, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x6f6f6e5a, 0x596f6b6f, 0x492d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5c584a2d, 0x6c6b695f, 0x39496b58, 0x596f6b6f, 0x3e2d006a, 0x00bacdcd, 0x00000000, 0x040c244c,
	0x01c401c4, 0x35470035, 0x000b165a, 0x00001a7e, 0x00000017, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x3b4a6d59, 0x5a6f6c78, 0x482f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x3b4a6d59, 0x5a6f6c78, 0x482f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x3b4a6d59, 0x5a6f6c78, 0x482f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x6f6f6f8f, 0x5a2d008f, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x6f6f6f8f, 0x5a2d008f, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x6f6f6f8f, 0x5a2d008c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x6f6f6f8d, 0x5a2d0089, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x6a6f6f88, 0x5a2d007c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x6f7a886c, 0x5c6f6b7a, 0x5a2d006e, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x3b4a6d59, 0x5c6f6b7a, 0x482d006e, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x6f6f6f8d, 0x4a2f0089, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x6c6f6f8b, 0x4a2f007f, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x6a6f6f88, 0x4a2f007c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5f6f6f7d, 0x4a2f0079, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x7878785c, 0x5a6f6c78, 0x4a2f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5d594b2f, 0x6e6c6a68, 0x3b4a6d59, 0x5a6f6c78, 0x482f006c, 0x00d1cdcd, 0x00000000, 0x040c244d,
	0x01fc01fc, 0x3bcd003b, 0x000df819, 0x00001dbd, 0x0000001a, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008f, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8f, 0x5b2f008d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6f6f6f8e, 0x5b2f008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x6b6f6f89, 0x5b2f007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x787b896d, 0x5d6f6d7b, 0x5b2f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5d6f6d7b, 0x492f0078, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6f6f6f8e, 0x4b38008a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6e6f6f8c, 0x4b380088, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x6b6f6f89, 0x4b38007d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x686f6f7e, 0x4b38007a, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x7979795d, 0x5b6f6d79, 0x4b38006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x5f5a4d38, 0x6f6e6c69, 0x3c4c6e5b, 0x5b6f6d79, 0x4938006d, 0x00eacdcd, 0x00000000, 0x040c244f,
	0x023a023a, 0x43200043, 0x0011999a, 0x00002161, 0x0000001d, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2c4a3b4a, 0x0001003e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2a483a48, 0x0001003c, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x283e2f3e, 0x00010039, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x1c3a2b3a, 0x0001002e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x0f2e1f2e, 0x00010029, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x09281928, 0x0001001b, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x09281928, 0x0001001b, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0f2e2a2e, 0x00010029, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2c4a3b4a, 0x0001003e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2a483a48, 0x0001003c, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x283e2f3e, 0x00010039, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x1c3a2b3a, 0x0001002e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x0f2e1f2e, 0x00010029, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x09281928, 0x0001001b, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x09281928, 0x0001001b, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0f2e2a2e, 0x00010029, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2c4a3b4a, 0x0001003e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2a483a48, 0x0001003c, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x283e2f3e, 0x00010039, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x1c3a2b3a, 0x0001002e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x0f2e1f2e, 0x00010029, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x09281928, 0x0001001b, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x09281928, 0x0001001b, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0f2e2a2e, 0x00010029, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2c4a3b4a, 0x0001003e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2a483a48, 0x0001003c, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x283e2f3e, 0x00010039, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x1c3a2b3a, 0x0001002e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x0f2e1f2e, 0x00010029, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x09281928, 0x0001001b, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x09281928, 0x0001001b, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0f2e2a2e, 0x00010029, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2c4a3b4a, 0x0001003e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x2a483a48, 0x0001003c, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x283e2f3e, 0x00010039, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x1c3a2b3a, 0x0001002e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x0f2e1f2e, 0x00010029, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010201, 0x09281928, 0x0001001b, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x09281928, 0x0001001b, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1c3a2e3a, 0x0001002e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x1a382c38, 0x0001002c, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0f2e2a2e, 0x00010029, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x0b2a1e2a, 0x0001001e, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x01010100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000100, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x00000401, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cdcd, 0x0026001e, 0x040c2405,
	0x000c000c, 0x00be0001, 0x0000008d, 0x0000005e, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
	0x0a070401, 0x1b1a180d, 0x05050502, 0x071e1a1e, 0x00010019, 0x0005cd