/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.i18n;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.i18n.BundleTag;
import org.apache.taglibs.i18n.ResourceHelper;

public class MessageTag
extends BodyTagSupport {
    private String _key = null;
    private String _value = null;
    private ResourceBundle _bundle = null;
    private String _bundleRef = null;
    private Object[] _args = null;
    private boolean _debug = false;
    private MessageFormat _messageFormat = new MessageFormat("");
    private List _arguments = new ArrayList();
    static /* synthetic */ Class class$org$apache$taglibs$i18n$BundleTag;

    public final void setKey(String key) {
        this._key = key;
    }

    public final void setBundleRef(String varName) {
        this._bundleRef = varName;
    }

    public final void setBundle(ResourceBundle aBundle) {
        this._bundle = aBundle;
    }

    private ResourceBundle getBundle() throws JspException {
        ResourceBundle bundle = this._bundle;
        if (bundle == null) {
            if (this._bundleRef != null) {
                bundle = (ResourceBundle)((TagSupport)this).pageContext.getAttribute(this._bundleRef);
                if (bundle == null) {
                    throw new JspTagException("i18n:message tag, could not find bundleRef=" + this._bundleRef);
                }
            } else {
                BundleTag bundleTag = (BundleTag)TagSupport.findAncestorWithClass((Tag)this, (Class)(class$org$apache$taglibs$i18n$BundleTag == null ? (class$org$apache$taglibs$i18n$BundleTag = MessageTag.class$("org.apache.taglibs.i18n.BundleTag")) : class$org$apache$taglibs$i18n$BundleTag));
                if (bundleTag != null) {
                    return bundleTag.getBundle();
                }
                bundle = ResourceHelper.getBundle(((TagSupport)this).pageContext);
            }
        }
        return bundle;
    }

    public final void setDebug(boolean value) {
        this._debug = value;
    }

    protected final void addArg(Object arg) {
        this._arguments.add(arg);
        if (this._debug) {
            ServletContext sc = ((TagSupport)this).pageContext.getServletContext();
            sc.log("i18n:message added arg: " + arg.toString());
        }
    }

    public final void setArgs(Object[] args) {
        this._args = args;
    }

    public final void release() {
        super.release();
        this._arguments.clear();
        this._key = null;
        this._value = null;
        this._bundle = null;
    }

    public final int doStartTag() throws JspException {
        this._value = null;
        if (this._key == null) {
            throw new JspTagException("i18n:message tag requires a key attribute.");
        }
        ResourceBundle bundle = this.getBundle();
        if (bundle == null) {
            throw new JspTagException("i18n:message tag, no bundle available for use.");
        }
        this._arguments.clear();
        if (this._args != null) {
            this._arguments.addAll(Arrays.asList(this._args));
        }
        try {
            this._value = bundle.getString(this._key);
            if (this._debug) {
                ServletContext sc = ((TagSupport)this).pageContext.getServletContext();
                sc.log("i18n:message tag: template for " + this._key + " is: " + this._value);
            }
        }
        catch (MissingResourceException e) {
            ServletContext sc = ((TagSupport)this).pageContext.getServletContext();
            sc.log("i18n:message tag, value not found for key:" + this._key);
        }
        return 2;
    }

    public final int doEndTag() throws JspException {
        try {
            if (this._value == null) {
                this._value = this.bodyContent.getString();
                this.bodyContent.clear();
            }
            if (this._value != null && this._arguments != null && this._arguments.size() > 0) {
                this._messageFormat.setLocale(this.getBundle().getLocale());
                this._messageFormat.applyPattern(this._value);
                this._value = this._messageFormat.format(this._arguments.toArray());
            }
            if (this._value == null) {
                if (this._debug) {
                    ServletContext sc = ((TagSupport)this).pageContext.getServletContext();
                    sc.log("i18n: message: skipping null value for " + this._key);
                }
            } else if (((TagSupport)this).id != null) {
                ((TagSupport)this).pageContext.setAttribute(((TagSupport)this).id, (Object)this._value);
            } else {
                ((TagSupport)this).pageContext.getOut().print(this._value);
            }
        }
        catch (IOException e) {
            throw new JspTagException("i18n:message tag IO Error: " + e.getMessage());
        }
        return 6;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

