/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * Pass camel exchanges to acceptence test written in Robot DSL.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface RobotFrameworkEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Robot Framework component.
     */
    public interface RobotFrameworkEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedRobotFrameworkEndpointConsumerBuilder advanced() {
            return (AdvancedRobotFrameworkEndpointConsumerBuilder) this;
        }
        /**
         * Sets whether the context map should allow access to all details. By
         * default only the message body and headers can be accessed. This
         * option can be enabled for full access to the current Exchange and
         * CamelContext. Doing so impose a potential security risk as this opens
         * access to the full power of CamelContext API.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowContextMapAll the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder allowContextMapAll(
                boolean allowContextMapAll) {
            doSetProperty("allowContextMapAll", allowContextMapAll);
            return this;
        }
        /**
         * Sets whether the context map should allow access to all details. By
         * default only the message body and headers can be accessed. This
         * option can be enabled for full access to the current Exchange and
         * CamelContext. Doing so impose a potential security risk as this opens
         * access to the full power of CamelContext API.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowContextMapAll the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder allowContextMapAll(
                String allowContextMapAll) {
            doSetProperty("allowContextMapAll", allowContextMapAll);
            return this;
        }
        /**
         * Whether to allow to use resource template from header or not (default
         * false). Enabling this allows to specify dynamic templates via message
         * header. However this can be seen as a potential security
         * vulnerability if the header is coming from a malicious user, so use
         * this with care.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowTemplateFromHeader the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder allowTemplateFromHeader(
                boolean allowTemplateFromHeader) {
            doSetProperty("allowTemplateFromHeader", allowTemplateFromHeader);
            return this;
        }
        /**
         * Whether to allow to use resource template from header or not (default
         * false). Enabling this allows to specify dynamic templates via message
         * header. However this can be seen as a potential security
         * vulnerability if the header is coming from a malicious user, so use
         * this with care.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowTemplateFromHeader the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder allowTemplateFromHeader(
                String allowTemplateFromHeader) {
            doSetProperty("allowTemplateFromHeader", allowTemplateFromHeader);
            return this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param argumentFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder argumentFile(
                File argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param argumentFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder argumentFile(
                String argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * Creates combined statistics based on tags. Use the format tags:title
         * List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param combinedTagStats the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder combinedTagStats(
                String combinedTagStats) {
            doSetProperty("combinedTagStats", combinedTagStats);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param contentCache the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder contentCache(
                boolean contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param contentCache the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder contentCache(
                String contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Tests that have the given tags are considered critical. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param criticalTags the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder criticalTags(
                String criticalTags) {
            doSetProperty("criticalTags", criticalTags);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param debugFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder debugFile(File debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param debugFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder debugFile(String debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * Sets the documentation of the top-level tests suites.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param document the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder document(String document) {
            doSetProperty("document", document);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param dryrun the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder dryrun(boolean dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param dryrun the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder dryrun(String dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param excludes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder excludes(String excludes) {
            doSetProperty("excludes", excludes);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exitOnFailure the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder exitOnFailure(
                boolean exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exitOnFailure the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder exitOnFailure(
                String exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder includes(String includes) {
            doSetProperty("includes", includes);
            return this;
        }
        /**
         * Sets a single listener for monitoring tests execution.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param listener the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder listener(String listener) {
            doSetProperty("listener", listener);
            return this;
        }
        /**
         * Sets multiple listeners for monitoring tests execution. Use the
         * format ListenerWithArgs:arg1:arg2 or simply ListenerWithoutArgs List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param listeners the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder listeners(String listeners) {
            doSetProperty("listeners", listeners);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder log(File log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the threshold level for logging.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param logLevel the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder logLevel(String logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * Sets a title for the generated tests log.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param logTitle the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder logTitle(String logTitle) {
            doSetProperty("logTitle", logTitle);
            return this;
        }
        /**
         * Sets free metadata for the top level tests suites. comma seperated
         * list of string resulting as List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param metadata the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder metadata(String metadata) {
            doSetProperty("metadata", metadata);
            return this;
        }
        /**
         * Using ANSI colors in console. Normally colors work in unixes but not
         * in Windows. Default is 'on'. 'on' - use colors in unixes but not in
         * Windows 'off' - never use colors 'force' - always use colors (also in
         * Windows).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param monitorColors the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder monitorColors(
                String monitorColors) {
            doSetProperty("monitorColors", monitorColors);
            return this;
        }
        /**
         * Width of the monitor output. Default is 78.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 78
         * Group: common
         * 
         * @param monitorWidth the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder monitorWidth(
                String monitorWidth) {
            doSetProperty("monitorWidth", monitorWidth);
            return this;
        }
        /**
         * Sets the name of the top-level tests suites.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param name the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * Tests that have the given tags are not critical. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nonCriticalTags the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder nonCriticalTags(
                String nonCriticalTags) {
            doSetProperty("nonCriticalTags", nonCriticalTags);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noStatusReturnCode the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder noStatusReturnCode(
                boolean noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noStatusReturnCode the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder noStatusReturnCode(
                String noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param output the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder output(File output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param output the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder output(String output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputDirectory the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder outputDirectory(
                File outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputDirectory the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder outputDirectory(
                String outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Sets the test execution order to be randomized. Valid values are all,
         * suite, and test.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param randomize the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder randomize(String randomize) {
            doSetProperty("randomize", randomize);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param report the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder report(File report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param report the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder report(String report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets background colors for the generated report and summary.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportBackground the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder reportBackground(
                String reportBackground) {
            doSetProperty("reportBackground", reportBackground);
            return this;
        }
        /**
         * Sets a title for the generated tests report.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportTitle the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder reportTitle(
                String reportTitle) {
            doSetProperty("reportTitle", reportTitle);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param runEmptySuite the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder runEmptySuite(
                boolean runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param runEmptySuite the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder runEmptySuite(
                String runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param runFailed the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder runFailed(File runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param runFailed the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder runFailed(String runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Sets the execution mode for this tests run. Note that this setting
         * has been deprecated in Robot Framework 2.8. Use separate dryryn,
         * skipTeardownOnExit, exitOnFailure, and randomize settings instead.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param runMode the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder runMode(String runMode) {
            doSetProperty("runMode", runMode);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipTeardownOnExit the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder skipTeardownOnExit(
                boolean skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipTeardownOnExit the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder skipTeardownOnExit(
                String skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Splits output and log files.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param splitOutputs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder splitOutputs(
                String splitOutputs) {
            doSetProperty("splitOutputs", splitOutputs);
            return this;
        }
        /**
         * Selects the tests suites by name. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param suites the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder suites(String suites) {
            doSetProperty("suites", suites);
            return this;
        }
        /**
         * Defines how many levels to show in the Statistics by Suite table in
         * outputs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param suiteStatLevel the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder suiteStatLevel(
                String suiteStatLevel) {
            doSetProperty("suiteStatLevel", suiteStatLevel);
            return this;
        }
        /**
         * Sets a title for the generated summary report.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param summaryTitle the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder summaryTitle(
                String summaryTitle) {
            doSetProperty("summaryTitle", summaryTitle);
            return this;
        }
        /**
         * Adds documentation to the specified tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagDocs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder tagDocs(String tagDocs) {
            doSetProperty("tagDocs", tagDocs);
            return this;
        }
        /**
         * Sets the tags(s) to all executed tests cases. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * Excludes these tags from the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatExcludes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder tagStatExcludes(
                String tagStatExcludes) {
            doSetProperty("tagStatExcludes", tagStatExcludes);
            return this;
        }
        /**
         * Includes only these tags in the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatIncludes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder tagStatIncludes(
                String tagStatIncludes) {
            doSetProperty("tagStatIncludes", tagStatIncludes);
            return this;
        }
        /**
         * Adds external links to the Statistics by Tag table in outputs. Use
         * the format pattern:link:title List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatLinks the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder tagStatLinks(
                String tagStatLinks) {
            doSetProperty("tagStatLinks", tagStatLinks);
            return this;
        }
        /**
         * Selects the tests cases by name. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tests the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder tests(String tests) {
            doSetProperty("tests", tests);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param timestampOutputs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder timestampOutputs(
                boolean timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param timestampOutputs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder timestampOutputs(
                String timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Sets variables using variables files. Use the format path:args List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param variableFiles the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder variableFiles(
                String variableFiles) {
            doSetProperty("variableFiles", variableFiles);
            return this;
        }
        /**
         * Sets individual variables. Use the format name:value List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param variables the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder variables(String variables) {
            doSetProperty("variables", variables);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param warnOnSkippedFiles the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder warnOnSkippedFiles(
                boolean warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param warnOnSkippedFiles the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder warnOnSkippedFiles(
                String warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param xunitFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder xunitFile(File xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param xunitFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder xunitFile(String xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder initialDelay(
                long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder initialDelay(
                String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder repeatCount(
                long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder repeatCount(
                String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder schedulerProperties(
                Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Robot Framework
     * component.
     */
    public interface AdvancedRobotFrameworkEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default RobotFrameworkEndpointConsumerBuilder basic() {
            return (RobotFrameworkEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Robot Framework component.
     */
    public interface RobotFrameworkEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedRobotFrameworkEndpointProducerBuilder advanced() {
            return (AdvancedRobotFrameworkEndpointProducerBuilder) this;
        }
        /**
         * Sets whether the context map should allow access to all details. By
         * default only the message body and headers can be accessed. This
         * option can be enabled for full access to the current Exchange and
         * CamelContext. Doing so impose a potential security risk as this opens
         * access to the full power of CamelContext API.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowContextMapAll the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder allowContextMapAll(
                boolean allowContextMapAll) {
            doSetProperty("allowContextMapAll", allowContextMapAll);
            return this;
        }
        /**
         * Sets whether the context map should allow access to all details. By
         * default only the message body and headers can be accessed. This
         * option can be enabled for full access to the current Exchange and
         * CamelContext. Doing so impose a potential security risk as this opens
         * access to the full power of CamelContext API.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowContextMapAll the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder allowContextMapAll(
                String allowContextMapAll) {
            doSetProperty("allowContextMapAll", allowContextMapAll);
            return this;
        }
        /**
         * Whether to allow to use resource template from header or not (default
         * false). Enabling this allows to specify dynamic templates via message
         * header. However this can be seen as a potential security
         * vulnerability if the header is coming from a malicious user, so use
         * this with care.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowTemplateFromHeader the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder allowTemplateFromHeader(
                boolean allowTemplateFromHeader) {
            doSetProperty("allowTemplateFromHeader", allowTemplateFromHeader);
            return this;
        }
        /**
         * Whether to allow to use resource template from header or not (default
         * false). Enabling this allows to specify dynamic templates via message
         * header. However this can be seen as a potential security
         * vulnerability if the header is coming from a malicious user, so use
         * this with care.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowTemplateFromHeader the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder allowTemplateFromHeader(
                String allowTemplateFromHeader) {
            doSetProperty("allowTemplateFromHeader", allowTemplateFromHeader);
            return this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param argumentFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder argumentFile(
                File argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param argumentFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder argumentFile(
                String argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * Creates combined statistics based on tags. Use the format tags:title
         * List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param combinedTagStats the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder combinedTagStats(
                String combinedTagStats) {
            doSetProperty("combinedTagStats", combinedTagStats);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param contentCache the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder contentCache(
                boolean contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param contentCache the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder contentCache(
                String contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Tests that have the given tags are considered critical. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param criticalTags the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder criticalTags(
                String criticalTags) {
            doSetProperty("criticalTags", criticalTags);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param debugFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder debugFile(File debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param debugFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder debugFile(String debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * Sets the documentation of the top-level tests suites.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param document the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder document(String document) {
            doSetProperty("document", document);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param dryrun the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder dryrun(boolean dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param dryrun the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder dryrun(String dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param excludes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder excludes(String excludes) {
            doSetProperty("excludes", excludes);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exitOnFailure the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder exitOnFailure(
                boolean exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exitOnFailure the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder exitOnFailure(
                String exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder includes(String includes) {
            doSetProperty("includes", includes);
            return this;
        }
        /**
         * Sets a single listener for monitoring tests execution.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param listener the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder listener(String listener) {
            doSetProperty("listener", listener);
            return this;
        }
        /**
         * Sets multiple listeners for monitoring tests execution. Use the
         * format ListenerWithArgs:arg1:arg2 or simply ListenerWithoutArgs List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param listeners the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder listeners(String listeners) {
            doSetProperty("listeners", listeners);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder log(File log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the threshold level for logging.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param logLevel the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder logLevel(String logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * Sets a title for the generated tests log.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param logTitle the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder logTitle(String logTitle) {
            doSetProperty("logTitle", logTitle);
            return this;
        }
        /**
         * Sets free metadata for the top level tests suites. comma seperated
         * list of string resulting as List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param metadata the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder metadata(String metadata) {
            doSetProperty("metadata", metadata);
            return this;
        }
        /**
         * Using ANSI colors in console. Normally colors work in unixes but not
         * in Windows. Default is 'on'. 'on' - use colors in unixes but not in
         * Windows 'off' - never use colors 'force' - always use colors (also in
         * Windows).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param monitorColors the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder monitorColors(
                String monitorColors) {
            doSetProperty("monitorColors", monitorColors);
            return this;
        }
        /**
         * Width of the monitor output. Default is 78.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 78
         * Group: common
         * 
         * @param monitorWidth the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder monitorWidth(
                String monitorWidth) {
            doSetProperty("monitorWidth", monitorWidth);
            return this;
        }
        /**
         * Sets the name of the top-level tests suites.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param name the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * Tests that have the given tags are not critical. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nonCriticalTags the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder nonCriticalTags(
                String nonCriticalTags) {
            doSetProperty("nonCriticalTags", nonCriticalTags);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noStatusReturnCode the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder noStatusReturnCode(
                boolean noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noStatusReturnCode the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder noStatusReturnCode(
                String noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param output the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder output(File output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param output the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder output(String output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputDirectory the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder outputDirectory(
                File outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputDirectory the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder outputDirectory(
                String outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Sets the test execution order to be randomized. Valid values are all,
         * suite, and test.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param randomize the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder randomize(String randomize) {
            doSetProperty("randomize", randomize);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param report the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder report(File report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param report the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder report(String report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets background colors for the generated report and summary.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportBackground the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder reportBackground(
                String reportBackground) {
            doSetProperty("reportBackground", reportBackground);
            return this;
        }
        /**
         * Sets a title for the generated tests report.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportTitle the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder reportTitle(
                String reportTitle) {
            doSetProperty("reportTitle", reportTitle);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param runEmptySuite the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder runEmptySuite(
                boolean runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param runEmptySuite the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder runEmptySuite(
                String runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param runFailed the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder runFailed(File runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param runFailed the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder runFailed(String runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Sets the execution mode for this tests run. Note that this setting
         * has been deprecated in Robot Framework 2.8. Use separate dryryn,
         * skipTeardownOnExit, exitOnFailure, and randomize settings instead.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param runMode the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder runMode(String runMode) {
            doSetProperty("runMode", runMode);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipTeardownOnExit the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder skipTeardownOnExit(
                boolean skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipTeardownOnExit the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder skipTeardownOnExit(
                String skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Splits output and log files.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param splitOutputs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder splitOutputs(
                String splitOutputs) {
            doSetProperty("splitOutputs", splitOutputs);
            return this;
        }
        /**
         * Selects the tests suites by name. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param suites the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder suites(String suites) {
            doSetProperty("suites", suites);
            return this;
        }
        /**
         * Defines how many levels to show in the Statistics by Suite table in
         * outputs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param suiteStatLevel the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder suiteStatLevel(
                String suiteStatLevel) {
            doSetProperty("suiteStatLevel", suiteStatLevel);
            return this;
        }
        /**
         * Sets a title for the generated summary report.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param summaryTitle the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder summaryTitle(
                String summaryTitle) {
            doSetProperty("summaryTitle", summaryTitle);
            return this;
        }
        /**
         * Adds documentation to the specified tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagDocs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder tagDocs(String tagDocs) {
            doSetProperty("tagDocs", tagDocs);
            return this;
        }
        /**
         * Sets the tags(s) to all executed tests cases. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * Excludes these tags from the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatExcludes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder tagStatExcludes(
                String tagStatExcludes) {
            doSetProperty("tagStatExcludes", tagStatExcludes);
            return this;
        }
        /**
         * Includes only these tags in the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatIncludes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder tagStatIncludes(
                String tagStatIncludes) {
            doSetProperty("tagStatIncludes", tagStatIncludes);
            return this;
        }
        /**
         * Adds external links to the Statistics by Tag table in outputs. Use
         * the format pattern:link:title List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatLinks the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder tagStatLinks(
                String tagStatLinks) {
            doSetProperty("tagStatLinks", tagStatLinks);
            return this;
        }
        /**
         * Selects the tests cases by name. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tests the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder tests(String tests) {
            doSetProperty("tests", tests);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param timestampOutputs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder timestampOutputs(
                boolean timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param timestampOutputs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder timestampOutputs(
                String timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Sets variables using variables files. Use the format path:args List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param variableFiles the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder variableFiles(
                String variableFiles) {
            doSetProperty("variableFiles", variableFiles);
            return this;
        }
        /**
         * Sets individual variables. Use the format name:value List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param variables the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder variables(String variables) {
            doSetProperty("variables", variables);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param warnOnSkippedFiles the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder warnOnSkippedFiles(
                boolean warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param warnOnSkippedFiles the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder warnOnSkippedFiles(
                String warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param xunitFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder xunitFile(File xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param xunitFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder xunitFile(String xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Robot Framework
     * component.
     */
    public interface AdvancedRobotFrameworkEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default RobotFrameworkEndpointProducerBuilder basic() {
            return (RobotFrameworkEndpointProducerBuilder) this;
        }
    }

    /**
     * Builder for endpoint for the Robot Framework component.
     */
    public interface RobotFrameworkEndpointBuilder
            extends
                RobotFrameworkEndpointConsumerBuilder,
                RobotFrameworkEndpointProducerBuilder {
        default AdvancedRobotFrameworkEndpointBuilder advanced() {
            return (AdvancedRobotFrameworkEndpointBuilder) this;
        }
        /**
         * Sets whether the context map should allow access to all details. By
         * default only the message body and headers can be accessed. This
         * option can be enabled for full access to the current Exchange and
         * CamelContext. Doing so impose a potential security risk as this opens
         * access to the full power of CamelContext API.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowContextMapAll the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder allowContextMapAll(
                boolean allowContextMapAll) {
            doSetProperty("allowContextMapAll", allowContextMapAll);
            return this;
        }
        /**
         * Sets whether the context map should allow access to all details. By
         * default only the message body and headers can be accessed. This
         * option can be enabled for full access to the current Exchange and
         * CamelContext. Doing so impose a potential security risk as this opens
         * access to the full power of CamelContext API.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowContextMapAll the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder allowContextMapAll(
                String allowContextMapAll) {
            doSetProperty("allowContextMapAll", allowContextMapAll);
            return this;
        }
        /**
         * Whether to allow to use resource template from header or not (default
         * false). Enabling this allows to specify dynamic templates via message
         * header. However this can be seen as a potential security
         * vulnerability if the header is coming from a malicious user, so use
         * this with care.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowTemplateFromHeader the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder allowTemplateFromHeader(
                boolean allowTemplateFromHeader) {
            doSetProperty("allowTemplateFromHeader", allowTemplateFromHeader);
            return this;
        }
        /**
         * Whether to allow to use resource template from header or not (default
         * false). Enabling this allows to specify dynamic templates via message
         * header. However this can be seen as a potential security
         * vulnerability if the header is coming from a malicious user, so use
         * this with care.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param allowTemplateFromHeader the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder allowTemplateFromHeader(
                String allowTemplateFromHeader) {
            doSetProperty("allowTemplateFromHeader", allowTemplateFromHeader);
            return this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param argumentFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder argumentFile(File argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param argumentFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder argumentFile(String argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * Creates combined statistics based on tags. Use the format tags:title
         * List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param combinedTagStats the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder combinedTagStats(
                String combinedTagStats) {
            doSetProperty("combinedTagStats", combinedTagStats);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param contentCache the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder contentCache(boolean contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param contentCache the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder contentCache(String contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Tests that have the given tags are considered critical. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param criticalTags the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder criticalTags(String criticalTags) {
            doSetProperty("criticalTags", criticalTags);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param debugFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder debugFile(File debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param debugFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder debugFile(String debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * Sets the documentation of the top-level tests suites.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param document the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder document(String document) {
            doSetProperty("document", document);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param dryrun the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder dryrun(boolean dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param dryrun the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder dryrun(String dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param excludes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder excludes(String excludes) {
            doSetProperty("excludes", excludes);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exitOnFailure the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder exitOnFailure(
                boolean exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param exitOnFailure the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder exitOnFailure(String exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param includes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder includes(String includes) {
            doSetProperty("includes", includes);
            return this;
        }
        /**
         * Sets a single listener for monitoring tests execution.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param listener the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder listener(String listener) {
            doSetProperty("listener", listener);
            return this;
        }
        /**
         * Sets multiple listeners for monitoring tests execution. Use the
         * format ListenerWithArgs:arg1:arg2 or simply ListenerWithoutArgs List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param listeners the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder listeners(String listeners) {
            doSetProperty("listeners", listeners);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder log(File log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param log the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the threshold level for logging.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param logLevel the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder logLevel(String logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * Sets a title for the generated tests log.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param logTitle the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder logTitle(String logTitle) {
            doSetProperty("logTitle", logTitle);
            return this;
        }
        /**
         * Sets free metadata for the top level tests suites. comma seperated
         * list of string resulting as List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param metadata the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder metadata(String metadata) {
            doSetProperty("metadata", metadata);
            return this;
        }
        /**
         * Using ANSI colors in console. Normally colors work in unixes but not
         * in Windows. Default is 'on'. 'on' - use colors in unixes but not in
         * Windows 'off' - never use colors 'force' - always use colors (also in
         * Windows).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param monitorColors the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder monitorColors(String monitorColors) {
            doSetProperty("monitorColors", monitorColors);
            return this;
        }
        /**
         * Width of the monitor output. Default is 78.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 78
         * Group: common
         * 
         * @param monitorWidth the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder monitorWidth(String monitorWidth) {
            doSetProperty("monitorWidth", monitorWidth);
            return this;
        }
        /**
         * Sets the name of the top-level tests suites.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param name the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * Tests that have the given tags are not critical. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nonCriticalTags the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder nonCriticalTags(
                String nonCriticalTags) {
            doSetProperty("nonCriticalTags", nonCriticalTags);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noStatusReturnCode the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder noStatusReturnCode(
                boolean noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param noStatusReturnCode the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder noStatusReturnCode(
                String noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param output the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder output(File output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param output the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder output(String output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputDirectory the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder outputDirectory(
                File outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputDirectory the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder outputDirectory(
                String outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Sets the test execution order to be randomized. Valid values are all,
         * suite, and test.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param randomize the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder randomize(String randomize) {
            doSetProperty("randomize", randomize);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param report the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder report(File report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param report the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder report(String report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets background colors for the generated report and summary.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportBackground the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder reportBackground(
                String reportBackground) {
            doSetProperty("reportBackground", reportBackground);
            return this;
        }
        /**
         * Sets a title for the generated tests report.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param reportTitle the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder reportTitle(String reportTitle) {
            doSetProperty("reportTitle", reportTitle);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param runEmptySuite the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder runEmptySuite(
                boolean runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param runEmptySuite the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder runEmptySuite(String runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param runFailed the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder runFailed(File runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param runFailed the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder runFailed(String runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Sets the execution mode for this tests run. Note that this setting
         * has been deprecated in Robot Framework 2.8. Use separate dryryn,
         * skipTeardownOnExit, exitOnFailure, and randomize settings instead.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param runMode the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder runMode(String runMode) {
            doSetProperty("runMode", runMode);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipTeardownOnExit the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder skipTeardownOnExit(
                boolean skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param skipTeardownOnExit the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder skipTeardownOnExit(
                String skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Splits output and log files.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param splitOutputs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder splitOutputs(String splitOutputs) {
            doSetProperty("splitOutputs", splitOutputs);
            return this;
        }
        /**
         * Selects the tests suites by name. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param suites the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder suites(String suites) {
            doSetProperty("suites", suites);
            return this;
        }
        /**
         * Defines how many levels to show in the Statistics by Suite table in
         * outputs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param suiteStatLevel the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder suiteStatLevel(
                String suiteStatLevel) {
            doSetProperty("suiteStatLevel", suiteStatLevel);
            return this;
        }
        /**
         * Sets a title for the generated summary report.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param summaryTitle the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder summaryTitle(String summaryTitle) {
            doSetProperty("summaryTitle", summaryTitle);
            return this;
        }
        /**
         * Adds documentation to the specified tags. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagDocs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder tagDocs(String tagDocs) {
            doSetProperty("tagDocs", tagDocs);
            return this;
        }
        /**
         * Sets the tags(s) to all executed tests cases. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tags the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * Excludes these tags from the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatExcludes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder tagStatExcludes(
                String tagStatExcludes) {
            doSetProperty("tagStatExcludes", tagStatExcludes);
            return this;
        }
        /**
         * Includes only these tags in the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatIncludes the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder tagStatIncludes(
                String tagStatIncludes) {
            doSetProperty("tagStatIncludes", tagStatIncludes);
            return this;
        }
        /**
         * Adds external links to the Statistics by Tag table in outputs. Use
         * the format pattern:link:title List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tagStatLinks the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder tagStatLinks(String tagStatLinks) {
            doSetProperty("tagStatLinks", tagStatLinks);
            return this;
        }
        /**
         * Selects the tests cases by name. List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tests the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder tests(String tests) {
            doSetProperty("tests", tests);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param timestampOutputs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder timestampOutputs(
                boolean timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param timestampOutputs the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder timestampOutputs(
                String timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Sets variables using variables files. Use the format path:args List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param variableFiles the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder variableFiles(String variableFiles) {
            doSetProperty("variableFiles", variableFiles);
            return this;
        }
        /**
         * Sets individual variables. Use the format name:value List.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param variables the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder variables(String variables) {
            doSetProperty("variables", variables);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param warnOnSkippedFiles the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder warnOnSkippedFiles(
                boolean warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param warnOnSkippedFiles the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder warnOnSkippedFiles(
                String warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param xunitFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder xunitFile(File xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param xunitFile the value to set
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder xunitFile(String xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Robot Framework component.
     */
    public interface AdvancedRobotFrameworkEndpointBuilder
            extends
                AdvancedRobotFrameworkEndpointConsumerBuilder,
                AdvancedRobotFrameworkEndpointProducerBuilder {
        default RobotFrameworkEndpointBuilder basic() {
            return (RobotFrameworkEndpointBuilder) this;
        }
    }

    public interface RobotFrameworkBuilders {
        /**
         * Robot Framework (camel-robotframework)
         * Pass camel exchanges to acceptence test written in Robot DSL.
         * 
         * Category: testing
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-robotframework
         * 
         * Syntax: <code>robotframework:resourceUri</code>
         * 
         * Path parameter: resourceUri (required)
         * Path to the resource. You can prefix with: classpath, file, http,
         * ref, or bean. classpath, file and http loads the resource using these
         * protocols (classpath is default). ref will lookup the resource in the
         * registry. bean will call a method on a bean to be used as the
         * resource. For bean you can specify the method name after dot, eg
         * bean:myBean.myMethod.
         * 
         * @param path resourceUri
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder robotframework(String path) {
            return RobotFrameworkEndpointBuilderFactory.endpointBuilder("robotframework", path);
        }
        /**
         * Robot Framework (camel-robotframework)
         * Pass camel exchanges to acceptence test written in Robot DSL.
         * 
         * Category: testing
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-robotframework
         * 
         * Syntax: <code>robotframework:resourceUri</code>
         * 
         * Path parameter: resourceUri (required)
         * Path to the resource. You can prefix with: classpath, file, http,
         * ref, or bean. classpath, file and http loads the resource using these
         * protocols (classpath is default). ref will lookup the resource in the
         * registry. bean will call a method on a bean to be used as the
         * resource. For bean you can specify the method name after dot, eg
         * bean:myBean.myMethod.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path resourceUri
         * @return the dsl builder
         */
        default RobotFrameworkEndpointBuilder robotframework(
                String componentName,
                String path) {
            return RobotFrameworkEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static RobotFrameworkEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class RobotFrameworkEndpointBuilderImpl extends AbstractEndpointBuilder implements RobotFrameworkEndpointBuilder, AdvancedRobotFrameworkEndpointBuilder {
            public RobotFrameworkEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new RobotFrameworkEndpointBuilderImpl(path);
    }
}