/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.google.storage;

public final class GoogleCloudStorageConstants {

    public static final String OPERATION = "CamelGoogleCloudStorageOperation";
    public static final String BUCKET_NAME = "CamelGoogleCloudStorageBucketName";
    public static final String OBJECT_NAME = "CamelGoogleCloudStorageObjectName";
    public static final String DESTINATION_OBJECT_NAME = "CamelGoogleCloudStorageDestinationObjectName";
    public static final String DESTINATION_BUCKET_NAME = "CamelGoogleCloudStorageDestinationBucketName";
    public static final String DOWNLOAD_LINK_EXPIRATION_TIME = "CamelGoogleCloudStorageDownloadLinkExpirationTime";
    public static final String CONTENT_LENGTH = "CamelGoogleCloudStorageContentLength";
    public static final String CONTENT_TYPE = "CamelGoogleCloudStorageContentType";
    public static final String CACHE_CONTROL = "CamelGoogleCloudStorageCacheControl";
    public static final String CONTENT_DISPOSITION = "CamelGoogleCloudStorageContentDisposition";
    public static final String CONTENT_ENCODING = "CamelGoogleCloudStorageContentEncoding";
    public static final String CONTENT_MD5 = "CamelGoogleCloudStorageContentMd5";
    public static final String METADATA_COMPONENT_COUNT = "CamelGoogleCloudStorageComponentCount";
    public static final String METADATA_CONTENT_LANGUAGE = "CamelGoogleCloudStorageContentLanguage";
    public static final String METADATA_CUSTOM_TIME = "CamelGoogleCloudStorageCustomTime";
    public static final String METADATA_CRC32C_HEX = "CamelGoogleCloudStorageCrc32cHex";
    public static final String METADATA_ETAG = "CamelGoogleCloudStorageETag";
    public static final String METADATA_GENERATION = "CamelGoogleCloudStorageGeneration";
    public static final String METADATA_BLOB_ID = "CamelGoogleCloudStorageBlobId";
    public static final String METADATA_KMS_KEY_NAME = "CamelGoogleCloudStorageKmsKeyName";
    public static final String METADATA_MEDIA_LINK = "CamelGoogleCloudStorageMediaLink";
    public static final String METADATA_METAGENERATION = "CamelGoogleCloudStorageMetageneration";
    public static final String METADATA_STORAGE_CLASS = "CamelGoogleCloudStorageStorageClass";
    public static final String METADATA_CREATE_TIME = "CamelGoogleCloudStorageCreateTime";
    public static final String METADATA_LAST_UPDATE = "CamelGoogleCloudStorageLastUpdate";

    /**
     * Prevent instantiation.
     */
    private GoogleCloudStorageConstants() {
    }
}
