/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.debeziumsqlserver;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelDebeziumsqlserverSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_PATH_NAME_CONF = "camel.source.path.name";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_PATH_NAME_DOC = "Unique name for the connector. Attempting to register again with the same name will fail.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_PATH_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_ADDITIONAL_PROPERTIES_CONF = "camel.source.endpoint.additionalProperties";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_ADDITIONAL_PROPERTIES_DOC = "Additional properties for debezium components in case they can't be set directly on the camel configurations (e.g: setting Kafka Connect properties needed by Debezium engine, for example setting KafkaOffsetBackingStore), the properties have to be prefixed with additionalProperties.. E.g: additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_KEY_CONVERTER_CONF = "camel.source.endpoint.internalKeyConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_KEY_CONVERTER_DOC = "The Converter class that should be used to serialize and deserialize key data for offsets. The default is JSON converter.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_KEY_CONVERTER_DEFAULT = "org.apache.kafka.connect.json.JsonConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_VALUE_CONVERTER_CONF = "camel.source.endpoint.internalValueConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_VALUE_CONVERTER_DOC = "The Converter class that should be used to serialize and deserialize value data for offsets. The default is JSON converter.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_VALUE_CONVERTER_DEFAULT = "org.apache.kafka.connect.json.JsonConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_POLICY_CONF = "camel.source.endpoint.offsetCommitPolicy";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_POLICY_DOC = "The name of the Java class of the commit policy. It defines when offsets commit has to be triggered based on the number of events processed and the time elapsed since the last commit. This class must implement the interface 'OffsetCommitPolicy'. The default is a periodic commit policy based upon time intervals.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_POLICY_DEFAULT = "io.debezium.embedded.spi.OffsetCommitPolicy.PeriodicCommitOffsetPolicy";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_CONF = "camel.source.endpoint.offsetCommitTimeoutMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DOC = "Maximum number of milliseconds to wait for records to flush and partition offset data to be committed to offset storage before cancelling the process and restoring the offset data to be committed in a future attempt. The default is 5 seconds.";
    public static final Long CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DEFAULT = 5000L;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_CONF = "camel.source.endpoint.offsetFlushIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DOC = "Interval at which to try committing offsets. The default is 1 minute.";
    public static final Long CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DEFAULT = 60000L;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_CONF = "camel.source.endpoint.offsetStorage";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_DOC = "The name of the Java class that is responsible for persistence of connector offsets.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_DEFAULT = "org.apache.kafka.connect.storage.FileOffsetBackingStore";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_FILE_NAME_CONF = "camel.source.endpoint.offsetStorageFileName";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DOC = "Path to file where offsets are to be stored. Required when offset.storage is set to the FileOffsetBackingStore.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_PARTITIONS_CONF = "camel.source.endpoint.offsetStoragePartitions";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DOC = "The number of partitions used when creating the offset storage topic. Required when offset.storage is set to the 'KafkaOffsetBackingStore'.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_CONF = "camel.source.endpoint.offsetStorageReplicationFactor";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DOC = "Replication factor used when creating the offset storage topic. Required when offset.storage is set to the KafkaOffsetBackingStore";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_TOPIC_CONF = "camel.source.endpoint.offsetStorageTopic";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_TOPIC_DOC = "The name of the Kafka topic where offsets are to be stored. Required when offset.storage is set to the KafkaOffsetBackingStore.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_TOPIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_BLACKLIST_CONF = "camel.source.endpoint.columnBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_BLACKLIST_DOC = "Regular expressions matching columns to exclude from change events";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_WHITELIST_CONF = "camel.source.endpoint.columnWhitelist";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_WHITELIST_DOC = "Regular expressions matching columns to include in change events";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_WHITELIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_CONVERTERS_CONF = "camel.source.endpoint.converters";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_CONVERTERS_DOC = "Optional list of custom converters that would be used instead of default ones. The converters are defined using '.type' config option and configured using options '.'";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_CONVERTERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_DBNAME_CONF = "camel.source.endpoint.databaseDbname";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_DBNAME_DOC = "The name of the database the connector should be monitoring. When working with a multi-tenant set-up, must be set to the CDB name.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_DBNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_CONF = "camel.source.endpoint.databaseHistory";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_DOC = "The name of the DatabaseHistory class that should be used to store and recover database schema changes. The configuration properties for the history are prefixed with the 'database.history.' string.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_DEFAULT = "io.debezium.relational.history.FileDatabaseHistory";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_CONF = "camel.source.endpoint.databaseHistoryFileFilename";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DOC = "The path to the file that will be used to record the database history";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_CONF = "camel.source.endpoint.databaseHistoryKafkaBootstrapServers";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs that the connector will use for establishing the initial connection to the Kafka cluster for retrieving database schema history previously stored by the connector. This should point to the same Kafka cluster used by the Kafka Connect process.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_CONF = "camel.source.endpoint.databaseHistoryKafkaRecoveryAttempts";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DOC = "The number of attempts in a row that no data are returned from Kafka before recover completes. The maximum amount of time to wait after receiving no data is (recovery.attempts) x (recovery.poll.interval.ms).";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DEFAULT = 100;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_CONF = "camel.source.endpoint.databaseHistoryKafkaRecoveryPollIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DOC = "The number of milliseconds to wait while polling for persisted data during recovery.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DEFAULT = 100;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_CONF = "camel.source.endpoint.databaseHistoryKafkaTopic";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_DOC = "The name of the topic for the database schema history";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HOSTNAME_CONF = "camel.source.endpoint.databaseHostname";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HOSTNAME_DOC = "Resolvable hostname or IP address of the SQL Server database server.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PASSWORD_CONF = "camel.source.endpoint.databasePassword";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PASSWORD_DOC = "Password of the SQL Server database user to be used when connecting to the database.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PORT_CONF = "camel.source.endpoint.databasePort";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PORT_DOC = "Port of the SQL Server database server.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PORT_DEFAULT = 1433;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_NAME_CONF = "camel.source.endpoint.databaseServerName";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_NAME_DOC = "Unique name that identifies the database server and all recorded offsets, and that is used as a prefix for all schemas and topics. Each distinct installation should have a separate namespace and be monitored by at most one Debezium connector.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_TIMEZONE_CONF = "camel.source.endpoint.databaseServerTimezone";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_TIMEZONE_DOC = "The timezone of the server used to correctly shift the commit transaction timestamp on the client sideOptions include: Any valid Java ZoneId";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_TIMEZONE_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_USER_CONF = "camel.source.endpoint.databaseUser";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_USER_DOC = "Name of the SQL Server database user to be used when connecting to the database.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_USER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DECIMAL_HANDLING_MODE_CONF = "camel.source.endpoint.decimalHandlingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DECIMAL_HANDLING_MODE_DOC = "Specify how DECIMAL and NUMERIC columns should be represented in change events, including:'precise' (the default) uses java.math.BigDecimal to represent values, which are encoded in the change events using a binary representation and Kafka Connect's 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to represent values; 'double' represents values using Java's 'double', which may not offer the precision but will be far easier to use in consumers.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DECIMAL_HANDLING_MODE_DEFAULT = "precise";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_CONF = "camel.source.endpoint.eventProcessingFailureHandlingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_DOC = "Specify how failures during processing of events (i.e. when encountering a corrupted event) should be handled, including:'fail' (the default) an exception indicating the problematic event and its position is raised, causing the connector to be stopped; 'warn' the problematic event and its position will be logged and the event will be skipped;'ignore' the problematic event will be skipped.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_DEFAULT = "fail";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_INTERVAL_MS_CONF = "camel.source.endpoint.heartbeatIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_INTERVAL_MS_DOC = "Length of an interval in milli-seconds in in which the connector periodically sends heartbeat messages to a heartbeat topic. Use 0 to disable heartbeat messages. Disabled by default.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_INTERVAL_MS_DEFAULT = 0;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_CONF = "camel.source.endpoint.heartbeatTopicsPrefix";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DOC = "The prefix that is used to name heartbeat topics.Defaults to __debezium-heartbeat.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DEFAULT = "__debezium-heartbeat";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INCLUDE_SCHEMA_CHANGES_CONF = "camel.source.endpoint.includeSchemaChanges";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INCLUDE_SCHEMA_CHANGES_DOC = "Whether the connector should publish changes in the database schema to a Kafka topic with the same name as the database server ID. Each schema change will be recorded using a key that contains the database name and whose value include logical description of the new schema and optionally the DDL statement(s).The default is 'true'. This is independent of how the connector internally records database history.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INCLUDE_SCHEMA_CHANGES_DEFAULT = true;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_BATCH_SIZE_CONF = "camel.source.endpoint.maxBatchSize";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_BATCH_SIZE_DOC = "Maximum size of each batch of source records. Defaults to 2048.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_BATCH_SIZE_DEFAULT = 2048;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_QUEUE_SIZE_CONF = "camel.source.endpoint.maxQueueSize";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_QUEUE_SIZE_DOC = "Maximum size of the queue for change events read from the database log but not yet recorded or forwarded. Defaults to 8192, and should always be larger than the maximum batch size.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_QUEUE_SIZE_DEFAULT = 8192;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MESSAGE_KEY_COLUMNS_CONF = "camel.source.endpoint.messageKeyColumns";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MESSAGE_KEY_COLUMNS_DOC = "A semicolon-separated list of expressions that match fully-qualified tables and column(s) to be used as message key. Each expression must match the pattern ':',where the table names could be defined as (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the specific connector,and the key columns are a comma-separated list of columns representing the custom key. For any table without an explicit key configuration the table's primary key column(s) will be used as message key.Example: dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MESSAGE_KEY_COLUMNS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_POLL_INTERVAL_MS_CONF = "camel.source.endpoint.pollIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_POLL_INTERVAL_MS_DOC = "Frequency in milliseconds to wait for new change events to appear after receiving no events. Defaults to 500ms.";
    public static final Long CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_POLL_INTERVAL_MS_DEFAULT = 500L;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_PROVIDE_TRANSACTION_METADATA_CONF = "camel.source.endpoint.provideTransactionMetadata";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_PROVIDE_TRANSACTION_METADATA_DOC = "Enables transaction metadata extraction together with event counting";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_PROVIDE_TRANSACTION_METADATA_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SANITIZE_FIELD_NAMES_CONF = "camel.source.endpoint.sanitizeFieldNames";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SANITIZE_FIELD_NAMES_DOC = "Whether field names will be sanitized to Avro naming conventions";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SANITIZE_FIELD_NAMES_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SKIPPED_OPERATIONS_CONF = "camel.source.endpoint.skippedOperations";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SKIPPED_OPERATIONS_DOC = "The comma-separated list of operations to skip during streaming, defined as: 'i' for inserts; 'u' for updates; 'd' for deletes. By default, no operations will be skipped.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SKIPPED_OPERATIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_DELAY_MS_CONF = "camel.source.endpoint.snapshotDelayMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_DELAY_MS_DOC = "The number of milliseconds to delay before a snapshot will begin.";
    public static final Long CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_DELAY_MS_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_FETCH_SIZE_CONF = "camel.source.endpoint.snapshotFetchSize";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_FETCH_SIZE_DOC = "The maximum number of records that should be loaded into memory while performing a snapshot";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_FETCH_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_ISOLATION_MODE_CONF = "camel.source.endpoint.snapshotIsolationMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_ISOLATION_MODE_DOC = "Controls which transaction isolation level is used and how long the connector locks the monitored tables. The default is 'repeatable_read', which means that repeatable read isolation level is used. In addition, exclusive locks are taken only during schema snapshot. Using a value of 'exclusive' ensures that the connector holds the exclusive lock (and thus prevents any reads and updates) for all monitored tables during the entire snapshot duration. When 'snapshot' is specified, connector runs the initial snapshot in SNAPSHOT isolation level, which guarantees snapshot consistency. In addition, neither table nor row-level locks are held. When 'read_committed' is specified, connector runs the initial snapshot in READ COMMITTED isolation level. No long-running locks are taken, so that initial snapshot does not prevent other transactions from updating table rows. Snapshot consistency is not guaranteed.In 'read_uncommitted' mode neither table nor row-level locks are acquired, but connector does not guarantee snapshot consistency.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_ISOLATION_MODE_DEFAULT = "repeatable_read";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_CONF = "camel.source.endpoint.snapshotLockTimeoutMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_DOC = "The maximum number of millis to wait for table locks at the beginning of a snapshot. If locks cannot be acquired in this time frame, the snapshot will be aborted. Defaults to 10 seconds";
    public static final Long CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_DEFAULT = 10000L;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_MODE_CONF = "camel.source.endpoint.snapshotMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_MODE_DOC = "The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_MODE_DEFAULT = "initial";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_CONF = "camel.source.endpoint.snapshotSelectStatementOverrides";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DOC = "This property contains a comma-separated list of fully-qualified tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on thespecific connectors . Select statements for the individual tables are specified in further configuration properties, one for each table, identified by the id 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME', respectively. The value of those properties is the select statement to use when retrieving data from the specific table during snapshotting. A possible use case for large append-only tables is setting a specific point where to start (resume) snapshotting, in case a previous snapshotting was interrupted.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_STRUCT_VERSION_CONF = "camel.source.endpoint.sourceStructVersion";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_STRUCT_VERSION_DOC = "A version of the format of the publicly visible source part in the message";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_STRUCT_VERSION_DEFAULT = "v2";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_TIMESTAMP_MODE_CONF = "camel.source.endpoint.sourceTimestampMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_TIMESTAMP_MODE_DOC = "Configures the criteria of the attached timestamp within the source record (ts_ms).Options include:'commit', (default) the source timestamp is set to the instant where the record was committed in the database'processing', the source timestamp is set to the instant where the record was processed by Debezium.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_TIMESTAMP_MODE_DEFAULT = "commit";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_BLACKLIST_CONF = "camel.source.endpoint.tableBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_BLACKLIST_DOC = "Description is not available here, please check Debezium website for corresponding key 'table.blacklist' description.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_IGNORE_BUILTIN_CONF = "camel.source.endpoint.tableIgnoreBuiltin";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_IGNORE_BUILTIN_DOC = "Flag specifying whether built-in tables should be ignored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_IGNORE_BUILTIN_DEFAULT = true;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_WHITELIST_CONF = "camel.source.endpoint.tableWhitelist";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_WHITELIST_DOC = "The tables for which changes are to be captured";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_WHITELIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TIME_PRECISION_MODE_CONF = "camel.source.endpoint.timePrecisionMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TIME_PRECISION_MODE_DOC = "Time, date, and timestamps can be represented with different kinds of precisions, including:'adaptive' (the default) bases the precision of time, date, and timestamp values on the database column's precision; 'adaptive_time_microseconds' like 'adaptive' mode, but TIME fields always use microseconds precision;'connect' always represents time, date, and timestamp values using Kafka Connect's built-in representations for Time, Date, and Timestamp, which uses millisecond precision regardless of the database columns' precision .";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TIME_PRECISION_MODE_DEFAULT = "adaptive";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TOMBSTONES_ON_DELETE_CONF = "camel.source.endpoint.tombstonesOnDelete";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TOMBSTONES_ON_DELETE_DOC = "Whether delete operations should be represented by a delete event and a subsquenttombstone event (true) or only by a delete event (false). Emitting the tombstone event (the default behavior) allows Kafka to completely delete all events pertaining to the given key once the source record got deleted.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TOMBSTONES_ON_DELETE_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_ADDITIONAL_PROPERTIES_CONF = "camel.component.debezium-sqlserver.additionalProperties";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_ADDITIONAL_PROPERTIES_DOC = "Additional properties for debezium components in case they can't be set directly on the camel configurations (e.g: setting Kafka Connect properties needed by Debezium engine, for example setting KafkaOffsetBackingStore), the properties have to be prefixed with additionalProperties.. E.g: additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_ADDITIONAL_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.debezium-sqlserver.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONFIGURATION_CONF = "camel.component.debezium-sqlserver.configuration";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONFIGURATION_DOC = "Allow pre-configured Configurations to be set.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_KEY_CONVERTER_CONF = "camel.component.debezium-sqlserver.internalKeyConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_KEY_CONVERTER_DOC = "The Converter class that should be used to serialize and deserialize key data for offsets. The default is JSON converter.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_KEY_CONVERTER_DEFAULT = "org.apache.kafka.connect.json.JsonConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_VALUE_CONVERTER_CONF = "camel.component.debezium-sqlserver.internalValueConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_VALUE_CONVERTER_DOC = "The Converter class that should be used to serialize and deserialize value data for offsets. The default is JSON converter.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_VALUE_CONVERTER_DEFAULT = "org.apache.kafka.connect.json.JsonConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_POLICY_CONF = "camel.component.debezium-sqlserver.offsetCommitPolicy";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_POLICY_DOC = "The name of the Java class of the commit policy. It defines when offsets commit has to be triggered based on the number of events processed and the time elapsed since the last commit. This class must implement the interface 'OffsetCommitPolicy'. The default is a periodic commit policy based upon time intervals.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_POLICY_DEFAULT = "io.debezium.embedded.spi.OffsetCommitPolicy.PeriodicCommitOffsetPolicy";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_TIMEOUT_MS_CONF = "camel.component.debezium-sqlserver.offsetCommitTimeoutMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_TIMEOUT_MS_DOC = "Maximum number of milliseconds to wait for records to flush and partition offset data to be committed to offset storage before cancelling the process and restoring the offset data to be committed in a future attempt. The default is 5 seconds.";
    public static final Long CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_TIMEOUT_MS_DEFAULT = 5000L;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_FLUSH_INTERVAL_MS_CONF = "camel.component.debezium-sqlserver.offsetFlushIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_FLUSH_INTERVAL_MS_DOC = "Interval at which to try committing offsets. The default is 1 minute.";
    public static final Long CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_FLUSH_INTERVAL_MS_DEFAULT = 60000L;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_CONF = "camel.component.debezium-sqlserver.offsetStorage";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_DOC = "The name of the Java class that is responsible for persistence of connector offsets.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_DEFAULT = "org.apache.kafka.connect.storage.FileOffsetBackingStore";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_FILE_NAME_CONF = "camel.component.debezium-sqlserver.offsetStorageFileName";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_FILE_NAME_DOC = "Path to file where offsets are to be stored. Required when offset.storage is set to the FileOffsetBackingStore.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_FILE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_PARTITIONS_CONF = "camel.component.debezium-sqlserver.offsetStoragePartitions";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_PARTITIONS_DOC = "The number of partitions used when creating the offset storage topic. Required when offset.storage is set to the 'KafkaOffsetBackingStore'.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_PARTITIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_REPLICATION_FACTOR_CONF = "camel.component.debezium-sqlserver.offsetStorageReplicationFactor";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_REPLICATION_FACTOR_DOC = "Replication factor used when creating the offset storage topic. Required when offset.storage is set to the KafkaOffsetBackingStore";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_REPLICATION_FACTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_TOPIC_CONF = "camel.component.debezium-sqlserver.offsetStorageTopic";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_TOPIC_DOC = "The name of the Kafka topic where offsets are to be stored. Required when offset.storage is set to the KafkaOffsetBackingStore.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_TOPIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.debezium-sqlserver.basicPropertyBinding";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_BLACKLIST_CONF = "camel.component.debezium-sqlserver.columnBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_BLACKLIST_DOC = "Regular expressions matching columns to exclude from change events";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_WHITELIST_CONF = "camel.component.debezium-sqlserver.columnWhitelist";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_WHITELIST_DOC = "Regular expressions matching columns to include in change events";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_WHITELIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONVERTERS_CONF = "camel.component.debezium-sqlserver.converters";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONVERTERS_DOC = "Optional list of custom converters that would be used instead of default ones. The converters are defined using '.type' config option and configured using options '.'";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONVERTERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_DBNAME_CONF = "camel.component.debezium-sqlserver.databaseDbname";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_DBNAME_DOC = "The name of the database the connector should be monitoring. When working with a multi-tenant set-up, must be set to the CDB name.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_DBNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_CONF = "camel.component.debezium-sqlserver.databaseHistory";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_DOC = "The name of the DatabaseHistory class that should be used to store and recover database schema changes. The configuration properties for the history are prefixed with the 'database.history.' string.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_DEFAULT = "io.debezium.relational.history.FileDatabaseHistory";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_FILE_FILENAME_CONF = "camel.component.debezium-sqlserver.databaseHistoryFileFilename";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_FILE_FILENAME_DOC = "The path to the file that will be used to record the database history";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_FILE_FILENAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_CONF = "camel.component.debezium-sqlserver.databaseHistoryKafkaBootstrapServers";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs that the connector will use for establishing the initial connection to the Kafka cluster for retrieving database schema history previously stored by the connector. This should point to the same Kafka cluster used by the Kafka Connect process.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_CONF = "camel.component.debezium-sqlserver.databaseHistoryKafkaRecoveryAttempts";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DOC = "The number of attempts in a row that no data are returned from Kafka before recover completes. The maximum amount of time to wait after receiving no data is (recovery.attempts) x (recovery.poll.interval.ms).";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DEFAULT = 100;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_CONF = "camel.component.debezium-sqlserver.databaseHistoryKafkaRecoveryPollIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DOC = "The number of milliseconds to wait while polling for persisted data during recovery.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DEFAULT = 100;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_TOPIC_CONF = "camel.component.debezium-sqlserver.databaseHistoryKafkaTopic";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_TOPIC_DOC = "The name of the topic for the database schema history";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_TOPIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HOSTNAME_CONF = "camel.component.debezium-sqlserver.databaseHostname";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HOSTNAME_DOC = "Resolvable hostname or IP address of the SQL Server database server.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PASSWORD_CONF = "camel.component.debezium-sqlserver.databasePassword";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PASSWORD_DOC = "Password of the SQL Server database user to be used when connecting to the database.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PORT_CONF = "camel.component.debezium-sqlserver.databasePort";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PORT_DOC = "Port of the SQL Server database server.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PORT_DEFAULT = 1433;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_NAME_CONF = "camel.component.debezium-sqlserver.databaseServerName";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_NAME_DOC = "Unique name that identifies the database server and all recorded offsets, and that is used as a prefix for all schemas and topics. Each distinct installation should have a separate namespace and be monitored by at most one Debezium connector.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_TIMEZONE_CONF = "camel.component.debezium-sqlserver.databaseServerTimezone";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_TIMEZONE_DOC = "The timezone of the server used to correctly shift the commit transaction timestamp on the client sideOptions include: Any valid Java ZoneId";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_TIMEZONE_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_USER_CONF = "camel.component.debezium-sqlserver.databaseUser";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_USER_DOC = "Name of the SQL Server database user to be used when connecting to the database.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_USER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DECIMAL_HANDLING_MODE_CONF = "camel.component.debezium-sqlserver.decimalHandlingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DECIMAL_HANDLING_MODE_DOC = "Specify how DECIMAL and NUMERIC columns should be represented in change events, including:'precise' (the default) uses java.math.BigDecimal to represent values, which are encoded in the change events using a binary representation and Kafka Connect's 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to represent values; 'double' represents values using Java's 'double', which may not offer the precision but will be far easier to use in consumers.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DECIMAL_HANDLING_MODE_DEFAULT = "precise";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_CONF = "camel.component.debezium-sqlserver.eventProcessingFailureHandlingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_DOC = "Specify how failures during processing of events (i.e. when encountering a corrupted event) should be handled, including:'fail' (the default) an exception indicating the problematic event and its position is raised, causing the connector to be stopped; 'warn' the problematic event and its position will be logged and the event will be skipped;'ignore' the problematic event will be skipped.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_DEFAULT = "fail";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_INTERVAL_MS_CONF = "camel.component.debezium-sqlserver.heartbeatIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_INTERVAL_MS_DOC = "Length of an interval in milli-seconds in in which the connector periodically sends heartbeat messages to a heartbeat topic. Use 0 to disable heartbeat messages. Disabled by default.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_INTERVAL_MS_DEFAULT = 0;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_TOPICS_PREFIX_CONF = "camel.component.debezium-sqlserver.heartbeatTopicsPrefix";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_TOPICS_PREFIX_DOC = "The prefix that is used to name heartbeat topics.Defaults to __debezium-heartbeat.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_TOPICS_PREFIX_DEFAULT = "__debezium-heartbeat";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INCLUDE_SCHEMA_CHANGES_CONF = "camel.component.debezium-sqlserver.includeSchemaChanges";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INCLUDE_SCHEMA_CHANGES_DOC = "Whether the connector should publish changes in the database schema to a Kafka topic with the same name as the database server ID. Each schema change will be recorded using a key that contains the database name and whose value include logical description of the new schema and optionally the DDL statement(s).The default is 'true'. This is independent of how the connector internally records database history.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INCLUDE_SCHEMA_CHANGES_DEFAULT = true;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_BATCH_SIZE_CONF = "camel.component.debezium-sqlserver.maxBatchSize";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_BATCH_SIZE_DOC = "Maximum size of each batch of source records. Defaults to 2048.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_BATCH_SIZE_DEFAULT = 2048;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_QUEUE_SIZE_CONF = "camel.component.debezium-sqlserver.maxQueueSize";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_QUEUE_SIZE_DOC = "Maximum size of the queue for change events read from the database log but not yet recorded or forwarded. Defaults to 8192, and should always be larger than the maximum batch size.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_QUEUE_SIZE_DEFAULT = 8192;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MESSAGE_KEY_COLUMNS_CONF = "camel.component.debezium-sqlserver.messageKeyColumns";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MESSAGE_KEY_COLUMNS_DOC = "A semicolon-separated list of expressions that match fully-qualified tables and column(s) to be used as message key. Each expression must match the pattern ':',where the table names could be defined as (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the specific connector,and the key columns are a comma-separated list of columns representing the custom key. For any table without an explicit key configuration the table's primary key column(s) will be used as message key.Example: dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MESSAGE_KEY_COLUMNS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_POLL_INTERVAL_MS_CONF = "camel.component.debezium-sqlserver.pollIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_POLL_INTERVAL_MS_DOC = "Frequency in milliseconds to wait for new change events to appear after receiving no events. Defaults to 500ms.";
    public static final Long CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_POLL_INTERVAL_MS_DEFAULT = 500L;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_PROVIDE_TRANSACTION_METADATA_CONF = "camel.component.debezium-sqlserver.provideTransactionMetadata";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_PROVIDE_TRANSACTION_METADATA_DOC = "Enables transaction metadata extraction together with event counting";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_PROVIDE_TRANSACTION_METADATA_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SANITIZE_FIELD_NAMES_CONF = "camel.component.debezium-sqlserver.sanitizeFieldNames";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SANITIZE_FIELD_NAMES_DOC = "Whether field names will be sanitized to Avro naming conventions";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SANITIZE_FIELD_NAMES_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SKIPPED_OPERATIONS_CONF = "camel.component.debezium-sqlserver.skippedOperations";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SKIPPED_OPERATIONS_DOC = "The comma-separated list of operations to skip during streaming, defined as: 'i' for inserts; 'u' for updates; 'd' for deletes. By default, no operations will be skipped.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SKIPPED_OPERATIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_DELAY_MS_CONF = "camel.component.debezium-sqlserver.snapshotDelayMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_DELAY_MS_DOC = "The number of milliseconds to delay before a snapshot will begin.";
    public static final Long CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_DELAY_MS_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_FETCH_SIZE_CONF = "camel.component.debezium-sqlserver.snapshotFetchSize";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_FETCH_SIZE_DOC = "The maximum number of records that should be loaded into memory while performing a snapshot";
    public static final Integer CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_FETCH_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_ISOLATION_MODE_CONF = "camel.component.debezium-sqlserver.snapshotIsolationMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_ISOLATION_MODE_DOC = "Controls which transaction isolation level is used and how long the connector locks the monitored tables. The default is 'repeatable_read', which means that repeatable read isolation level is used. In addition, exclusive locks are taken only during schema snapshot. Using a value of 'exclusive' ensures that the connector holds the exclusive lock (and thus prevents any reads and updates) for all monitored tables during the entire snapshot duration. When 'snapshot' is specified, connector runs the initial snapshot in SNAPSHOT isolation level, which guarantees snapshot consistency. In addition, neither table nor row-level locks are held. When 'read_committed' is specified, connector runs the initial snapshot in READ COMMITTED isolation level. No long-running locks are taken, so that initial snapshot does not prevent other transactions from updating table rows. Snapshot consistency is not guaranteed.In 'read_uncommitted' mode neither table nor row-level locks are acquired, but connector does not guarantee snapshot consistency.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_ISOLATION_MODE_DEFAULT = "repeatable_read";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_LOCK_TIMEOUT_MS_CONF = "camel.component.debezium-sqlserver.snapshotLockTimeoutMs";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_LOCK_TIMEOUT_MS_DOC = "The maximum number of millis to wait for table locks at the beginning of a snapshot. If locks cannot be acquired in this time frame, the snapshot will be aborted. Defaults to 10 seconds";
    public static final Long CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_LOCK_TIMEOUT_MS_DEFAULT = 10000L;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_MODE_CONF = "camel.component.debezium-sqlserver.snapshotMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_MODE_DOC = "The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_MODE_DEFAULT = "initial";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_CONF = "camel.component.debezium-sqlserver.snapshotSelectStatementOverrides";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DOC = "This property contains a comma-separated list of fully-qualified tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on thespecific connectors . Select statements for the individual tables are specified in further configuration properties, one for each table, identified by the id 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME', respectively. The value of those properties is the select statement to use when retrieving data from the specific table during snapshotting. A possible use case for large append-only tables is setting a specific point where to start (resume) snapshotting, in case a previous snapshotting was interrupted.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_STRUCT_VERSION_CONF = "camel.component.debezium-sqlserver.sourceStructVersion";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_STRUCT_VERSION_DOC = "A version of the format of the publicly visible source part in the message";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_STRUCT_VERSION_DEFAULT = "v2";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_TIMESTAMP_MODE_CONF = "camel.component.debezium-sqlserver.sourceTimestampMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_TIMESTAMP_MODE_DOC = "Configures the criteria of the attached timestamp within the source record (ts_ms).Options include:'commit', (default) the source timestamp is set to the instant where the record was committed in the database'processing', the source timestamp is set to the instant where the record was processed by Debezium.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_TIMESTAMP_MODE_DEFAULT = "commit";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_BLACKLIST_CONF = "camel.component.debezium-sqlserver.tableBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_BLACKLIST_DOC = "Description is not available here, please check Debezium website for corresponding key 'table.blacklist' description.";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_IGNORE_BUILTIN_CONF = "camel.component.debezium-sqlserver.tableIgnoreBuiltin";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_IGNORE_BUILTIN_DOC = "Flag specifying whether built-in tables should be ignored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_IGNORE_BUILTIN_DEFAULT = true;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_WHITELIST_CONF = "camel.component.debezium-sqlserver.tableWhitelist";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_WHITELIST_DOC = "The tables for which changes are to be captured";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_WHITELIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TIME_PRECISION_MODE_CONF = "camel.component.debezium-sqlserver.timePrecisionMode";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TIME_PRECISION_MODE_DOC = "Time, date, and timestamps can be represented with different kinds of precisions, including:'adaptive' (the default) bases the precision of time, date, and timestamp values on the database column's precision; 'adaptive_time_microseconds' like 'adaptive' mode, but TIME fields always use microseconds precision;'connect' always represents time, date, and timestamp values using Kafka Connect's built-in representations for Time, Date, and Timestamp, which uses millisecond precision regardless of the database columns' precision .";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TIME_PRECISION_MODE_DEFAULT = "adaptive";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TOMBSTONES_ON_DELETE_CONF = "camel.component.debezium-sqlserver.tombstonesOnDelete";
    public static final String CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TOMBSTONES_ON_DELETE_DOC = "Whether delete operations should be represented by a delete event and a subsquenttombstone event (true) or only by a delete event (false). Emitting the tombstone event (the default behavior) allows Kafka to completely delete all events pertaining to the given key once the source record got deleted.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TOMBSTONES_ON_DELETE_DEFAULT = false;

    public CamelDebeziumsqlserverSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelDebeziumsqlserverSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_PATH_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_PATH_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMSQLSERVER_PATH_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_ADDITIONAL_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_ADDITIONAL_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_KEY_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_KEY_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_KEY_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_VALUE_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_VALUE_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INTERNAL_VALUE_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_POLICY_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_FILE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_PARTITIONS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_TOPIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_OFFSET_STORAGE_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_WHITELIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_WHITELIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_COLUMN_WHITELIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_CONVERTERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_CONVERTERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_CONVERTERS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_DBNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_DBNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_DBNAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HISTORY_KAFKA_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HOSTNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_HOSTNAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_PORT_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_TIMEZONE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_TIMEZONE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_SERVER_TIMEZONE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_USER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_USER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DATABASE_USER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DECIMAL_HANDLING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DECIMAL_HANDLING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_DECIMAL_HANDLING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_INTERVAL_MS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INCLUDE_SCHEMA_CHANGES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INCLUDE_SCHEMA_CHANGES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_INCLUDE_SCHEMA_CHANGES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_BATCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_BATCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_BATCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_QUEUE_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_QUEUE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MAX_QUEUE_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MESSAGE_KEY_COLUMNS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MESSAGE_KEY_COLUMNS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_MESSAGE_KEY_COLUMNS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_POLL_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_POLL_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_POLL_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_PROVIDE_TRANSACTION_METADATA_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_PROVIDE_TRANSACTION_METADATA_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_PROVIDE_TRANSACTION_METADATA_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SANITIZE_FIELD_NAMES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SANITIZE_FIELD_NAMES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SANITIZE_FIELD_NAMES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SKIPPED_OPERATIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SKIPPED_OPERATIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SKIPPED_OPERATIONS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_DELAY_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_DELAY_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_DELAY_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_FETCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_FETCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_FETCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_ISOLATION_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_ISOLATION_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_ISOLATION_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_STRUCT_VERSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_STRUCT_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_STRUCT_VERSION_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_TIMESTAMP_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_TIMESTAMP_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_SOURCE_TIMESTAMP_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_IGNORE_BUILTIN_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_IGNORE_BUILTIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_IGNORE_BUILTIN_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_WHITELIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_WHITELIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TABLE_WHITELIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TIME_PRECISION_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TIME_PRECISION_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TIME_PRECISION_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TOMBSTONES_ON_DELETE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TOMBSTONES_ON_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_ENDPOINT_TOMBSTONES_ON_DELETE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_ADDITIONAL_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_ADDITIONAL_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_ADDITIONAL_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_KEY_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_KEY_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_KEY_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_VALUE_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_VALUE_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INTERNAL_VALUE_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_POLICY_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_TIMEOUT_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_COMMIT_TIMEOUT_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_FLUSH_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_FLUSH_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_FLUSH_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_FILE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_FILE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_FILE_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_PARTITIONS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_PARTITIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_PARTITIONS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_REPLICATION_FACTOR_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_REPLICATION_FACTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_REPLICATION_FACTOR_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_TOPIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_OFFSET_STORAGE_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_WHITELIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_WHITELIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_COLUMN_WHITELIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONVERTERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONVERTERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_CONVERTERS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_DBNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_DBNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_DBNAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_FILE_FILENAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_FILE_FILENAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_FILE_FILENAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_BOOTSTRAP_SERVERS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_ATTEMPTS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_RECOVERY_POLL_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_TOPIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HISTORY_KAFKA_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HOSTNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_HOSTNAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_PORT_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_TIMEZONE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_TIMEZONE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_SERVER_TIMEZONE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_USER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_USER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DATABASE_USER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DECIMAL_HANDLING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DECIMAL_HANDLING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_DECIMAL_HANDLING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_EVENT_PROCESSING_FAILURE_HANDLING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_INTERVAL_MS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_TOPICS_PREFIX_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_TOPICS_PREFIX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_HEARTBEAT_TOPICS_PREFIX_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INCLUDE_SCHEMA_CHANGES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INCLUDE_SCHEMA_CHANGES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_INCLUDE_SCHEMA_CHANGES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_BATCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_BATCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_BATCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_QUEUE_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_QUEUE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MAX_QUEUE_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MESSAGE_KEY_COLUMNS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MESSAGE_KEY_COLUMNS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_MESSAGE_KEY_COLUMNS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_POLL_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_POLL_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_POLL_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_PROVIDE_TRANSACTION_METADATA_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_PROVIDE_TRANSACTION_METADATA_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_PROVIDE_TRANSACTION_METADATA_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SANITIZE_FIELD_NAMES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SANITIZE_FIELD_NAMES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SANITIZE_FIELD_NAMES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SKIPPED_OPERATIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SKIPPED_OPERATIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SKIPPED_OPERATIONS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_DELAY_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_DELAY_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_DELAY_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_FETCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_FETCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_FETCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_ISOLATION_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_ISOLATION_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_ISOLATION_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_LOCK_TIMEOUT_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_LOCK_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_LOCK_TIMEOUT_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_STRUCT_VERSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_STRUCT_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_STRUCT_VERSION_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_TIMESTAMP_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_TIMESTAMP_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_SOURCE_TIMESTAMP_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_IGNORE_BUILTIN_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_IGNORE_BUILTIN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_IGNORE_BUILTIN_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_WHITELIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_WHITELIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TABLE_WHITELIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TIME_PRECISION_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TIME_PRECISION_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TIME_PRECISION_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TOMBSTONES_ON_DELETE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TOMBSTONES_ON_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMSQLSERVER_COMPONENT_TOMBSTONES_ON_DELETE_DOC);
        return conf;
    }
}