/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.dozer;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelDozerSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_DOZER_PATH_NAME_CONF = "camel.sink.path.name";
    public static final String CAMEL_SINK_DOZER_PATH_NAME_DOC = "A human readable name of the mapping.";
    public static final String CAMEL_SINK_DOZER_PATH_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_DOZER_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_DOZER_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_DOZER_ENDPOINT_MAPPING_CONFIGURATION_CONF = "camel.sink.endpoint.mappingConfiguration";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_MAPPING_CONFIGURATION_DOC = "The name of a DozerBeanMapperConfiguration bean in the Camel registry which should be used for configuring the Dozer mapping. This is an alternative to the mappingFile option that can be used for fine-grained control over how Dozer is configured. Remember to use a # prefix in the value to indicate that the bean is in the Camel registry (e.g. #myDozerConfig).";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_MAPPING_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_DOZER_ENDPOINT_MAPPING_FILE_CONF = "camel.sink.endpoint.mappingFile";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_MAPPING_FILE_DOC = "The location of a Dozer configuration file. The file is loaded from the classpath by default, but you can use file:, classpath:, or http: to load the configuration from a specific location.";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_MAPPING_FILE_DEFAULT = "dozerBeanMapping.xml";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_MARSHAL_ID_CONF = "camel.sink.endpoint.marshalId";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_MARSHAL_ID_DOC = "The id of a dataFormat defined within the Camel Context to use for marshalling the mapping output to a non-Java type.";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_MARSHAL_ID_DEFAULT = null;
    public static final String CAMEL_SINK_DOZER_ENDPOINT_SOURCE_MODEL_CONF = "camel.sink.endpoint.sourceModel";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_SOURCE_MODEL_DOC = "Fully-qualified class name for the source type used in the mapping. If specified, the input to the mapping is converted to the specified type before being mapped with Dozer.";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_SOURCE_MODEL_DEFAULT = null;
    public static final String CAMEL_SINK_DOZER_ENDPOINT_TARGET_MODEL_CONF = "camel.sink.endpoint.targetModel";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_TARGET_MODEL_DOC = "Fully-qualified class name for the target type used in the mapping.";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_TARGET_MODEL_DEFAULT = null;
    public static final String CAMEL_SINK_DOZER_ENDPOINT_UNMARSHAL_ID_CONF = "camel.sink.endpoint.unmarshalId";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_UNMARSHAL_ID_DOC = "The id of a dataFormat defined within the Camel Context to use for unmarshalling the mapping input from a non-Java type.";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_UNMARSHAL_ID_DEFAULT = null;
    public static final String CAMEL_SINK_DOZER_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_DOZER_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_DOZER_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_DOZER_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_DOZER_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_DOZER_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.dozer.lazyStartProducer";
    public static final String CAMEL_SINK_DOZER_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_DOZER_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_DOZER_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.dozer.basicPropertyBinding";
    public static final String CAMEL_SINK_DOZER_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_DOZER_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelDozerSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelDozerSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_DOZER_PATH_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_DOZER_PATH_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_DOZER_PATH_NAME_DOC);
        conf.define(CAMEL_SINK_DOZER_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_DOZER_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_DOZER_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_DOZER_ENDPOINT_MAPPING_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_DOZER_ENDPOINT_MAPPING_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_DOZER_ENDPOINT_MAPPING_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_DOZER_ENDPOINT_MAPPING_FILE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_DOZER_ENDPOINT_MAPPING_FILE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_DOZER_ENDPOINT_MAPPING_FILE_DOC);
        conf.define(CAMEL_SINK_DOZER_ENDPOINT_MARSHAL_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_DOZER_ENDPOINT_MARSHAL_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_DOZER_ENDPOINT_MARSHAL_ID_DOC);
        conf.define(CAMEL_SINK_DOZER_ENDPOINT_SOURCE_MODEL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_DOZER_ENDPOINT_SOURCE_MODEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_DOZER_ENDPOINT_SOURCE_MODEL_DOC);
        conf.define(CAMEL_SINK_DOZER_ENDPOINT_TARGET_MODEL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_DOZER_ENDPOINT_TARGET_MODEL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_DOZER_ENDPOINT_TARGET_MODEL_DOC);
        conf.define(CAMEL_SINK_DOZER_ENDPOINT_UNMARSHAL_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_DOZER_ENDPOINT_UNMARSHAL_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_DOZER_ENDPOINT_UNMARSHAL_ID_DOC);
        conf.define(CAMEL_SINK_DOZER_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_DOZER_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_DOZER_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_DOZER_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_DOZER_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_DOZER_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_DOZER_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_DOZER_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_DOZER_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_DOZER_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_DOZER_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_DOZER_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}