/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.debeziumpostgres;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelDebeziumpostgresSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_PATH_NAME_CONF = "camel.source.path.name";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_PATH_NAME_DOC = "Unique name for the connector. Attempting to register again with the same name will fail.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_PATH_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_ADDITIONAL_PROPERTIES_CONF = "camel.source.endpoint.additionalProperties";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_ADDITIONAL_PROPERTIES_DOC = "Additional properties for debezium components in case they can't be set directly on the camel configurations (e.g: setting Kafka Connect properties needed by Debezium engine, for example setting KafkaOffsetBackingStore), the properties have to be prefixed with additionalProperties.. E.g: additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_KEY_CONVERTER_CONF = "camel.source.endpoint.internalKeyConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_KEY_CONVERTER_DOC = "The Converter class that should be used to serialize and deserialize key data for offsets. The default is JSON converter.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_KEY_CONVERTER_DEFAULT = "org.apache.kafka.connect.json.JsonConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_VALUE_CONVERTER_CONF = "camel.source.endpoint.internalValueConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_VALUE_CONVERTER_DOC = "The Converter class that should be used to serialize and deserialize value data for offsets. The default is JSON converter.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_VALUE_CONVERTER_DEFAULT = "org.apache.kafka.connect.json.JsonConverter";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_POLICY_CONF = "camel.source.endpoint.offsetCommitPolicy";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_POLICY_DOC = "The name of the Java class of the commit policy. It defines when offsets commit has to be triggered based on the number of events processed and the time elapsed since the last commit. This class must implement the interface 'OffsetCommitPolicy'. The default is a periodic commit policy based upon time intervals.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_POLICY_DEFAULT = "io.debezium.embedded.spi.OffsetCommitPolicy.PeriodicCommitOffsetPolicy";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_CONF = "camel.source.endpoint.offsetCommitTimeoutMs";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DOC = "Maximum number of milliseconds to wait for records to flush and partition offset data to be committed to offset storage before cancelling the process and restoring the offset data to be committed in a future attempt. The default is 5 seconds.";
    public static final Long CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DEFAULT = 5000L;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_CONF = "camel.source.endpoint.offsetFlushIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DOC = "Interval at which to try committing offsets. The default is 1 minute.";
    public static final Long CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DEFAULT = 60000L;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_CONF = "camel.source.endpoint.offsetStorage";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_DOC = "The name of the Java class that is responsible for persistence of connector offsets.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_DEFAULT = "org.apache.kafka.connect.storage.FileOffsetBackingStore";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_FILE_NAME_CONF = "camel.source.endpoint.offsetStorageFileName";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DOC = "Path to file where offsets are to be stored. Required when offset.storage is set to the FileOffsetBackingStore.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_PARTITIONS_CONF = "camel.source.endpoint.offsetStoragePartitions";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DOC = "The number of partitions used when creating the offset storage topic. Required when offset.storage is set to the 'KafkaOffsetBackingStore'.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_CONF = "camel.source.endpoint.offsetStorageReplicationFactor";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DOC = "Replication factor used when creating the offset storage topic. Required when offset.storage is set to the KafkaOffsetBackingStore";
    public static final Integer CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_TOPIC_CONF = "camel.source.endpoint.offsetStorageTopic";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_TOPIC_DOC = "The name of the Kafka topic where offsets are to be stored. Required when offset.storage is set to the KafkaOffsetBackingStore.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_TOPIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_COLUMN_BLACKLIST_CONF = "camel.source.endpoint.columnBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_COLUMN_BLACKLIST_DOC = "Description is not available here, please check Debezium website for corresponding key 'column.blacklist' description.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_COLUMN_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_DBNAME_CONF = "camel.source.endpoint.databaseDbname";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_DBNAME_DOC = "The name of the database the connector should be monitoring";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_DBNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_CONF = "camel.source.endpoint.databaseHistoryFileFilename";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DOC = "The path to the file that will be used to record the database history";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HOSTNAME_CONF = "camel.source.endpoint.databaseHostname";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HOSTNAME_DOC = "Resolvable hostname or IP address of the Postgres database server.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HOSTNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_INITIAL_STATEMENTS_CONF = "camel.source.endpoint.databaseInitialStatements";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_INITIAL_STATEMENTS_DOC = "A semicolon separated list of SQL statements to be executed when a JDBC connection to the database is established. Note that the connector may establish JDBC connections at its own discretion, so this should typically be used for configurationof session parameters only, but not for executing DML statements. Use doubled semicolon (';;') to use a semicolon as a character and not as a delimiter.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_INITIAL_STATEMENTS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PASSWORD_CONF = "camel.source.endpoint.databasePassword";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PASSWORD_DOC = "Password of the Postgres database user to be used when connecting to the database.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PORT_CONF = "camel.source.endpoint.databasePort";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PORT_DOC = "Port of the Postgres database server.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PORT_DEFAULT = 5432;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SERVER_NAME_CONF = "camel.source.endpoint.databaseServerName";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SERVER_NAME_DOC = "Unique name that identifies the database server and all recorded offsets, and that is used as a prefix for all schemas and topics. Each distinct installation should have a separate namespace and be monitored by at most one Debezium connector.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SERVER_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLCERT_CONF = "camel.source.endpoint.databaseSslcert";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLCERT_DOC = "File containing the SSL Certificate for the client. See the Postgres SSL docs for further information";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLCERT_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLFACTORY_CONF = "camel.source.endpoint.databaseSslfactory";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLFACTORY_DOC = "A name of class to that creates SSL Sockets. Use org.postgresql.ssl.NonValidatingFactory to disable SSL validation in development environments";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLFACTORY_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLKEY_CONF = "camel.source.endpoint.databaseSslkey";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLKEY_DOC = "File containing the SSL private key for the client. See the Postgres SSL docs for further information";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLKEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLMODE_CONF = "camel.source.endpoint.databaseSslmode";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLMODE_DOC = "Whether to use an encrypted connection to Postgres. Options include'disable' (the default) to use an unencrypted connection; 'require' to use a secure (encrypted) connection, and fail if one cannot be established; 'verify-ca' like 'required' but additionally verify the server TLS certificate against the configured Certificate Authority (CA) certificates, or fail if no valid matching CA certificates are found; or'verify-full' like 'verify-ca' but additionally verify that the server certificate matches the host to which the connection is attempted.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLMODE_DEFAULT = "disable";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLPASSWORD_CONF = "camel.source.endpoint.databaseSslpassword";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLPASSWORD_DOC = "Password to access the client private key from the file specified by 'database.sslkey'. See the Postgres SSL docs for further information";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLPASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLROOTCERT_CONF = "camel.source.endpoint.databaseSslrootcert";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLROOTCERT_DOC = "File containing the root certificate(s) against which the server is validated. See the Postgres JDBC SSL docs for further information";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLROOTCERT_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_TCPKEEPALIVE_CONF = "camel.source.endpoint.databaseTcpkeepalive";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_TCPKEEPALIVE_DOC = "Enable or disable TCP keep-alive probe to avoid dropping TCP connection";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_TCPKEEPALIVE_DEFAULT = true;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_USER_CONF = "camel.source.endpoint.databaseUser";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_USER_DOC = "Name of the Postgres database user to be used when connecting to the database.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_USER_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DECIMAL_HANDLING_MODE_CONF = "camel.source.endpoint.decimalHandlingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DECIMAL_HANDLING_MODE_DOC = "Specify how DECIMAL and NUMERIC columns should be represented in change events, including:'precise' (the default) uses java.math.BigDecimal to represent values, which are encoded in the change events using a binary representation and Kafka Connect's 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to represent values; 'double' represents values using Java's 'double', which may not offer the precision but will be far easier to use in consumers.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DECIMAL_HANDLING_MODE_DEFAULT = "precise";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_INTERVAL_MS_CONF = "camel.source.endpoint.heartbeatIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_INTERVAL_MS_DOC = "Length of an interval in milli-seconds in in which the connector periodically sends heartbeat messages to a heartbeat topic. Use 0 to disable heartbeat messages. Disabled by default.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_INTERVAL_MS_DEFAULT = 0;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_CONF = "camel.source.endpoint.heartbeatTopicsPrefix";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DOC = "The prefix that is used to name heartbeat topics.Defaults to __debezium-heartbeat.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DEFAULT = "__debezium-heartbeat";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HSTORE_HANDLING_MODE_CONF = "camel.source.endpoint.hstoreHandlingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HSTORE_HANDLING_MODE_DOC = "Specify how HSTORE columns should be represented in change events, including:'json' represents values as json string'map' (default) represents values using java.util.Map";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HSTORE_HANDLING_MODE_DEFAULT = "json";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INCLUDE_UNKNOWN_DATATYPES_CONF = "camel.source.endpoint.includeUnknownDatatypes";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INCLUDE_UNKNOWN_DATATYPES_DOC = "Specify whether the fields of data type not supported by Debezium should be processed:'false' (the default) omits the fields; 'true' converts the field into an implementation dependent binary representation.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INCLUDE_UNKNOWN_DATATYPES_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERVAL_HANDLING_MODE_CONF = "camel.source.endpoint.intervalHandlingMode";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERVAL_HANDLING_MODE_DOC = "Specify how INTERVAL columns should be represented in change events, including:'string' represents values as an exact ISO formatted string'numeric' (default) represents values using the inexact conversion into microseconds";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERVAL_HANDLING_MODE_DEFAULT = "numeric";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_BATCH_SIZE_CONF = "camel.source.endpoint.maxBatchSize";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_BATCH_SIZE_DOC = "Maximum size of each batch of source records. Defaults to 2048.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_BATCH_SIZE_DEFAULT = 2048;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_QUEUE_SIZE_CONF = "camel.source.endpoint.maxQueueSize";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_QUEUE_SIZE_DOC = "Maximum size of the queue for change events read from the database log but not yet recorded or forwarded. Defaults to 8192, and should always be larger than the maximum batch size.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_QUEUE_SIZE_DEFAULT = 8192;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MESSAGE_KEY_COLUMNS_CONF = "camel.source.endpoint.messageKeyColumns";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MESSAGE_KEY_COLUMNS_DOC = "A semicolon-separated list of expressions that match fully-qualified tables and column(s) to be used as message key. Each expression must match the pattern ':',where the table names could be defined as (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the specific connector,and the key columns are a comma-separated list of columns representing the custom key. For any table without an explicit key configuration the table's primary key column(s) will be used as message key.Example: dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MESSAGE_KEY_COLUMNS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PLUGIN_NAME_CONF = "camel.source.endpoint.pluginName";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PLUGIN_NAME_DOC = "The name of the Postgres logical decoding plugin installed on the server. Supported values are 'decoderbufs' and 'wal2json'. Defaults to 'decoderbufs'.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PLUGIN_NAME_DEFAULT = "decoderbufs";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_POLL_INTERVAL_MS_CONF = "camel.source.endpoint.pollIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_POLL_INTERVAL_MS_DOC = "Frequency in milliseconds to wait for new change events to appear after receiving no events. Defaults to 500ms.";
    public static final Long CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_POLL_INTERVAL_MS_DEFAULT = 500L;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PUBLICATION_NAME_CONF = "camel.source.endpoint.publicationName";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PUBLICATION_NAME_DOC = "The name of the Postgres 10 publication used for streaming changes from a plugin.Defaults to 'dbz_publication'";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PUBLICATION_NAME_DEFAULT = "dbz_publication";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_BLACKLIST_CONF = "camel.source.endpoint.schemaBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_BLACKLIST_DOC = "The schemas for which events must not be captured";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_REFRESH_MODE_CONF = "camel.source.endpoint.schemaRefreshMode";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_REFRESH_MODE_DOC = "Specify the conditions that trigger a refresh of the in-memory schema for a table. 'columns_diff' (the default) is the safest mode, ensuring the in-memory schema stays in-sync with the database table's schema at all times. 'columns_diff_exclude_unchanged_toast' instructs the connector to refresh the in-memory schema cache if there is a discrepancy between it and the schema derived from the incoming message, unless unchanged TOASTable data fully accounts for the discrepancy. This setting can improve connector performance significantly if there are frequently-updated tables that have TOASTed data that are rarely part of these updates. However, it is possible for the in-memory schema to become outdated if TOASTable columns are dropped from the table.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_REFRESH_MODE_DEFAULT = "columns_diff";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_WHITELIST_CONF = "camel.source.endpoint.schemaWhitelist";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_WHITELIST_DOC = "The schemas for which events should be captured";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_WHITELIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_DROP_ON_STOP_CONF = "camel.source.endpoint.slotDropOnStop";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_DROP_ON_STOP_DOC = "Whether or not to drop the logical replication slot when the connector finishes orderlyBy default the replication is kept so that on restart progress can resume from the last recorded location";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_DROP_ON_STOP_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_MAX_RETRIES_CONF = "camel.source.endpoint.slotMaxRetries";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_MAX_RETRIES_DOC = "How many times to retry connecting to a replication slot when an attempt fails.";
    public static final Integer CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_MAX_RETRIES_DEFAULT = 6;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_NAME_CONF = "camel.source.endpoint.slotName";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_NAME_DOC = "The name of the Postgres logical decoding slot created for streaming changes from a plugin.Defaults to 'debezium";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_NAME_DEFAULT = "debezium";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_RETRY_DELAY_MS_CONF = "camel.source.endpoint.slotRetryDelayMs";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_RETRY_DELAY_MS_DOC = "The number of milli-seconds to wait between retry attempts when the connector fails to connect to a replication slot.";
    public static final Long CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_RETRY_DELAY_MS_DEFAULT = 10000L;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_STREAM_PARAMS_CONF = "camel.source.endpoint.slotStreamParams";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_STREAM_PARAMS_DOC = "Any optional parameters used by logical decoding plugin. Semi-colon separated. E.g. 'add-tables=public.table,public.table2;include-lsn=true'";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_STREAM_PARAMS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_CUSTOM_CLASS_CONF = "camel.source.endpoint.snapshotCustomClass";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_CUSTOM_CLASS_DOC = "When 'snapshot.mode' is set as custom, this setting must be set to specify a fully qualified class name to load (via the default class loader).This class must implement the 'Snapshotter' interface and is called on each app boot to determine whether to do a snapshot and how to build queries.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_CUSTOM_CLASS_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_DELAY_MS_CONF = "camel.source.endpoint.snapshotDelayMs";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_DELAY_MS_DOC = "The number of milliseconds to delay before a snapshot will begin.";
    public static final Long CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_DELAY_MS_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_FETCH_SIZE_CONF = "camel.source.endpoint.snapshotFetchSize";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_FETCH_SIZE_DOC = "The maximum number of records that should be loaded into memory while performing a snapshot";
    public static final Integer CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_FETCH_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_CONF = "camel.source.endpoint.snapshotLockTimeoutMs";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_DOC = "The maximum number of millis to wait for table locks at the beginning of a snapshot. If locks cannot be acquired in this time frame, the snapshot will be aborted. Defaults to 10 seconds";
    public static final Long CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_DEFAULT = 10000L;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_MODE_CONF = "camel.source.endpoint.snapshotMode";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_MODE_DOC = "The criteria for running a snapshot upon startup of the connector. Options include: 'always' to specify that the connector run a snapshot each time it starts up; 'initial' (the default) to specify the connector can run a snapshot only when no offsets are available for the logical server name; 'initial_only' same as 'initial' except the connector should stop after completing the snapshot and before it would normally start emitting changes;'never' to specify the connector should never run a snapshot and that upon first startup the connector should read from the last position (LSN) recorded by the server; and'exported' to specify the connector should run a snapshot based on the position when the replication slot was created; 'custom' to specify a custom class with 'snapshot.custom_class' which will be loaded and used to determine the snapshot, see docs for more details.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_MODE_DEFAULT = "initial";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_CONF = "camel.source.endpoint.snapshotSelectStatementOverrides";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DOC = "This property contains a comma-separated list of fully-qualified tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on thespecific connectors . Select statements for the individual tables are specified in further configuration properties, one for each table, identified by the id 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME', respectively. The value of those properties is the select statement to use when retrieving data from the specific table during snapshotting. A possible use case for large append-only tables is setting a specific point where to start (resume) snapshotting, in case a previous snapshotting was interrupted.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SOURCE_STRUCT_VERSION_CONF = "camel.source.endpoint.sourceStructVersion";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SOURCE_STRUCT_VERSION_DOC = "A version of the format of the publicly visible source part in the message";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SOURCE_STRUCT_VERSION_DEFAULT = "v2";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_STATUS_UPDATE_INTERVAL_MS_CONF = "camel.source.endpoint.statusUpdateIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_STATUS_UPDATE_INTERVAL_MS_DOC = "Frequency in milliseconds for sending replication connection status updates to the server. Defaults to 10 seconds (10000 ms).";
    public static final Integer CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_STATUS_UPDATE_INTERVAL_MS_DEFAULT = 10000;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_BLACKLIST_CONF = "camel.source.endpoint.tableBlacklist";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_BLACKLIST_DOC = "Description is not available here, please check Debezium website for corresponding key 'table.blacklist' description.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_BLACKLIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_WHITELIST_CONF = "camel.source.endpoint.tableWhitelist";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_WHITELIST_DOC = "The tables for which changes are to be captured";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_WHITELIST_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TIME_PRECISION_MODE_CONF = "camel.source.endpoint.timePrecisionMode";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TIME_PRECISION_MODE_DOC = "Time, date, and timestamps can be represented with different kinds of precisions, including:'adaptive' (the default) bases the precision of time, date, and timestamp values on the database column's precision; 'adaptive_time_microseconds' like 'adaptive' mode, but TIME fields always use microseconds precision;'connect' always represents time, date, and timestamp values using Kafka Connect's built-in representations for Time, Date, and Timestamp, which uses millisecond precision regardless of the database columns' precision .";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TIME_PRECISION_MODE_DEFAULT = "adaptive";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOASTED_VALUE_PLACEHOLDER_CONF = "camel.source.endpoint.toastedValuePlaceholder";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOASTED_VALUE_PLACEHOLDER_DOC = "Specify the constant that will be provided by Debezium to indicate that the original value is a toasted value not provided by the database.If starts with 'hex:' prefix it is expected that the rest of the string repesents hexadecimally encoded octets.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOASTED_VALUE_PLACEHOLDER_DEFAULT = "__debezium_unavailable_value";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOMBSTONES_ON_DELETE_CONF = "camel.source.endpoint.tombstonesOnDelete";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOMBSTONES_ON_DELETE_DOC = "Whether delete operations should be represented by a delete event and a subsquenttombstone event (true) or only by a delete event (false). Emitting the tombstone event (the default behavior) allows Kafka to completely delete all events pertaining to the given key once the source record got deleted.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOMBSTONES_ON_DELETE_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_XMIN_FETCH_INTERVAL_MS_CONF = "camel.source.endpoint.xminFetchIntervalMs";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_XMIN_FETCH_INTERVAL_MS_DOC = "Specify how often (in ms) the xmin will be fetched from the replication slot. This xmin value is exposed by the slot which gives a lower bound of where a new replication slot could start from. The lower the value, the more likely this value is to be the current 'true' value, but the bigger the performance cost. The bigger the value, the less likely this value is to be the current 'true' value, but the lower the performance penalty. The default is set to 0 ms, which disables tracking xmin.";
    public static final Long CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_XMIN_FETCH_INTERVAL_MS_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.debezium-postgres.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_CONFIGURATION_CONF = "camel.component.debezium-postgres.configuration";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_CONFIGURATION_DOC = "Allow pre-configured Configurations to be set.";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.debezium-postgres.basicPropertyBinding";
    public static final String CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelDebeziumpostgresSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelDebeziumpostgresSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_PATH_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_PATH_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMPOSTGRES_PATH_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_ADDITIONAL_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_ADDITIONAL_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_KEY_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_KEY_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_KEY_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_VALUE_CONVERTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_VALUE_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERNAL_VALUE_CONVERTER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_POLICY_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_COMMIT_TIMEOUT_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_FLUSH_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_FILE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_FILE_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_PARTITIONS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_PARTITIONS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_REPLICATION_FACTOR_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_TOPIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_TOPIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_OFFSET_STORAGE_TOPIC_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_COLUMN_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_COLUMN_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_COLUMN_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_DBNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_DBNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_DBNAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HISTORY_FILE_FILENAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HOSTNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HOSTNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_HOSTNAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_INITIAL_STATEMENTS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_INITIAL_STATEMENTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_INITIAL_STATEMENTS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PORT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_PORT_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SERVER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SERVER_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SERVER_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLCERT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLCERT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLCERT_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLFACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLFACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLFACTORY_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLKEY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLKEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLKEY_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLMODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLMODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLMODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLPASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLPASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLPASSWORD_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLROOTCERT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLROOTCERT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_SSLROOTCERT_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_TCPKEEPALIVE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_TCPKEEPALIVE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_TCPKEEPALIVE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_USER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_USER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DATABASE_USER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DECIMAL_HANDLING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DECIMAL_HANDLING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_DECIMAL_HANDLING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_INTERVAL_MS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HEARTBEAT_TOPICS_PREFIX_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HSTORE_HANDLING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HSTORE_HANDLING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_HSTORE_HANDLING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INCLUDE_UNKNOWN_DATATYPES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INCLUDE_UNKNOWN_DATATYPES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INCLUDE_UNKNOWN_DATATYPES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERVAL_HANDLING_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERVAL_HANDLING_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_INTERVAL_HANDLING_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_BATCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_BATCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_BATCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_QUEUE_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_QUEUE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MAX_QUEUE_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MESSAGE_KEY_COLUMNS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MESSAGE_KEY_COLUMNS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_MESSAGE_KEY_COLUMNS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PLUGIN_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PLUGIN_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PLUGIN_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_POLL_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_POLL_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_POLL_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PUBLICATION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PUBLICATION_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_PUBLICATION_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_REFRESH_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_REFRESH_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_REFRESH_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_WHITELIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_WHITELIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SCHEMA_WHITELIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_DROP_ON_STOP_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_DROP_ON_STOP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_DROP_ON_STOP_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_MAX_RETRIES_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_MAX_RETRIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_MAX_RETRIES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_NAME_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_RETRY_DELAY_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_RETRY_DELAY_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_RETRY_DELAY_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_STREAM_PARAMS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_STREAM_PARAMS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SLOT_STREAM_PARAMS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_CUSTOM_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_CUSTOM_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_CUSTOM_CLASS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_DELAY_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_DELAY_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_DELAY_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_FETCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_FETCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_FETCH_SIZE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_LOCK_TIMEOUT_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SNAPSHOT_SELECT_STATEMENT_OVERRIDES_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SOURCE_STRUCT_VERSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SOURCE_STRUCT_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_SOURCE_STRUCT_VERSION_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_STATUS_UPDATE_INTERVAL_MS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_STATUS_UPDATE_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_STATUS_UPDATE_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_BLACKLIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_BLACKLIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_BLACKLIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_WHITELIST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_WHITELIST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TABLE_WHITELIST_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TIME_PRECISION_MODE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TIME_PRECISION_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TIME_PRECISION_MODE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOASTED_VALUE_PLACEHOLDER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOASTED_VALUE_PLACEHOLDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOASTED_VALUE_PLACEHOLDER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOMBSTONES_ON_DELETE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOMBSTONES_ON_DELETE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_TOMBSTONES_ON_DELETE_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_XMIN_FETCH_INTERVAL_MS_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_XMIN_FETCH_INTERVAL_MS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_ENDPOINT_XMIN_FETCH_INTERVAL_MS_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_DEBEZIUMPOSTGRES_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}