/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Represents a camel-workday endpoint.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WorkdayEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Workday component.
     */
    public interface WorkdayEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedWorkdayEndpointConsumerBuilder advanced() {
            return (AdvancedWorkdayEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default WorkdayEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default WorkdayEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Workday Report as a service output format.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: format
         */
        default WorkdayEndpointConsumerBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Workday Host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: host
         */
        default WorkdayEndpointConsumerBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Workday Client Id generated by API Client for Integrations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WorkdayEndpointConsumerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Workday Client Secrect generated by API Client for Integrations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WorkdayEndpointConsumerBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * Workday Token Refresh generated for Integration system user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WorkdayEndpointConsumerBuilder tokenRefresh(String tokenRefresh) {
            doSetProperty("tokenRefresh", tokenRefresh);
            return this;
        }
        /**
         * Workday Tenant name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: tenant
         */
        default WorkdayEndpointConsumerBuilder tenant(String tenant) {
            doSetProperty("tenant", tenant);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Workday component.
     */
    public interface AdvancedWorkdayEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default WorkdayEndpointConsumerBuilder basic() {
            return (WorkdayEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWorkdayEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWorkdayEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWorkdayEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWorkdayEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Pool connection manager for advanced configuration.
         * 
         * The option is a:
         * <code>org.apache.http.impl.conn.PoolingHttpClientConnectionManager</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWorkdayEndpointConsumerBuilder httpConnectionManager(
                Object httpConnectionManager) {
            doSetProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * Pool connection manager for advanced configuration.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.conn.PoolingHttpClientConnectionManager</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWorkdayEndpointConsumerBuilder httpConnectionManager(
                String httpConnectionManager) {
            doSetProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Workday component.
     */
    public interface WorkdayEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWorkdayEndpointProducerBuilder advanced() {
            return (AdvancedWorkdayEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default WorkdayEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default WorkdayEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Workday Report as a service output format.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: format
         */
        default WorkdayEndpointProducerBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Workday Host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: host
         */
        default WorkdayEndpointProducerBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Workday Client Id generated by API Client for Integrations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WorkdayEndpointProducerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Workday Client Secrect generated by API Client for Integrations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WorkdayEndpointProducerBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * Workday Token Refresh generated for Integration system user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WorkdayEndpointProducerBuilder tokenRefresh(String tokenRefresh) {
            doSetProperty("tokenRefresh", tokenRefresh);
            return this;
        }
        /**
         * Workday Tenant name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: tenant
         */
        default WorkdayEndpointProducerBuilder tenant(String tenant) {
            doSetProperty("tenant", tenant);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Workday component.
     */
    public interface AdvancedWorkdayEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default WorkdayEndpointProducerBuilder basic() {
            return (WorkdayEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Pool connection manager for advanced configuration.
         * 
         * The option is a:
         * <code>org.apache.http.impl.conn.PoolingHttpClientConnectionManager</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWorkdayEndpointProducerBuilder httpConnectionManager(
                Object httpConnectionManager) {
            doSetProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * Pool connection manager for advanced configuration.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.conn.PoolingHttpClientConnectionManager</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWorkdayEndpointProducerBuilder httpConnectionManager(
                String httpConnectionManager) {
            doSetProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Workday component.
     */
    public interface WorkdayEndpointBuilder
            extends
                WorkdayEndpointConsumerBuilder,
                WorkdayEndpointProducerBuilder {
        default AdvancedWorkdayEndpointBuilder advanced() {
            return (AdvancedWorkdayEndpointBuilder) this;
        }
        /**
         * Workday Report as a service output format.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: format
         */
        default WorkdayEndpointBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Workday Host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: host
         */
        default WorkdayEndpointBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Workday Client Id generated by API Client for Integrations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WorkdayEndpointBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Workday Client Secrect generated by API Client for Integrations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WorkdayEndpointBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * Workday Token Refresh generated for Integration system user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WorkdayEndpointBuilder tokenRefresh(String tokenRefresh) {
            doSetProperty("tokenRefresh", tokenRefresh);
            return this;
        }
        /**
         * Workday Tenant name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: tenant
         */
        default WorkdayEndpointBuilder tenant(String tenant) {
            doSetProperty("tenant", tenant);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Workday component.
     */
    public interface AdvancedWorkdayEndpointBuilder
            extends
                AdvancedWorkdayEndpointConsumerBuilder,
                AdvancedWorkdayEndpointProducerBuilder {
        default WorkdayEndpointBuilder basic() {
            return (WorkdayEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Pool connection manager for advanced configuration.
         * 
         * The option is a:
         * <code>org.apache.http.impl.conn.PoolingHttpClientConnectionManager</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWorkdayEndpointBuilder httpConnectionManager(
                Object httpConnectionManager) {
            doSetProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * Pool connection manager for advanced configuration.
         * 
         * The option will be converted to a
         * <code>org.apache.http.impl.conn.PoolingHttpClientConnectionManager</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWorkdayEndpointBuilder httpConnectionManager(
                String httpConnectionManager) {
            doSetProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWorkdayEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface WorkdayBuilders {
        /**
         * Workday (camel-workday)
         * Represents a camel-workday endpoint.
         * 
         * Category: hcm
         * Since: 3.1.0-SNAPSHOT
         * Maven coordinates: org.apache.camel:camel-workday
         * 
         * Syntax: <code>workday:uri</code>
         * 
         * Path parameter: uri (required)
         * The partial URL for RAAS report.
         */
        default WorkdayEndpointBuilder workday(String path) {
            return WorkdayEndpointBuilderFactory.workday(path);
        }
    }
    /**
     * Workday (camel-workday)
     * Represents a camel-workday endpoint.
     * 
     * Category: hcm
     * Since: 3.1.0-SNAPSHOT
     * Maven coordinates: org.apache.camel:camel-workday
     * 
     * Syntax: <code>workday:uri</code>
     * 
     * Path parameter: uri (required)
     * The partial URL for RAAS report.
     */
    static WorkdayEndpointBuilder workday(String path) {
        class WorkdayEndpointBuilderImpl extends AbstractEndpointBuilder implements WorkdayEndpointBuilder, AdvancedWorkdayEndpointBuilder {
            public WorkdayEndpointBuilderImpl(String path) {
                super("workday", path);
            }
        }
        return new WorkdayEndpointBuilderImpl(path);
    }
}