/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.io.File;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * To insert or query from Apache Lucene databases.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface LuceneEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Lucene component.
     */
    public interface LuceneEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedLuceneEndpointBuilder advanced() {
            return (AdvancedLuceneEndpointBuilder) this;
        }
        /**
         * An Analyzer builds TokenStreams, which analyze text. It thus
         * represents a policy for extracting index terms from text. The value
         * for analyzer can be any class that extends the abstract class
         * org.apache.lucene.analysis.Analyzer. Lucene also offers a rich set of
         * analyzers out of the box.
         * 
         * The option is a: <code>org.apache.lucene.analysis.Analyzer</code>
         * type.
         * 
         * Group: producer
         */
        default LuceneEndpointBuilder analyzer(Object analyzer) {
            doSetProperty("analyzer", analyzer);
            return this;
        }
        /**
         * An Analyzer builds TokenStreams, which analyze text. It thus
         * represents a policy for extracting index terms from text. The value
         * for analyzer can be any class that extends the abstract class
         * org.apache.lucene.analysis.Analyzer. Lucene also offers a rich set of
         * analyzers out of the box.
         * 
         * The option will be converted to a
         * <code>org.apache.lucene.analysis.Analyzer</code> type.
         * 
         * Group: producer
         */
        default LuceneEndpointBuilder analyzer(String analyzer) {
            doSetProperty("analyzer", analyzer);
            return this;
        }
        /**
         * A file system directory in which index files are created upon
         * analysis of the document by the specified analyzer.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: producer
         */
        default LuceneEndpointBuilder indexDir(File indexDir) {
            doSetProperty("indexDir", indexDir);
            return this;
        }
        /**
         * A file system directory in which index files are created upon
         * analysis of the document by the specified analyzer.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: producer
         */
        default LuceneEndpointBuilder indexDir(String indexDir) {
            doSetProperty("indexDir", indexDir);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default LuceneEndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default LuceneEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * An integer value that limits the result set of the search operation.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: producer
         */
        default LuceneEndpointBuilder maxHits(int maxHits) {
            doSetProperty("maxHits", maxHits);
            return this;
        }
        /**
         * An integer value that limits the result set of the search operation.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: producer
         */
        default LuceneEndpointBuilder maxHits(String maxHits) {
            doSetProperty("maxHits", maxHits);
            return this;
        }
        /**
         * An optional directory containing files to be used to be analyzed and
         * added to the index at producer startup.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: producer
         */
        default LuceneEndpointBuilder srcDir(File srcDir) {
            doSetProperty("srcDir", srcDir);
            return this;
        }
        /**
         * An optional directory containing files to be used to be analyzed and
         * added to the index at producer startup.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: producer
         */
        default LuceneEndpointBuilder srcDir(String srcDir) {
            doSetProperty("srcDir", srcDir);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Lucene component.
     */
    public interface AdvancedLuceneEndpointBuilder
            extends
                EndpointProducerBuilder {
        default LuceneEndpointBuilder basic() {
            return (LuceneEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedLuceneEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedLuceneEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedLuceneEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedLuceneEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface LuceneBuilders {
        /**
         * Lucene (camel-lucene)
         * To insert or query from Apache Lucene databases.
         * 
         * Category: database,search
         * Since: 2.2
         * Maven coordinates: org.apache.camel:camel-lucene
         * 
         * Syntax: <code>lucene:host:operation</code>
         * 
         * Path parameter: host (required)
         * The URL to the lucene server
         * 
         * Path parameter: operation (required)
         * Operation to do such as insert or query.
         * The value can be one of: insert, query
         */
        default LuceneEndpointBuilder lucene(String path) {
            return LuceneEndpointBuilderFactory.lucene(path);
        }
    }
    /**
     * Lucene (camel-lucene)
     * To insert or query from Apache Lucene databases.
     * 
     * Category: database,search
     * Since: 2.2
     * Maven coordinates: org.apache.camel:camel-lucene
     * 
     * Syntax: <code>lucene:host:operation</code>
     * 
     * Path parameter: host (required)
     * The URL to the lucene server
     * 
     * Path parameter: operation (required)
     * Operation to do such as insert or query.
     * The value can be one of: insert, query
     */
    static LuceneEndpointBuilder lucene(String path) {
        class LuceneEndpointBuilderImpl extends AbstractEndpointBuilder implements LuceneEndpointBuilder, AdvancedLuceneEndpointBuilder {
            public LuceneEndpointBuilderImpl(String path) {
                super("lucene", path);
            }
        }
        return new LuceneEndpointBuilderImpl(path);
    }
}