/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The jbpm component provides integration with jBPM (Business Process
 * Management).
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface JBPMEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the JBPM component.
     */
    public interface JBPMEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedJBPMEndpointConsumerBuilder advanced() {
            return (AdvancedJBPMEndpointConsumerBuilder) this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder attachmentId(Long attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder attachmentId(String attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder contentId(Long contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder contentId(String contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * The id of the deployment.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default JBPMEndpointConsumerBuilder deploymentId(String deploymentId) {
            doSetProperty("deploymentId", deploymentId);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder emitterSendItems(
                Boolean emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder emitterSendItems(
                String emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder event(Object event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder event(String event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the type of event to use when signalEvent operation is performed.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder eventType(String eventType) {
            doSetProperty("eventType", eventType);
            return this;
        }
        /**
         * identifier the global identifier.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder maxNumber(Integer maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder maxNumber(String maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder page(Integer page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder page(String page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder pageSize(Integer pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder pageSize(String pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * the id of the process that should be acted upon.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder processId(String processId) {
            doSetProperty("processId", processId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder processInstanceId(
                Long processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder processInstanceId(
                String processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * The targetUserId used when delegating a task.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder targetUserId(String targetUserId) {
            doSetProperty("targetUserId", targetUserId);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option is a: <code>org.kie.api.task.model.Task</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder task(Object task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option will be converted to a
         * <code>org.kie.api.task.model.Task</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder task(String task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder taskId(Long taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder taskId(String taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder timeout(Integer timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * userId to use with task operations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder value(Object value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder workItemId(Long workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointConsumerBuilder workItemId(String workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default JBPMEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default JBPMEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: filter
         */
        default JBPMEndpointConsumerBuilder statuses(List<String> statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: filter
         */
        default JBPMEndpointConsumerBuilder statuses(String statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * Password for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default JBPMEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default JBPMEndpointConsumerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the JBPM component.
     */
    public interface AdvancedJBPMEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default JBPMEndpointConsumerBuilder basic() {
            return (JBPMEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJBPMEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJBPMEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJBPMEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJBPMEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointConsumerBuilder entities(
                List<String> entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointConsumerBuilder entities(String entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option is a: <code>java.lang.Class[]</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointConsumerBuilder extraJaxbClasses(
                Class[] extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option will be converted to a <code>java.lang.Class[]</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointConsumerBuilder extraJaxbClasses(
                String extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointConsumerBuilder parameters(
                Map<String, Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointConsumerBuilder parameters(String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the JBPM component.
     */
    public interface JBPMEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedJBPMEndpointProducerBuilder advanced() {
            return (AdvancedJBPMEndpointProducerBuilder) this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder attachmentId(Long attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder attachmentId(String attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder contentId(Long contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder contentId(String contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * The id of the deployment.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default JBPMEndpointProducerBuilder deploymentId(String deploymentId) {
            doSetProperty("deploymentId", deploymentId);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder emitterSendItems(
                Boolean emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder emitterSendItems(
                String emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder event(Object event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder event(String event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the type of event to use when signalEvent operation is performed.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder eventType(String eventType) {
            doSetProperty("eventType", eventType);
            return this;
        }
        /**
         * identifier the global identifier.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder maxNumber(Integer maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder maxNumber(String maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder page(Integer page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder page(String page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder pageSize(Integer pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder pageSize(String pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * the id of the process that should be acted upon.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder processId(String processId) {
            doSetProperty("processId", processId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder processInstanceId(
                Long processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder processInstanceId(
                String processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * The targetUserId used when delegating a task.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder targetUserId(String targetUserId) {
            doSetProperty("targetUserId", targetUserId);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option is a: <code>org.kie.api.task.model.Task</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder task(Object task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option will be converted to a
         * <code>org.kie.api.task.model.Task</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder task(String task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder taskId(Long taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder taskId(String taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder timeout(Integer timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * userId to use with task operations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder value(Object value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder workItemId(Long workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointProducerBuilder workItemId(String workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default JBPMEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default JBPMEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: startProcess
         * Group: producer
         */
        default JBPMEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: filter
         */
        default JBPMEndpointProducerBuilder statuses(List<String> statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: filter
         */
        default JBPMEndpointProducerBuilder statuses(String statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * Password for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default JBPMEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default JBPMEndpointProducerBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the JBPM component.
     */
    public interface AdvancedJBPMEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default JBPMEndpointProducerBuilder basic() {
            return (JBPMEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointProducerBuilder entities(
                List<String> entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointProducerBuilder entities(String entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option is a: <code>java.lang.Class[]</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointProducerBuilder extraJaxbClasses(
                Class[] extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option will be converted to a <code>java.lang.Class[]</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointProducerBuilder extraJaxbClasses(
                String extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointProducerBuilder parameters(
                Map<String, Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointProducerBuilder parameters(String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the JBPM component.
     */
    public interface JBPMEndpointBuilder
            extends
                JBPMEndpointConsumerBuilder,
                JBPMEndpointProducerBuilder {
        default AdvancedJBPMEndpointBuilder advanced() {
            return (AdvancedJBPMEndpointBuilder) this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder attachmentId(Long attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * attachId to use when retrieving attachments.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder attachmentId(String attachmentId) {
            doSetProperty("attachmentId", attachmentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder contentId(Long contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * contentId to use when retrieving attachments.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder contentId(String contentId) {
            doSetProperty("contentId", contentId);
            return this;
        }
        /**
         * The id of the deployment.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default JBPMEndpointBuilder deploymentId(String deploymentId) {
            doSetProperty("deploymentId", deploymentId);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder emitterSendItems(Boolean emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * Sets if event produced by emitter should be sent as single items or
         * complete collection.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder emitterSendItems(String emitterSendItems) {
            doSetProperty("emitterSendItems", emitterSendItems);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder event(Object event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the data associated with this event when signalEvent operation is
         * performed.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder event(String event) {
            doSetProperty("event", event);
            return this;
        }
        /**
         * the type of event to use when signalEvent operation is performed.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder eventType(String eventType) {
            doSetProperty("eventType", eventType);
            return this;
        }
        /**
         * identifier the global identifier.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder maxNumber(Integer maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * the maximum number of rules that should be fired.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder maxNumber(String maxNumber) {
            doSetProperty("maxNumber", maxNumber);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder page(Integer page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page to use when retrieving user tasks.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder page(String page) {
            doSetProperty("page", page);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder pageSize(Integer pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * The page size to use when retrieving user tasks.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder pageSize(String pageSize) {
            doSetProperty("pageSize", pageSize);
            return this;
        }
        /**
         * the id of the process that should be acted upon.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder processId(String processId) {
            doSetProperty("processId", processId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder processInstanceId(Long processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * the id of the process instance.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder processInstanceId(String processInstanceId) {
            doSetProperty("processInstanceId", processInstanceId);
            return this;
        }
        /**
         * The targetUserId used when delegating a task.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder targetUserId(String targetUserId) {
            doSetProperty("targetUserId", targetUserId);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option is a: <code>org.kie.api.task.model.Task</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder task(Object task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * The task instance to use with task operations.
         * 
         * The option will be converted to a
         * <code>org.kie.api.task.model.Task</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder task(String task) {
            doSetProperty("task", task);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder taskId(Long taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * the id of the task.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder taskId(String taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder timeout(Integer timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * A timeout value.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * userId to use with task operations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder value(Object value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the value to assign to the global identifier.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder workItemId(Long workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * the id of the work item.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default JBPMEndpointBuilder workItemId(String workItemId) {
            doSetProperty("workItemId", workItemId);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: filter
         */
        default JBPMEndpointBuilder statuses(List<String> statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * The list of status to use when filtering tasks.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: filter
         */
        default JBPMEndpointBuilder statuses(String statuses) {
            doSetProperty("statuses", statuses);
            return this;
        }
        /**
         * Password for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default JBPMEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default JBPMEndpointBuilder userName(String userName) {
            doSetProperty("userName", userName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the JBPM component.
     */
    public interface AdvancedJBPMEndpointBuilder
            extends
                AdvancedJBPMEndpointConsumerBuilder,
                AdvancedJBPMEndpointProducerBuilder {
        default JBPMEndpointBuilder basic() {
            return (JBPMEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointBuilder entities(List<String> entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * The potentialOwners when nominateTask operation is performed.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointBuilder entities(String entities) {
            doSetProperty("entities", entities);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option is a: <code>java.lang.Class[]</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointBuilder extraJaxbClasses(
                Class[] extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * To load additional classes when working with XML.
         * 
         * The option will be converted to a <code>java.lang.Class[]</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointBuilder extraJaxbClasses(
                String extraJaxbClasses) {
            doSetProperty("extraJaxbClasses", extraJaxbClasses);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointBuilder parameters(
                Map<String, Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * the variables that should be set for various operations.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJBPMEndpointBuilder parameters(String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedJBPMEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface JBPMBuilders {
        /**
         * JBPM (camel-jbpm)
         * The jbpm component provides integration with jBPM (Business Process
         * Management).
         * 
         * Category: process
         * Since: 2.6
         * Maven coordinates: org.apache.camel:camel-jbpm
         * 
         * Syntax: <code>jbpm:connectionURL</code>
         * 
         * Path parameter: connectionURL (required)
         * The URL to the jBPM server.
         * 
         * Path parameter: eventListenerType
         * Sets the event listener type to attach to
         */
        default JBPMEndpointBuilder jbpm(String path) {
            return JBPMEndpointBuilderFactory.jbpm(path);
        }
    }
    /**
     * JBPM (camel-jbpm)
     * The jbpm component provides integration with jBPM (Business Process
     * Management).
     * 
     * Category: process
     * Since: 2.6
     * Maven coordinates: org.apache.camel:camel-jbpm
     * 
     * Syntax: <code>jbpm:connectionURL</code>
     * 
     * Path parameter: connectionURL (required)
     * The URL to the jBPM server.
     * 
     * Path parameter: eventListenerType
     * Sets the event listener type to attach to
     */
    static JBPMEndpointBuilder jbpm(String path) {
        class JBPMEndpointBuilderImpl extends AbstractEndpointBuilder implements JBPMEndpointBuilder, AdvancedJBPMEndpointBuilder {
            public JBPMEndpointBuilderImpl(String path) {
                super("jbpm", path);
            }
        }
        return new JBPMEndpointBuilderImpl(path);
    }
}