/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The github component is used for integrating Camel with github. The endpoint
 * encapsulates portions of the GitHub API, relying on the
 * org.eclipse.egit.github.core Java SDK. Available endpoint URIs include:
 * CONSUMERS github://pullRequest (new pull requests)
 * github://pullRequestComment (new pull request comments)
 * github://commit/branch (new commits) github://tag (new tags) PRODUCERS
 * github://pullRequestComment (create a new pull request comment; see
 * PullRequestCommentProducer for header requirements) The endpoints will
 * respond with org.eclipse.egit.github.core-provided POJOs (PullRequest,
 * CommitComment, RepositoryTag, RepositoryCommit, etc.) Note: Rather than
 * webhooks, this endpoint relies on simple polling. Reasons include: -
 * concerned about reliability/stability if this somehow relied on an exposed,
 * embedded server (Jetty) - the types of payloads we're polling aren't
 * typically large (plus, paging is available in the API) - need to support apps
 * running somewhere not publicly accessible where a webhook would fail
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface GitHubEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the GitHub component.
     */
    public interface GitHubEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedGitHubEndpointConsumerBuilder advanced() {
            return (AdvancedGitHubEndpointConsumerBuilder) this;
        }
        /**
         * GitHub OAuth token, required unless username & password are provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default GitHubEndpointConsumerBuilder oauthToken(String oauthToken) {
            doSetProperty("oauthToken", oauthToken);
            return this;
        }
        /**
         * GitHub password, required unless oauthToken is provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default GitHubEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * GitHub repository name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default GitHubEndpointConsumerBuilder repoName(String repoName) {
            doSetProperty("repoName", repoName);
            return this;
        }
        /**
         * GitHub repository owner (organization).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default GitHubEndpointConsumerBuilder repoOwner(String repoOwner) {
            doSetProperty("repoOwner", repoOwner);
            return this;
        }
        /**
         * GitHub username, required unless oauthToken is provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default GitHubEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default GitHubEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default GitHubEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the GitHub component.
     */
    public interface AdvancedGitHubEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default GitHubEndpointConsumerBuilder basic() {
            return (GitHubEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedGitHubEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedGitHubEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedGitHubEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedGitHubEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the GitHub component.
     */
    public interface GitHubEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedGitHubEndpointProducerBuilder advanced() {
            return (AdvancedGitHubEndpointProducerBuilder) this;
        }
        /**
         * GitHub OAuth token, required unless username & password are provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default GitHubEndpointProducerBuilder oauthToken(String oauthToken) {
            doSetProperty("oauthToken", oauthToken);
            return this;
        }
        /**
         * GitHub password, required unless oauthToken is provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default GitHubEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * GitHub repository name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default GitHubEndpointProducerBuilder repoName(String repoName) {
            doSetProperty("repoName", repoName);
            return this;
        }
        /**
         * GitHub repository owner (organization).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default GitHubEndpointProducerBuilder repoOwner(String repoOwner) {
            doSetProperty("repoOwner", repoOwner);
            return this;
        }
        /**
         * GitHub username, required unless oauthToken is provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default GitHubEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * To use the given encoding when getting a git commit file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default GitHubEndpointProducerBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default GitHubEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default GitHubEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To set git commit status state.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default GitHubEndpointProducerBuilder state(String state) {
            doSetProperty("state", state);
            return this;
        }
        /**
         * To set git commit status target url.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default GitHubEndpointProducerBuilder targetUrl(String targetUrl) {
            doSetProperty("targetUrl", targetUrl);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the GitHub component.
     */
    public interface AdvancedGitHubEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default GitHubEndpointProducerBuilder basic() {
            return (GitHubEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the GitHub component.
     */
    public interface GitHubEndpointBuilder
            extends
                GitHubEndpointConsumerBuilder,
                GitHubEndpointProducerBuilder {
        default AdvancedGitHubEndpointBuilder advanced() {
            return (AdvancedGitHubEndpointBuilder) this;
        }
        /**
         * GitHub OAuth token, required unless username & password are provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default GitHubEndpointBuilder oauthToken(String oauthToken) {
            doSetProperty("oauthToken", oauthToken);
            return this;
        }
        /**
         * GitHub password, required unless oauthToken is provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default GitHubEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * GitHub repository name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default GitHubEndpointBuilder repoName(String repoName) {
            doSetProperty("repoName", repoName);
            return this;
        }
        /**
         * GitHub repository owner (organization).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default GitHubEndpointBuilder repoOwner(String repoOwner) {
            doSetProperty("repoOwner", repoOwner);
            return this;
        }
        /**
         * GitHub username, required unless oauthToken is provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default GitHubEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the GitHub component.
     */
    public interface AdvancedGitHubEndpointBuilder
            extends
                AdvancedGitHubEndpointConsumerBuilder,
                AdvancedGitHubEndpointProducerBuilder {
        default GitHubEndpointBuilder basic() {
            return (GitHubEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedGitHubEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface GitHubBuilders {
        /**
         * GitHub (camel-github)
         * The github component is used for integrating Camel with github. The
         * endpoint encapsulates portions of the GitHub API, relying on the
         * org.eclipse.egit.github.core Java SDK. Available endpoint URIs
         * include: CONSUMERS github://pullRequest (new pull requests)
         * github://pullRequestComment (new pull request comments)
         * github://commit/branch (new commits) github://tag (new tags)
         * PRODUCERS github://pullRequestComment (create a new pull request
         * comment; see PullRequestCommentProducer for header requirements) The
         * endpoints will respond with org.eclipse.egit.github.core-provided
         * POJOs (PullRequest, CommitComment, RepositoryTag, RepositoryCommit,
         * etc.) Note: Rather than webhooks, this endpoint relies on simple
         * polling. Reasons include: - concerned about reliability/stability if
         * this somehow relied on an exposed, embedded server (Jetty) - the
         * types of payloads we're polling aren't typically large (plus, paging
         * is available in the API) - need to support apps running somewhere not
         * publicly accessible where a webhook would fail
         * 
         * Category: api,file
         * Since: 2.15
         * Maven coordinates: org.apache.camel:camel-github
         * 
         * Syntax: <code>github:type/branchName</code>
         * 
         * Path parameter: type (required)
         * What git operation to execute
         * The value can be one of: CLOSEPULLREQUEST, PULLREQUESTCOMMENT,
         * COMMIT, PULLREQUEST, TAG, PULLREQUESTSTATE, PULLREQUESTFILES,
         * GETCOMMITFILE, CREATEISSUE
         * 
         * Path parameter: branchName
         * Name of branch
         */
        default GitHubEndpointBuilder github(String path) {
            return GitHubEndpointBuilderFactory.github(path);
        }
    }
    /**
     * GitHub (camel-github)
     * The github component is used for integrating Camel with github. The
     * endpoint encapsulates portions of the GitHub API, relying on the
     * org.eclipse.egit.github.core Java SDK. Available endpoint URIs include:
     * CONSUMERS github://pullRequest (new pull requests)
     * github://pullRequestComment (new pull request comments)
     * github://commit/branch (new commits) github://tag (new tags) PRODUCERS
     * github://pullRequestComment (create a new pull request comment; see
     * PullRequestCommentProducer for header requirements) The endpoints will
     * respond with org.eclipse.egit.github.core-provided POJOs (PullRequest,
     * CommitComment, RepositoryTag, RepositoryCommit, etc.) Note: Rather than
     * webhooks, this endpoint relies on simple polling. Reasons include: -
     * concerned about reliability/stability if this somehow relied on an
     * exposed, embedded server (Jetty) - the types of payloads we're polling
     * aren't typically large (plus, paging is available in the API) - need to
     * support apps running somewhere not publicly accessible where a webhook
     * would fail
     * 
     * Category: api,file
     * Since: 2.15
     * Maven coordinates: org.apache.camel:camel-github
     * 
     * Syntax: <code>github:type/branchName</code>
     * 
     * Path parameter: type (required)
     * What git operation to execute
     * The value can be one of: CLOSEPULLREQUEST, PULLREQUESTCOMMENT, COMMIT,
     * PULLREQUEST, TAG, PULLREQUESTSTATE, PULLREQUESTFILES, GETCOMMITFILE,
     * CREATEISSUE
     * 
     * Path parameter: branchName
     * Name of branch
     */
    static GitHubEndpointBuilder github(String path) {
        class GitHubEndpointBuilderImpl extends AbstractEndpointBuilder implements GitHubEndpointBuilder, AdvancedGitHubEndpointBuilder {
            public GitHubEndpointBuilderImpl(String path) {
                super("github", path);
            }
        }
        return new GitHubEndpointBuilderImpl(path);
    }
}