/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.netty.NettyComponent;

/**
 * Socket level networking using TCP or UDP with the Netty 4.x library.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface NettyComponentBuilderFactory {

    /**
     * Netty (camel-netty)
     * Socket level networking using TCP or UDP with the Netty 4.x library.
     * 
     * Category: networking,tcp,udp
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty
     */
    static NettyComponentBuilder netty() {
        return new NettyComponentBuilderImpl();
    }

    /**
     * Builder for the Netty component.
     */
    interface NettyComponentBuilder extends ComponentBuilder<NettyComponent> {
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default NettyComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To use the given EventExecutorGroup.
         * 
         * The option is a:
         * <code>io.netty.util.concurrent.EventExecutorGroup</code> type.
         * 
         * Group: consumer (advanced)
         */
        default NettyComponentBuilder executorService(
                io.netty.util.concurrent.EventExecutorGroup executorService) {
            doSetProperty("executorService", executorService);
            return this;
        }
        /**
         * Sets a maximum thread pool size for the netty consumer ordered thread
         * pool. The default size is 2 x cpu_core plus 1. Setting this value to
         * eg 10 will then use 10 threads unless 2 x cpu_core plus 1 is a higher
         * value, which then will override and be used. For example if there are
         * 8 cores, then the consumer thread pool will be 17. This thread pool
         * is used to route messages received from Netty by Camel. We use a
         * separate thread pool to ensure ordering of messages and also in case
         * some messages will block, then nettys worker threads (event loop)
         * wont be affected.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer (advanced)
         */
        default NettyComponentBuilder maximumPoolSize(int maximumPoolSize) {
            doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default NettyComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the component should use basic property binding (Camel 2.x)
         * or the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default NettyComponentBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use the NettyConfiguration as configuration when creating
         * endpoints.
         * 
         * The option is a:
         * <code>org.apache.camel.component.netty.NettyConfiguration</code>
         * type.
         * 
         * Group: advanced
         */
        default NettyComponentBuilder configuration(
                org.apache.camel.component.netty.NettyConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default NettyComponentBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Enable usage of global SSL context parameters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default NettyComponentBuilder useGlobalSslContextParameters(
                boolean useGlobalSslContextParameters) {
            doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }

    class NettyComponentBuilderImpl
            extends
                AbstractComponentBuilder<NettyComponent>
            implements
                NettyComponentBuilder {
        @Override
        protected NettyComponent buildConcreteComponent() {
            return new NettyComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "bridgeErrorHandler": ((NettyComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "executorService": ((NettyComponent) component).setExecutorService((io.netty.util.concurrent.EventExecutorGroup) value); return true;
            case "maximumPoolSize": ((NettyComponent) component).setMaximumPoolSize((int) value); return true;
            case "lazyStartProducer": ((NettyComponent) component).setLazyStartProducer((boolean) value); return true;
            case "basicPropertyBinding": ((NettyComponent) component).setBasicPropertyBinding((boolean) value); return true;
            case "configuration": ((NettyComponent) component).setConfiguration((org.apache.camel.component.netty.NettyConfiguration) value); return true;
            case "sslContextParameters": ((NettyComponent) component).setSslContextParameters((org.apache.camel.support.jsse.SSLContextParameters) value); return true;
            case "useGlobalSslContextParameters": ((NettyComponent) component).setUseGlobalSslContextParameters((boolean) value); return true;
            default: return false;
            }
        }
    }
}