/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamComponent;

/**
 * The google-calendar-stream component provides access to Google Calendar in a
 * streaming mode.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface GoogleCalendarStreamComponentBuilderFactory {

    /**
     * Google Calendar Stream (camel-google-calendar)
     * The google-calendar-stream component provides access to Google Calendar
     * in a streaming mode.
     * 
     * Category: api,cloud
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-calendar
     */
    static GoogleCalendarStreamComponentBuilder googleCalendarStream() {
        return new GoogleCalendarStreamComponentBuilderImpl();
    }

    /**
     * Builder for the Google Calendar Stream component.
     */
    interface GoogleCalendarStreamComponentBuilder
            extends
                ComponentBuilder<GoogleCalendarStreamComponent> {
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default GoogleCalendarStreamComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Whether the component should use basic property binding (Camel 2.x)
         * or the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default GoogleCalendarStreamComponentBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The client Factory.
         * 
         * The option is a:
         * <code>org.apache.camel.component.google.calendar.GoogleCalendarClientFactory</code> type.
         * 
         * Group: advanced
         */
        default GoogleCalendarStreamComponentBuilder clientFactory(
                org.apache.camel.component.google.calendar.GoogleCalendarClientFactory clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * The configuration.
         * 
         * The option is a:
         * <code>org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration</code> type.
         * 
         * Group: advanced
         */
        default GoogleCalendarStreamComponentBuilder configuration(
                org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    }

    class GoogleCalendarStreamComponentBuilderImpl
            extends
                AbstractComponentBuilder<GoogleCalendarStreamComponent>
            implements
                GoogleCalendarStreamComponentBuilder {
        @Override
        protected GoogleCalendarStreamComponent buildConcreteComponent() {
            return new GoogleCalendarStreamComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "bridgeErrorHandler": ((GoogleCalendarStreamComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "basicPropertyBinding": ((GoogleCalendarStreamComponent) component).setBasicPropertyBinding((boolean) value); return true;
            case "clientFactory": ((GoogleCalendarStreamComponent) component).setClientFactory((org.apache.camel.component.google.calendar.GoogleCalendarClientFactory) value); return true;
            case "configuration": ((GoogleCalendarStreamComponent) component).setConfiguration((org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration) value); return true;
            default: return false;
            }
        }
    }
}