/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ehcache.EhcacheComponent;

/**
 * The ehcache component enables you to perform caching operations using Ehcache
 * as cache implementation.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface EhcacheComponentBuilderFactory {

    /**
     * Ehcache (camel-ehcache)
     * The ehcache component enables you to perform caching operations using
     * Ehcache as cache implementation.
     * 
     * Category: cache,datagrid,clustering
     * Since: 2.18
     * Maven coordinates: org.apache.camel:camel-ehcache
     */
    static EhcacheComponentBuilder ehcache() {
        return new EhcacheComponentBuilderImpl();
    }

    /**
     * Builder for the Ehcache component.
     */
    interface EhcacheComponentBuilder
            extends
                ComponentBuilder<EhcacheComponent> {
        /**
         * The default cache configuration to be used to create caches.
         * 
         * The option is a: <code>org.ehcache.config.CacheConfiguration</code>
         * type.
         * 
         * Group: common
         */
        default EhcacheComponentBuilder cacheConfiguration(
                org.ehcache.config.CacheConfiguration cacheConfiguration) {
            doSetProperty("cacheConfiguration", cacheConfiguration);
            return this;
        }
        /**
         * URI pointing to the Ehcache XML configuration file's location.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default EhcacheComponentBuilder cacheConfigurationUri(
                java.lang.String cacheConfigurationUri) {
            doSetProperty("cacheConfigurationUri", cacheConfigurationUri);
            return this;
        }
        /**
         * The cache manager.
         * 
         * The option is a: <code>org.ehcache.CacheManager</code> type.
         * 
         * Group: common
         */
        default EhcacheComponentBuilder cacheManager(
                org.ehcache.CacheManager cacheManager) {
            doSetProperty("cacheManager", cacheManager);
            return this;
        }
        /**
         * The cache manager configuration.
         * 
         * The option is a: <code>org.ehcache.config.Configuration</code> type.
         * 
         * Group: common
         */
        default EhcacheComponentBuilder cacheManagerConfiguration(
                org.ehcache.config.Configuration cacheManagerConfiguration) {
            doSetProperty("cacheManagerConfiguration", cacheManagerConfiguration);
            return this;
        }
        /**
         * A map of caches configurations to be used to create caches.
         * 
         * The option is a: <code>java.util.Map<java.lang.String,
         * org.ehcache.config.CacheConfiguration></code> type.
         * 
         * Group: common
         */
        default EhcacheComponentBuilder cachesConfigurations(
                java.util.Map<java.lang.String, org.ehcache.config.CacheConfiguration> cachesConfigurations) {
            doSetProperty("cachesConfigurations", cachesConfigurations);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default EhcacheComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default EhcacheComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the component should use basic property binding (Camel 2.x)
         * or the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default EhcacheComponentBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets the global component configuration.
         * 
         * The option is a:
         * <code>org.apache.camel.component.ehcache.EhcacheConfiguration</code>
         * type.
         * 
         * Group: advanced
         */
        default EhcacheComponentBuilder configuration(
                org.apache.camel.component.ehcache.EhcacheConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    }

    class EhcacheComponentBuilderImpl
            extends
                AbstractComponentBuilder<EhcacheComponent>
            implements
                EhcacheComponentBuilder {
        @Override
        protected EhcacheComponent buildConcreteComponent() {
            return new EhcacheComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "cacheConfiguration": ((EhcacheComponent) component).setCacheConfiguration((org.ehcache.config.CacheConfiguration) value); return true;
            case "cacheConfigurationUri": ((EhcacheComponent) component).setCacheConfigurationUri((java.lang.String) value); return true;
            case "cacheManager": ((EhcacheComponent) component).setCacheManager((org.ehcache.CacheManager) value); return true;
            case "cacheManagerConfiguration": ((EhcacheComponent) component).setCacheManagerConfiguration((org.ehcache.config.Configuration) value); return true;
            case "cachesConfigurations": ((EhcacheComponent) component).setCachesConfigurations((java.util.Map<java.lang.String, org.ehcache.config.CacheConfiguration>) value); return true;
            case "bridgeErrorHandler": ((EhcacheComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "lazyStartProducer": ((EhcacheComponent) component).setLazyStartProducer((boolean) value); return true;
            case "basicPropertyBinding": ((EhcacheComponent) component).setBasicPropertyBinding((boolean) value); return true;
            case "configuration": ((EhcacheComponent) component).setConfiguration((org.apache.camel.component.ehcache.EhcacheConfiguration) value); return true;
            default: return false;
            }
        }
    }
}