/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.threads.metadata;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 *
 */
@XmlType(name = "thread-pool-executor")
public final class ThreadPoolExecutorMetaData {
    private String name;
    private String threadFactory;
    private PoolSizeMetaData corePoolSize;
    private PoolSizeMetaData maxPoolSize;
    private TimeMetaData keepAliveTime;
    private RejectPolicyMetaData rejectPolicyMetaData;
    private Integer queueLength;
    private boolean allowCoreTimeout;

    public String getName() {
        return name;
    }

    @XmlAttribute(required = true)
    public void setName(final String name) {
        this.name = name;
    }

    public String getThreadFactory() {
        return threadFactory;
    }

    @XmlAttribute(name = "thread-factory", required = true)
    public void setThreadFactory(final String threadFactory) {
        this.threadFactory = threadFactory;
    }

    public PoolSizeMetaData getCorePoolSize() {
        return corePoolSize;
    }

    @XmlElement(name = "core-pool-size")
    public void setCorePoolSize(final PoolSizeMetaData corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public PoolSizeMetaData getMaxPoolSize() {
        return maxPoolSize;
    }

    @XmlElement(name = "max-pool-size")
    public void setMaxPoolSize(final PoolSizeMetaData maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public TimeMetaData getKeepAliveTime() {
        return keepAliveTime;
    }

    @XmlElement(name = "keepalive-time")
    public void setKeepAliveTime(final TimeMetaData keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public RejectPolicyMetaData getRejectPolicyMetaData() {
        return rejectPolicyMetaData;
    }

    @XmlElement(name = "reject-policy")
    public void setRejectPolicyMetaData(final RejectPolicyMetaData rejectPolicyMetaData) {
        this.rejectPolicyMetaData = rejectPolicyMetaData;
    }

    public Integer getQueueLength() {
        return queueLength;
    }

    @XmlAttribute(name = "queue-length")
    public void setQueueLength(final Integer queueLength) {
        this.queueLength = queueLength;
    }

    public boolean isAllowCoreTimeout() {
        return allowCoreTimeout;
    }

    @XmlAttribute(name = "allow-core-timeout")
    public void setAllowCoreTimeout(final boolean allowCoreTimeout) {
        this.allowCoreTimeout = allowCoreTimeout;
    }
}
