/**
 * 
 */
package org.jboss.test.util.test.jbpapp9887;

import org.jboss.logging.Logger;

/**
 * Class which has some static method calls which will return information on the current JVM version that is running based off System properties.
 * 
 * @author navssurtani
 *
 */
public class JavaVersionChecker {
	
	private static final Logger log = Logger.getLogger(JavaVersionChecker.class);
	
	/**
	 * Method to find out whether or not the jvm or jdk used is from IBM. The system property checked is something that should be null if the sun
	 * jdk or openjdk is used.
	 * 
	 * @return whether or not the jvm used is from IBM.
	 */
	public static boolean isIBM(){
		log.debug("Java version checker called. The system property that you are looking for, java.vm.name is: " + System.getProperty("java.vm.name"));		
		return System.getProperty("java.vm.name").toString().contains("IBM");
	}
	
	/**
	 * Find out the 'minor version' of the jvm being used. For example, java 6 has version 1.6.x etc.
	 * 
	 * @return the version of java being used.
	 */
	public static int minorVersion(){
		String version = System.getProperty("java.version");
		String minorVersion = version.substring(2, 3);
		log.debug("The minor version of java being used is: " + minorVersion);
		return Integer.parseInt(minorVersion);
	}
}
