/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.jms;

import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import org.apache.log.ErrorHandler;
import org.apache.log.output.jms.AbstractJMSTarget;
import org.apache.log.output.jms.MessageBuilder;

public class JMSQueueTarget
extends AbstractJMSTarget {
    private QueueConnectionFactory m_factory;
    private Queue m_queue;
    private QueueSession m_session;
    private QueueSender m_sender;
    private QueueConnection m_connection;

    public JMSQueueTarget(MessageBuilder builder, QueueConnectionFactory factory, Queue queue) {
        super(builder);
        this.m_factory = factory;
        this.m_queue = queue;
        this.open();
    }

    public JMSQueueTarget(MessageBuilder builder, QueueConnectionFactory factory, Queue queue, ErrorHandler handler) {
        super(builder, handler);
        this.m_factory = factory;
        this.m_queue = queue;
        this.open();
    }

    @Override
    protected void send(Message message) {
        try {
            this.m_sender.send(message);
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error publishing message", e, null);
        }
    }

    @Override
    protected Session getSession() {
        return this.m_session;
    }

    @Override
    protected synchronized void openConnection() {
        try {
            this.m_connection = this.m_factory.createQueueConnection();
            this.m_connection.start();
            this.m_session = this.m_connection.createQueueSession(false, 1);
            this.m_sender = this.m_session.createSender(this.m_queue);
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error starting connection", e, null);
        }
    }

    @Override
    protected synchronized void closeConnection() {
        try {
            if (null != this.m_sender) {
                this.m_sender.close();
            }
            if (null != this.m_session) {
                this.m_session.close();
            }
            if (null != this.m_connection) {
                this.m_connection.close();
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error closing connection", e, null);
        }
        this.m_sender = null;
        this.m_session = null;
        this.m_connection = null;
    }
}

