/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.web;

import org.apache.commons.logging.Log;
import xdoclet.TemplateSubTask;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.modules.web.WebTagsHandler;
import xdoclet.modules.web.XDocletModulesWebMessages;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XTag;

public class ServiceEndpointSubTask
extends TemplateSubTask {
    public static final String DEFAULT_SERVICE_ENDPOINT_CLASS_PATTERN = "{0}";
    public static final String SERVICE_ENDPOINT = "service-endpoint";
    public static final String WEB_SERVLET = "web.servlet";
    protected static final String DEFAULT_TEMPLATE_FILE = "resources/service-endpoint.xdt";
    protected String serviceEndpointClassPattern;

    public ServiceEndpointSubTask() {
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(this.getServiceEndpointClassPattern() + ".java");
    }

    public String getServiceEndpointClassPattern() {
        if (this.serviceEndpointClassPattern != null) {
            return this.serviceEndpointClassPattern;
        }
        return DEFAULT_SERVICE_ENDPOINT_CLASS_PATTERN;
    }

    public void setPattern(String newPattern) {
        this.serviceEndpointClassPattern = newPattern;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getServiceEndpointClassPattern() == null || this.getServiceEndpointClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString(XDocletMessages.class, (String)"PARAMETER_MISSING_OR_EMPTY", (String[])new String[]{"pattern"}));
        }
        if (this.getServiceEndpointClassPattern().indexOf(DEFAULT_SERVICE_ENDPOINT_CLASS_PATTERN) == -1) {
            throw new XDocletException(Translator.getString(XDocletModulesWebMessages.class, (String)"PATTERN_HAS_NO_PLACEHOLDER"));
        }
    }

    protected String getGeneratedFileName(XClass clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor((String)WebTagsHandler.serviceEndpoint(clazz)) + ".java";
    }

    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException {
        if (!super.matchesGenerationRules(clazz)) {
            return false;
        }
        XTag interfaceTag = clazz.getDoc().getTag(WEB_SERVLET);
        Log log = LogUtil.getLog(ServiceEndpointSubTask.class, (String)"matchesGenerationRules");
        if (interfaceTag == null) {
            log.debug((Object)("Reject file " + clazz.getQualifiedName() + " because of not being a servlet"));
            return false;
        }
        return true;
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString(XDocletModulesWebMessages.class, (String)"GENERATING_SERVICE_ENDPOINT_FOR", (String[])new String[]{this.getCurrentClass().getQualifiedName()}));
    }
}

