/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class DoctypeReader
extends Reader {
    private static final String DOCTYPE_OPEN_DECL = "<!";
    private static final int DECL_LENGTH = "<!".length();
    private static final String DOCTYPE_CLOSE_DECL = ">";
    private static final String DOCTYPE = "DOCTYPE ";
    private static final String SYSTEM = " SYSTEM \"";
    private final Reader originalSource;
    private final StringBuffer sourceBuffer = new StringBuffer(1024);
    private final String doctypeName;
    private final String systemId;
    private Reader replacementReader;

    public DoctypeReader(Reader originalSource, String doctypeName, String systemID) {
        this.originalSource = originalSource;
        this.doctypeName = doctypeName;
        this.systemId = systemID;
    }

    protected String getContent() throws IOException {
        return this.getContent(this.originalSource).toString();
    }

    private StringBuffer getContent(Reader originalSource) throws IOException {
        if (this.sourceBuffer.length() == 0) {
            String source;
            BufferedReader bufferedReader = originalSource instanceof BufferedReader ? (BufferedReader)originalSource : new BufferedReader(originalSource);
            String newline = System.getProperty("line.separator");
            boolean atFirstLine = true;
            while ((source = bufferedReader.readLine()) != null) {
                if (atFirstLine) {
                    atFirstLine = false;
                } else {
                    this.sourceBuffer.append(newline);
                }
                this.sourceBuffer.append(source);
            }
            bufferedReader.close();
        }
        return this.sourceBuffer;
    }

    private int findStartDoctype(StringBuffer withinContent) {
        int startAt = -1;
        boolean canInsert = true;
        int i = 0;
        while (startAt == -1) {
            char curChar = withinContent.charAt(i);
            if (curChar == '<') {
                switch (withinContent.charAt(i + 1)) {
                    case '!': 
                    case '-': 
                    case '?': {
                        canInsert = false;
                        break;
                    }
                    default: {
                        startAt = i;
                        break;
                    }
                }
            } else if (curChar == '>') {
                canInsert = true;
            } else if (canInsert) {
                startAt = i;
            }
            ++i;
        }
        return startAt;
    }

    public String replaceDoctype(StringBuffer withinContent, String doctypeName, String systemId) {
        String content = withinContent.toString();
        int startDoctype = content.indexOf(DOCTYPE);
        boolean noCurrentDoctype = false;
        if (startDoctype == -1) {
            startDoctype = this.findStartDoctype(withinContent);
            noCurrentDoctype = true;
        }
        int endDoctype = startDoctype + DOCTYPE.length();
        if (noCurrentDoctype) {
            withinContent.insert(startDoctype, DOCTYPE_OPEN_DECL);
            withinContent.insert(startDoctype + DECL_LENGTH, DOCTYPE);
            endDoctype += DECL_LENGTH;
        } else {
            int startInternalDecl = content.indexOf(91, endDoctype);
            if (startInternalDecl > 0) {
                int endInternalDecl = content.indexOf(93, startInternalDecl);
                withinContent.delete(endDoctype, endInternalDecl + 1);
            } else {
                int endDoctypeTag = content.indexOf(62, endDoctype);
                withinContent.delete(endDoctype, endDoctypeTag);
            }
        }
        int atPos = endDoctype;
        withinContent.insert(atPos, doctypeName);
        withinContent.insert(atPos += doctypeName.length(), SYSTEM);
        withinContent.insert(atPos += SYSTEM.length(), systemId);
        withinContent.insert(atPos += systemId.length(), '\"');
        if (noCurrentDoctype) {
            withinContent.insert(++atPos, DOCTYPE_CLOSE_DECL);
        }
        return withinContent.toString();
    }

    private Reader getReplacementReader() throws IOException {
        StringBuffer originalContent = this.getContent(this.originalSource);
        String replacedContent = this.replaceDoctype(originalContent, this.doctypeName, this.systemId);
        return new StringReader(replacedContent);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.replacementReader == null) {
            this.replacementReader = this.getReplacementReader();
        }
        return this.replacementReader.read(cbuf, off, len);
    }

    public void close() throws IOException {
        this.replacementReader.close();
    }
}

