/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.common.proxy.plugins.async;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.common.proxy.plugins.async.AsyncProvider;
import org.jboss.ejb3.common.proxy.plugins.async.SecurityActions;
import org.jboss.security.SecurityContext;

public class AsyncInterceptor
implements Interceptor,
AsyncProvider {
    private static final ThreadLocal<Future<Object>> LAST_INVOKED_RESULT = new ThreadLocal();
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private static final Method METHOD_GET_FUTURE_RESULT;

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        assert (invocation instanceof MethodInvocation) : this.getName() + " is applicable only for " + MethodInvocation.class.getSimpleName() + ", instead got: " + invocation.getClass().getName();
        MethodInvocation methodInvocation = (MethodInvocation)invocation;
        Method method = methodInvocation.getActualMethod();
        Object[] args = methodInvocation.getArguments();
        if (this.isGetFutureResultInvocation(method)) {
            return this.getFutureResult();
        }
        Object delegate = invocation.getTargetObject();
        SecurityContext sc = SecurityActions.getSecurityContext();
        AsyncTask asyncInvocation = new AsyncTask(delegate, method, args, sc);
        Future<Object> asyncResult = EXECUTOR.submit(asyncInvocation);
        LAST_INVOKED_RESULT.set(asyncResult);
        return DummyReturnValues.getDummyReturnValue(method.getReturnType());
    }

    @Override
    public Future<?> getFutureResult() {
        Future<Object> result = LAST_INVOKED_RESULT.get();
        assert (result != null) : "No last invoked result is available";
        return result;
    }

    private boolean isGetFutureResultInvocation(Method method) {
        return method.equals(METHOD_GET_FUTURE_RESULT);
    }

    static {
        try {
            METHOD_GET_FUTURE_RESULT = AsyncProvider.class.getMethod("getFutureResult", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class DummyReturnValues {
        private DummyReturnValues() {
        }

        public static Object getDummyReturnValue(Class<?> expectedType) {
            if (!expectedType.isPrimitive()) {
                return null;
            }
            if (expectedType.equals(Integer.TYPE)) {
                return 0;
            }
            if (expectedType.equals(Long.TYPE)) {
                return 0L;
            }
            if (expectedType.equals(Short.TYPE)) {
                return 0;
            }
            if (expectedType.equals(Byte.TYPE)) {
                return 0;
            }
            if (expectedType.equals(Double.TYPE)) {
                return 0.0;
            }
            if (expectedType.equals(Float.TYPE)) {
                return 0.0;
            }
            if (expectedType.equals(Boolean.TYPE)) {
                return false;
            }
            if (expectedType.equals(Character.TYPE)) {
                return 0;
            }
            if (expectedType.equals(Void.TYPE)) {
                return null;
            }
            throw new RuntimeException("Did not return proper dummy value for expected type: " + expectedType);
        }
    }

    private static class AsyncTask
    implements Callable<Object> {
        private Object proxy;
        private Method method;
        private Object[] args;
        private SecurityContext sc;

        public AsyncTask(Object proxy, Method method, Object[] args, SecurityContext sc) {
            this.proxy = proxy;
            this.method = method;
            this.args = args;
            this.sc = sc;
        }

        @Override
        public Object call() throws Exception {
            SecurityContext prevSC = null;
            try {
                if (this.sc != null) {
                    prevSC = SecurityActions.getSecurityContext();
                    SecurityActions.setSecurityContext(this.sc);
                }
                Object object = this.method.invoke(this.proxy, this.args);
                return object;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw e;
            }
            catch (Throwable t) {
                throw new Exception("Exception encountered in Asynchronous Invocation", t);
            }
            finally {
                if (this.sc != null) {
                    SecurityActions.setSecurityContext(prevSC);
                }
            }
        }
    }
}

