/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.ChildAndParentNode;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.EntityImpl;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EntityReferenceImpl
extends ChildAndParentNode
implements EntityReference {
    static final long serialVersionUID = -7381452955687102062L;
    protected String name;

    public EntityReferenceImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl);
        this.name = string;
        this.isReadOnly(true);
    }

    public short getNodeType() {
        return 5;
    }

    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public NodeList getChildNodes() {
        this.synchronize();
        return super.getChildNodes();
    }

    public Node getFirstChild() {
        this.synchronize();
        return super.getFirstChild();
    }

    public Node getLastChild() {
        this.synchronize();
        return super.getLastChild();
    }

    public int getLength() {
        this.synchronize();
        return super.getLength();
    }

    public boolean hasChildNodes() {
        this.synchronize();
        return super.hasChildNodes();
    }

    public Node item(int n) {
        this.synchronize();
        return super.item(n);
    }

    protected void synchronize() {
        NamedNodeMap namedNodeMap;
        if (this.firstChild != null) {
            return;
        }
        DocumentType documentType = this.getOwnerDocument().getDoctype();
        if (null != documentType && null != (namedNodeMap = documentType.getEntities())) {
            EntityImpl entityImpl = (EntityImpl)namedNodeMap.getNamedItem(this.getNodeName());
            if (entityImpl == null) {
                return;
            }
            this.isReadOnly(false);
            Node node = entityImpl.getFirstChild();
            while (node != null) {
                Node node2 = node.cloneNode(true);
                this.insertBefore(node2, null);
                node = node.getNextSibling();
            }
            this.setReadOnly(true, true);
        }
    }
}

