/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.DynamicQuery;

class FindPublisherByNameQuery {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$FindPublisherByNameQuery == null ? (class$org$apache$juddi$datastore$jdbc$FindPublisherByNameQuery = FindPublisherByNameQuery.class$("org.apache.juddi.datastore.jdbc.FindPublisherByNameQuery")) : class$org$apache$juddi$datastore$jdbc$FindPublisherByNameQuery));
    static String selectSQL;
    static String tablePrefix;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$FindPublisherByNameQuery;

    FindPublisherByNameQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String name, Vector idsIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        if (idsIn != null && idsIn.size() == 0) {
            return idsIn;
        }
        Vector<String> idsOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindPublisherByNameQuery.appendWhere(sql, name, qualifiers);
        FindPublisherByNameQuery.appendIn(sql, name, idsIn);
        FindPublisherByNameQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                idsOut.addElement(resultSet.getString(1));
            }
            Vector<String> vector = idsOut;
            return vector;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find Publisher ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find Publisher Statement: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void appendWhere(DynamicQuery sql, String name, FindQualifiers qualifiers) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (qualifiers != null && qualifiers.exactNameMatch) {
            sql.append("WHERE P.PUBLISHER_NAME = ? ");
            sql.addValue(name);
        } else {
            sql.append("WHERE P.PUBLISHER_NAME LIKE ? ");
            sql.addValue(name + "%");
        }
    }

    private static void appendIn(DynamicQuery sql, String name, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        if (name == null || name.length() == 0) {
            sql.append("WHERE P.PUBLISHER_ID IN (");
        } else {
            sql.append("AND P.PUBLISHER_ID IN (");
        }
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null || qualifiers.sortByNameDesc || !qualifiers.sortByNameAsc && !qualifiers.sortByNameDesc) {
            sql.append("P.PUBLISHER_NAME DESC");
        } else if (qualifiers.sortByNameAsc) {
            sql.append("P.PUBLISHER_NAME ASC");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tablePrefix = Config.getStringProperty("juddi.tablePrefix", "");
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT P.PUBLISHER_ID,P.PUBLISHER_NAME ");
        sql.append("FROM ").append(tablePrefix).append("PUBLISHER P ");
        selectSQL = sql.toString();
    }
}

