/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jms.integration.support.ejb20;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;

public class UserTransactionTestMessageDriven
implements MessageDrivenBean,
MessageListener {
    private static Logger log = Logger.getLogger((Class)UserTransactionTestMessageDriven.class);
    static String CONNECTION_FACTORY = "java:comp/env/connectionFactory";
    MessageDrivenContext messageDrivenContext;
    Context ctx;
    ConnectionFactory cf;
    UserTransaction userTransaction;

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) throws EJBException {
        this.messageDrivenContext = messageDrivenContext;
    }

    public void ejbCreate() throws EJBException {
        try {
            this.ctx = new InitialContext();
            this.cf = (ConnectionFactory)this.ctx.lookup(CONNECTION_FACTORY);
            this.userTransaction = (UserTransaction)this.ctx.lookup("UserTransaction");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public void ejbRemove() throws EJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        TextMessage txtMessage = null;
        try {
            Connection conn = this.cf.createConnection();
            conn.start();
            this.userTransaction.begin();
            if (message instanceof TextMessage) {
                txtMessage = (TextMessage)message;
                System.out.println("Received message " + txtMessage.getText());
            } else {
                System.out.println("Received message " + message);
            }
            Destination replyTo = message.getJMSReplyTo();
            Session session = null;
            try {
                session = conn.createSession(true, 0);
                MessageProducer producer = session.createProducer(replyTo);
                TextMessage reply = null;
                reply = txtMessage != null ? session.createTextMessage("reply to message " + txtMessage.getText()) : session.createTextMessage("reply to message " + message);
                producer.send((Message)reply);
                this.userTransaction.commit();
                boolean commit = message.getBooleanProperty("commit");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }
}

