/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.sql.ResultSet;
import org.hibernate.engine.jdbc.ColumnNameCache;
import org.hibernate.engine.jdbc.ContextualLobCreator;
import org.hibernate.engine.jdbc.JdbcSupport;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;
import org.hibernate.engine.jdbc.ResultSetWrapperProxy;

public class JdbcSupportImpl
implements JdbcSupport {
    private final boolean useContextualLobCreation;

    public JdbcSupportImpl(boolean useContextualLobCreation) {
        this.useContextualLobCreation = useContextualLobCreation;
    }

    @Override
    public LobCreator getLobCreator() {
        return NonContextualLobCreator.INSTANCE;
    }

    @Override
    public LobCreator getLobCreator(LobCreationContext lobCreationContext) {
        if (this.useContextualLobCreation) {
            return new ContextualLobCreator(lobCreationContext);
        }
        return NonContextualLobCreator.INSTANCE;
    }

    @Override
    public ResultSet wrap(ResultSet resultSet, ColumnNameCache columnNameCache) {
        return ResultSetWrapperProxy.generateProxy(resultSet, columnNameCache);
    }
}

