/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionAction;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostCollectionRemoveEvent;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PreCollectionRemoveEvent;
import org.hibernate.event.PreCollectionRemoveEventListener;
import org.hibernate.persister.collection.CollectionPersister;

public final class CollectionRemoveAction
extends CollectionAction {
    private boolean emptySnapshot;
    private final Object affectedOwner;

    public CollectionRemoveAction(PersistentCollection collection, CollectionPersister persister, Serializable id, boolean emptySnapshot, SessionImplementor session) throws CacheException {
        super(persister, collection, id, session);
        if (collection == null) {
            throw new AssertionFailure("collection == null");
        }
        this.emptySnapshot = emptySnapshot;
        this.affectedOwner = session.getPersistenceContext().getLoadedCollectionOwnerOrNull(collection);
    }

    public CollectionRemoveAction(Object affectedOwner, CollectionPersister persister, Serializable id, boolean emptySnapshot, SessionImplementor session) throws CacheException {
        super(persister, null, id, session);
        if (affectedOwner == null) {
            throw new AssertionFailure("affectedOwner == null");
        }
        this.emptySnapshot = emptySnapshot;
        this.affectedOwner = affectedOwner;
    }

    @Override
    public void execute() throws HibernateException {
        PersistentCollection collection;
        this.preRemove();
        if (!this.emptySnapshot) {
            this.getPersister().remove(this.getKey(), this.getSession());
        }
        if ((collection = this.getCollection()) != null) {
            this.getSession().getPersistenceContext().getCollectionEntry(collection).afterAction(collection);
        }
        this.evict();
        this.postRemove();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().removeCollection(this.getPersister().getRole());
        }
    }

    private void preRemove() {
        PreCollectionRemoveEventListener[] preListeners = this.getSession().getListeners().getPreCollectionRemoveEventListeners();
        if (preListeners.length > 0) {
            PreCollectionRemoveEvent preEvent = new PreCollectionRemoveEvent(this.getPersister(), this.getCollection(), (EventSource)this.getSession(), this.affectedOwner);
            for (int i = 0; i < preListeners.length; ++i) {
                preListeners[i].onPreRemoveCollection(preEvent);
            }
        }
    }

    private void postRemove() {
        PostCollectionRemoveEventListener[] postListeners = this.getSession().getListeners().getPostCollectionRemoveEventListeners();
        if (postListeners.length > 0) {
            PostCollectionRemoveEvent postEvent = new PostCollectionRemoveEvent(this.getPersister(), this.getCollection(), (EventSource)this.getSession(), this.affectedOwner);
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostRemoveCollection(postEvent);
            }
        }
    }
}

