/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.maven.artifact.ant.shaded.FileUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;

public class WagonUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String resource, Wagon wagon) throws IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File file = null;
        try {
            boolean deleted;
            String retValue;
            file = File.createTempFile("wagon", "tmp");
            wagon.get(resource, file);
            String string = retValue = FileUtils.fileRead(file);
            Object var6_5 = null;
            if (file != null && !(deleted = file.delete())) {
                file.deleteOnExit();
            }
            return string;
        }
        catch (Throwable throwable) {
            block3: {
                boolean deleted;
                Object var6_6 = null;
                if (file == null || (deleted = file.delete())) break block3;
                file.deleteOnExit();
            }
            throw throwable;
        }
    }

    public static void putDirectory(File dir, Wagon wagon, boolean includeBasdir) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        LinkedList<String> queue = new LinkedList<String>();
        if (includeBasdir) {
            queue.add(dir.getName());
        } else {
            queue.add("");
        }
        while (!queue.isEmpty()) {
            String path = (String)queue.removeFirst();
            File currentDir = new File(dir, path);
            File[] files = currentDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String resource = path.length() > 0 ? path + "/" + file.getName() : file.getName();
                if (file.isDirectory()) {
                    queue.add(resource);
                    continue;
                }
                wagon.put(file, resource);
            }
        }
    }

    public static AuthenticationInfo getAuthInfo() {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        String userName = WagonUtils.getUserName();
        authInfo.setUserName(userName);
        File privateKey = new File(System.getProperty("user.home"), "/.ssh/id_dsa");
        if (privateKey.exists()) {
            authInfo.setPrivateKey(privateKey.getAbsolutePath());
            authInfo.setPassphrase("");
        }
        return authInfo;
    }

    private static String getUserGroup() {
        String retValue = System.getProperty("user.group");
        return retValue;
    }

    public static String getUserName() {
        String retValue = System.getProperty("user.name");
        return retValue;
    }
}

