/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLReaderManager {
    private static final XMLReaderManager m_singletonManager = new XMLReaderManager();
    private static SAXParserFactory m_parserFactory = SAXParserFactory.newInstance();
    private ThreadLocal m_parser = new ThreadLocal();
    private ThreadLocal m_activeReader = new ThreadLocal();

    private XMLReaderManager() {
    }

    public static XMLReaderManager getInstance() {
        return m_singletonManager;
    }

    public XMLReader getXMLReader() throws SAXException {
        try {
            if (this.m_activeReader.get() == null) {
                XMLReader reader;
                SAXParser cached = (SAXParser)this.m_parser.get();
                if (cached != null) {
                    reader = cached.getXMLReader();
                } else {
                    SAXParser parser = m_parserFactory.newSAXParser();
                    this.m_parser.set(parser);
                    reader = parser.getXMLReader();
                }
                this.m_activeReader.set(reader);
                return reader;
            }
            return m_parserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex);
        }
        catch (FactoryConfigurationError ex1) {
            throw new SAXException(ex1.toString());
        }
        catch (NoSuchMethodError ex2) {
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        return null;
    }

    public void releaseXMLReader(XMLReader reader) {
        if (reader == this.m_activeReader.get()) {
            this.m_activeReader.set(null);
            try {
                ((SAXParser)this.m_parser.get()).reset();
            }
            catch (Throwable th) {
                this.m_parser.set(null);
            }
        }
    }

    static {
        m_parserFactory.setNamespaceAware(true);
    }
}

