/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistKeyAssigner;
import com.sleepycat.persist.raw.RawObject;

public class PersistEntityBinding
implements EntityBinding {
    Catalog catalog;
    Format entityFormat;
    boolean rawAccess;
    PersistKeyAssigner keyAssigner;

    public PersistEntityBinding(Catalog catalog, String entityClassName, boolean rawAccess) {
        this.catalog = catalog;
        if (rawAccess) {
            this.entityFormat = catalog.getFormat(entityClassName);
            if (this.entityFormat == null || !this.entityFormat.isEntity()) {
                throw new IllegalArgumentException("Not an entity class: " + entityClassName);
            }
        } else {
            Class<?> entityCls;
            try {
                entityCls = Class.forName(entityClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            this.entityFormat = catalog.getFormat(entityCls);
        }
        this.rawAccess = rawAccess;
    }

    public PersistKeyAssigner getKeyAssigner() {
        return this.keyAssigner;
    }

    @Override
    public Object entryToObject(DatabaseEntry key, DatabaseEntry data) {
        return PersistEntityBinding.readEntity(this.catalog, key, data, this.rawAccess);
    }

    static Object readEntity(Catalog catalog, DatabaseEntry key, DatabaseEntry data, boolean rawAccess) {
        EntityInput keyInput = new EntityInput(catalog, rawAccess, null, 0, key.getData(), key.getOffset(), key.getSize());
        EntityInput dataInput = new EntityInput(catalog, rawAccess, null, 0, data.getData(), data.getOffset(), data.getSize());
        int formatId = dataInput.readPackedInt();
        Format format = catalog.getFormat(formatId);
        Object entity = format.newInstance(dataInput, rawAccess);
        format.readPriKey(entity, keyInput, rawAccess);
        format.readObject(entity, dataInput, rawAccess);
        return entity;
    }

    @Override
    public void objectToData(Object entity, DatabaseEntry data) {
        Format format = this.getValidFormat(entity);
        PersistEntityBinding.writeEntity(format, this.catalog, entity, data, this.rawAccess);
    }

    static void writeEntity(Format format, Catalog catalog, Object entity, DatabaseEntry data, boolean rawAccess) {
        EntityOutput output = new EntityOutput(catalog, rawAccess);
        output.writePackedInt(format.getId());
        format.writeObject(entity, output, rawAccess);
        TupleBase.outputToEntry(output, data);
    }

    @Override
    public void objectToKey(Object entity, DatabaseEntry key) {
        Format format = this.getValidFormat(entity);
        EntityOutput output = new EntityOutput(this.catalog, this.rawAccess);
        format.writePriKey(entity, output, this.rawAccess);
        TupleBase.outputToEntry(output, key);
    }

    private Format getValidFormat(Object entity) {
        Format format;
        if (entity == null) {
            throw new IllegalArgumentException("An entity may not be null");
        }
        if (this.rawAccess) {
            if (!(entity instanceof RawObject)) {
                throw new IllegalArgumentException("Entity must be a RawObject");
            }
            format = (Format)((RawObject)entity).getType();
        } else {
            format = this.catalog.getFormat(entity.getClass());
        }
        if (format.getEntityFormat() != this.entityFormat) {
            throw new IllegalArgumentException("The entity class (" + format.getClassName() + ") must be this entity class or a subclass of it: " + this.entityFormat.getClassName());
        }
        return format;
    }
}

