/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

public class GlobalTransaction
implements Externalizable {
    private static final long serialVersionUID = 8011434781266976149L;
    private static AtomicLong sid = new AtomicLong(0L);
    private static byte[] instanceId = new byte[4];
    private Address addr = null;
    private long id = -1L;
    private transient boolean remote = false;
    private transient int hash_code = -1;

    public GlobalTransaction() {
    }

    private GlobalTransaction(Address addr) {
        if (addr != null && addr instanceof IpAddress) {
            try {
                addr = (Address)((IpAddress)addr).clone();
                ((IpAddress)addr).setAdditionalData(instanceId);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        this.addr = addr;
        this.id = sid.getAndIncrement();
    }

    public static GlobalTransaction create(Address addr) {
        return new GlobalTransaction(addr);
    }

    public Object getAddress() {
        return this.addr;
    }

    public void setAddress(Address address) {
        this.addr = address;
    }

    public long getId() {
        return this.id;
    }

    public byte[] getInstanceId() {
        if (this.addr == null || !(this.addr instanceof IpAddress)) {
            return null;
        }
        return ((IpAddress)this.addr).getAdditionalData();
    }

    public int hashCode() {
        if (this.hash_code == -1) {
            this.hash_code = (this.addr != null ? this.addr.hashCode() : 0) + (int)this.id + Arrays.hashCode(this.getInstanceId());
        }
        return this.hash_code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlobalTransaction)) {
            return false;
        }
        GlobalTransaction otherGtx = (GlobalTransaction)other;
        boolean aeq = this.addr == null ? otherGtx.addr == null : this.addr.equals(otherGtx.addr);
        return aeq && this.id == otherGtx.id && Arrays.equals(this.getInstanceId(), otherGtx.getInstanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GlobalTransaction:<").append(this.addr).append(">:").append(this.id);
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.addr);
        out.writeLong(this.id);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.addr = (Address)in.readObject();
        this.id = in.readLong();
        this.hash_code = -1;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public void setId(long id) {
        this.id = id;
    }

    static {
        new Random().nextBytes(instanceId);
    }
}

