/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.HandleStatus;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.Bridge;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.utils.Future;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.UUID;

public class BridgeImpl
implements Bridge,
SessionFailureListener,
SendAcknowledgementHandler {
    private static final Logger log = Logger.getLogger(BridgeImpl.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private static final SimpleString JMS_QUEUE_ADDRESS_PREFIX = new SimpleString("jms.queue.");
    private static final SimpleString JMS_TOPIC_ADDRESS_PREFIX = new SimpleString("jms.topic.");
    protected final ServerLocatorInternal serverLocator;
    private final UUID nodeUUID;
    private final SimpleString name;
    private final Queue queue;
    protected final Executor executor;
    protected final ScheduledExecutorService scheduledExecutor;
    protected ScheduledFuture<?> futureScheduledReconnection;
    private final Filter filter;
    private final SimpleString forwardingAddress;
    private final java.util.Queue<MessageReference> refs = new ConcurrentLinkedQueue<MessageReference>();
    private final Transformer transformer;
    private volatile ClientSessionFactoryInternal csf;
    protected volatile ClientSessionInternal session;
    private volatile ClientProducer producer;
    private volatile boolean started;
    private final boolean useDuplicateDetection;
    private volatile boolean active;
    private boolean deliveringLargeMessage;
    private final String user;
    private final String password;
    private boolean activated;
    private final int reconnectAttempts;
    private int reconnectAttemptsInUse;
    private final long retryInterval;
    private final double retryMultiplier;
    private final long maxRetryInterval;
    private int retryCount = 0;
    private NotificationService notificationService;
    private boolean stopping = false;

    public BridgeImpl(ServerLocatorInternal serverLocator, int reconnectAttempts, long retryInterval, double retryMultiplier, long maxRetryInterval, UUID nodeUUID, SimpleString name, Queue queue, Executor executor, SimpleString filterString, SimpleString forwardingAddress, ScheduledExecutorService scheduledExecutor, Transformer transformer, boolean useDuplicateDetection, String user, String password, boolean activated, StorageManager storageManager) throws Exception {
        this.reconnectAttempts = reconnectAttempts;
        this.reconnectAttemptsInUse = -1;
        this.retryInterval = retryInterval;
        this.retryMultiplier = retryMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.serverLocator = serverLocator;
        this.nodeUUID = nodeUUID;
        this.name = name;
        this.queue = queue;
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
        this.filter = FilterImpl.createFilter(filterString);
        this.forwardingAddress = forwardingAddress;
        this.transformer = transformer;
        this.useDuplicateDetection = useDuplicateDetection;
        this.user = user;
        this.password = password;
        this.activated = activated;
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.started = true;
        this.stopping = false;
        if (this.activated) {
            this.activate();
        }
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), NotificationType.BRIDGE_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
    }

    @Override
    public String debug() {
        return this.toString();
    }

    private void cancelRefs() {
        MessageReference ref;
        LinkedList<MessageReference> list = new LinkedList<MessageReference>();
        while ((ref = this.refs.poll()) != null) {
            if (isTrace) {
                log.trace("Cancelling reference " + ref + " on bridge " + this);
            }
            list.addFirst(ref);
        }
        if (isTrace && list.isEmpty()) {
            log.trace("didn't have any references to cancel on bridge " + this);
        }
        Queue refqueue = null;
        long timeBase = System.currentTimeMillis();
        for (MessageReference ref2 : list) {
            refqueue = ref2.getQueue();
            try {
                refqueue.cancel(ref2, timeBase);
            }
            catch (Exception e) {
                log.error("Couldn't cancel reference " + ref2, e);
            }
        }
    }

    @Override
    public void flushExecutor() {
        Future future = new Future();
        this.executor.execute(future);
        boolean ok = future.await(10000L);
        if (!ok) {
            log.warn("Timed out waiting to stop");
        }
    }

    @Override
    public void disconnect() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (BridgeImpl.this.session != null) {
                    try {
                        BridgeImpl.this.session.cleanUp(false);
                    }
                    catch (Exception dontcare) {
                        log.debug(dontcare.getMessage(), dontcare);
                    }
                    BridgeImpl.this.session = null;
                }
            }
        });
    }

    @Override
    public boolean isConnected() {
        return this.session != null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void stop() throws Exception {
        if (this.stopping) {
            return;
        }
        this.stopping = true;
        if (log.isDebugEnabled()) {
            log.debug("Bridge " + this.name + " being stopped");
        }
        if (this.futureScheduledReconnection != null) {
            this.futureScheduledReconnection.cancel(true);
        }
        this.executor.execute(new StopRunnable());
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), NotificationType.BRIDGE_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                log.warn("unable to send notification when broadcast group is stopped", e);
            }
        }
    }

    @Override
    public void pause() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Bridge " + this.name + " being paused");
        }
        this.executor.execute(new PauseRunnable());
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), NotificationType.BRIDGE_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                log.warn("unable to send notification when broadcast group is stopped", e);
            }
        }
    }

    @Override
    public void resume() throws Exception {
        this.queue.addConsumer(this);
        this.queue.deliverAsync();
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void activate() {
        this.activated = true;
        this.executor.execute(new ConnectRunnable(this));
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public SimpleString getForwardingAddress() {
        return this.forwardingAddress;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public boolean isUseDuplicateDetection() {
        return this.useDuplicateDetection;
    }

    @Override
    public RemotingConnection getForwardingConnection() {
        if (this.session == null) {
            return null;
        }
        return this.session.getConnection();
    }

    public void setupRetry(int currentCount, int maxRetry) {
        this.retryCount = currentCount;
        this.reconnectAttemptsInUse = maxRetry;
    }

    @Override
    public void sendAcknowledged(Message message) {
        try {
            MessageReference ref = this.refs.poll();
            if (ref != null) {
                if (isTrace) {
                    log.trace(this + " Acking " + ref + " on queue " + ref.getQueue());
                }
                ref.getQueue().acknowledge(ref);
            }
        }
        catch (Exception e) {
            log.error("Failed to ack", e);
        }
    }

    protected ServerMessage beforeForward(ServerMessage message) {
        if (this.useDuplicateDetection) {
            byte[] bytes = BridgeImpl.getDuplicateBytes(this.nodeUUID, message.getMessageID());
            message.putBytesProperty(MessageImpl.HDR_BRIDGE_DUPLICATE_ID, bytes);
        }
        if (this.transformer != null) {
            ServerMessage transformedMessage = this.transformer.transform(message);
            if (transformedMessage != message && log.isDebugEnabled()) {
                log.debug("The transformer " + this.transformer + " made a copy of the message " + message + " as transformedMessage");
            }
            return transformedMessage;
        }
        return message;
    }

    public static byte[] getDuplicateBytes(UUID nodeUUID, long messageID) {
        byte[] bytes = new byte[24];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.put(nodeUUID.asBytes());
        bb.putLong(messageID);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleStatus handle(MessageReference ref) throws Exception {
        if (this.filter != null && !this.filter.match(ref.getMessage())) {
            return HandleStatus.NO_MATCH;
        }
        BridgeImpl bridgeImpl = this;
        synchronized (bridgeImpl) {
            if (!this.active) {
                if (log.isDebugEnabled()) {
                    log.debug(this + "::Ignoring reference on bridge as it is set to iniactive ref=" + ref);
                }
                return HandleStatus.BUSY;
            }
            if (this.deliveringLargeMessage) {
                return HandleStatus.BUSY;
            }
            if (isTrace) {
                log.trace("Bridge " + this + " is handling reference=" + ref);
            }
            ref.handled();
            this.refs.add(ref);
            ServerMessage message = this.beforeForward(ref.getMessage());
            SimpleString dest = this.forwardingAddress != null ? this.forwardingAddress : message.getAddress();
            if (message.isLargeMessage()) {
                this.deliveringLargeMessage = true;
                this.deliverLargeMessage(dest, ref, (LargeServerMessage)message);
                return HandleStatus.HANDLED;
            }
            return this.deliverStandardMessage(dest, ref, message);
        }
    }

    @Override
    public void connectionFailed(HornetQException me, boolean failedOver) {
        log.warn(this + "::Connection failed with failedOver=" + failedOver + "-" + me, me);
        try {
            if (this.producer != null) {
                this.producer.close();
            }
            this.csf.cleanup();
        }
        catch (Throwable dontCare) {
            // empty catch block
        }
        try {
            this.session.cleanUp(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fail(me.getCode() == 4);
        this.tryScheduleRetryReconnect(me.getCode());
    }

    protected void tryScheduleRetryReconnect(int code) {
        this.scheduleRetryConnect();
    }

    @Override
    public void beforeReconnect(HornetQException exception) {
    }

    private void deliverLargeMessage(final SimpleString dest, final MessageReference ref, final LargeServerMessage message) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BridgeImpl.this.producer.send(dest, (Message)message);
                    BridgeImpl.this.unsetLargeMessageDelivery();
                    if (BridgeImpl.this.queue != null) {
                        BridgeImpl.this.queue.deliverAsync();
                    }
                }
                catch (HornetQException e) {
                    BridgeImpl.this.unsetLargeMessageDelivery();
                    log.warn("Unable to send message " + ref + ", will try again once bridge reconnects", e);
                    BridgeImpl.this.connectionFailed(e, false);
                }
            }
        });
    }

    private HandleStatus deliverStandardMessage(SimpleString dest, MessageReference ref, ServerMessage message) {
        if (log.isTraceEnabled()) {
            log.trace("going to send message " + message);
        }
        try {
            this.producer.send(dest, (Message)message);
        }
        catch (HornetQException e) {
            log.warn("Unable to send message " + ref + ", will try again once bridge reconnects", e);
            this.refs.remove(ref);
            this.connectionFailed(e, false);
            return HandleStatus.BUSY;
        }
        return HandleStatus.HANDLED;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " [name=" + this.name + ", queue=" + this.queue + " targetConnector=" + this.serverLocator + "]";
    }

    protected void fail(boolean permanently) {
        log.debug(this + "\n\t::fail being called, permanently=" + permanently);
        if (this.queue != null) {
            try {
                if (isTrace) {
                    log.trace("Removing consumer on fail " + this + " from queue " + this.queue);
                }
                this.queue.removeConsumer(this);
            }
            catch (Exception dontcare) {
                log.debug(dontcare);
            }
        }
        this.cancelRefs();
        if (this.queue != null) {
            this.queue.deliverAsync();
        }
    }

    protected void afterConnect() throws Exception {
        this.retryCount = 0;
        this.reconnectAttemptsInUse = this.reconnectAttempts;
        if (this.futureScheduledReconnection != null) {
            this.futureScheduledReconnection.cancel(true);
            this.futureScheduledReconnection = null;
        }
    }

    protected ClientSessionFactoryInternal getCurrentFactory() {
        return this.csf;
    }

    protected ClientSessionFactoryInternal createSessionFactory() throws Exception {
        ClientSessionFactoryInternal csf = (ClientSessionFactoryInternal)this.serverLocator.createSessionFactory();
        csf.setReconnectAttempts(0);
        return csf;
    }

    protected void connect() {
        log.debug("Connecting  " + this + " to its destination [" + this.nodeUUID.toString() + "], csf=" + this.csf);
        if (this.stopping) {
            return;
        }
        ++this.retryCount;
        try {
            if (this.csf == null || this.csf.isClosed()) {
                this.csf = this.createSessionFactory();
                if (this.csf == null) {
                    this.scheduleRetryConnect();
                    return;
                }
                this.session = (ClientSessionInternal)this.csf.createSession(this.user, this.password, false, true, true, true, 1);
            }
            if (this.forwardingAddress != null) {
                ClientSession.BindingQuery query = null;
                try {
                    query = this.session.bindingQuery(this.forwardingAddress);
                }
                catch (Throwable e) {
                    log.warn("Error on querying binding on bridge " + this.name + ". Retrying in 100 milliseconds", e);
                    --this.retryCount;
                    this.scheduleRetryConnectFixedTimeout(100L);
                    return;
                }
                if (this.forwardingAddress.startsWith(JMS_QUEUE_ADDRESS_PREFIX) || this.forwardingAddress.startsWith(JMS_TOPIC_ADDRESS_PREFIX)) {
                    if (!query.isExists()) {
                        log.warn("Address " + this.forwardingAddress + " doesn't have any bindings yet, retry #(" + this.retryCount + ")");
                        this.scheduleRetryConnect();
                        return;
                    }
                } else if (!query.isExists()) {
                    log.info("Bridge " + this.getName() + " connected to fowardingAddress=" + this.getForwardingAddress() + ". " + this.getForwardingAddress() + " doesn't have any bindings what means messages will be ignored until a binding is created.");
                }
            }
            this.producer = this.session.createProducer();
            this.session.addFailureListener(this);
            this.session.setSendAcknowledgementHandler(this);
            this.afterConnect();
            this.active = true;
            this.queue.addConsumer(this);
            this.queue.deliverAsync();
            log.info("Bridge " + this + " is connected");
            return;
        }
        catch (HornetQException e) {
            if (e.getCode() == 112) {
                log.warn("Server is starting, retry to create the session for bridge " + this.name);
                --this.retryCount;
                this.scheduleRetryConnectFixedTimeout(this.retryInterval);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Bridge " + this + " is unable to connect to destination. Retrying", e);
            }
            this.scheduleRetryConnect();
        }
        catch (Exception e) {
            log.warn("Bridge " + this + " is unable to connect to destination. It will be disabled.", e);
        }
    }

    protected void scheduleRetryConnect() {
        if (this.serverLocator.isClosed()) {
            log.warn("ServerLocator was shutdown, can't retry on opening connection for bridge");
            return;
        }
        if (this.stopping) {
            log.info("Bridge is stopping, will not retry");
            return;
        }
        if (this.reconnectAttemptsInUse >= 0 && this.retryCount > this.reconnectAttemptsInUse) {
            log.warn("Bridge " + this.name + " achieved " + this.retryCount + " maxattempts=" + this.reconnectAttempts + " it will stop retrying to reconnect");
            this.fail(true);
            return;
        }
        long timeout = (long)((double)this.retryInterval * Math.pow(this.retryMultiplier, this.retryCount));
        if (timeout == 0L) {
            timeout = this.retryInterval;
        }
        if (timeout > this.maxRetryInterval) {
            timeout = this.maxRetryInterval;
        }
        log.debug("Bridge " + this + " retrying connection #" + this.retryCount + ", maxRetry=" + this.reconnectAttemptsInUse + ", timeout=" + timeout);
        this.scheduleRetryConnectFixedTimeout(timeout);
    }

    protected void scheduleRetryConnectFixedTimeout(long milliseconds) {
        if (this.csf != null) {
            try {
                this.csf.cleanup();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Scheduling retry for bridge " + this.name + " in " + milliseconds + " milliseconds");
        }
        this.futureScheduledReconnection = this.scheduledExecutor.schedule(new FutureConnectRunnable(this, this.executor), milliseconds, TimeUnit.MILLISECONDS);
    }

    private void internalCancelReferences() {
        this.cancelRefs();
        if (this.queue != null) {
            this.queue.deliverAsync();
        }
    }

    private synchronized void unsetLargeMessageDelivery() {
        this.deliveringLargeMessage = false;
    }

    private static class ConnectRunnable
    implements Runnable {
        final BridgeImpl bridge;

        public ConnectRunnable(BridgeImpl bridge) {
            this.bridge = bridge;
        }

        @Override
        public synchronized void run() {
            this.bridge.connect();
        }
    }

    private static class FutureConnectRunnable
    implements Runnable {
        final Executor executor;
        final BridgeImpl bridge;

        public FutureConnectRunnable(BridgeImpl bridge, Executor executor) {
            this.bridge = bridge;
            this.executor = executor;
        }

        @Override
        public void run() {
            this.executor.execute(new ConnectRunnable(this.bridge));
        }
    }

    private class PauseRunnable
    implements Runnable {
        private PauseRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BridgeImpl bridgeImpl = BridgeImpl.this;
                synchronized (bridgeImpl) {
                    BridgeImpl.this.started = false;
                    BridgeImpl.this.active = false;
                }
                BridgeImpl.this.queue.removeConsumer(BridgeImpl.this);
                BridgeImpl.this.internalCancelReferences();
                log.info("paused bridge " + BridgeImpl.this.name);
            }
            catch (Exception e) {
                log.error("Failed to pause bridge", e);
            }
        }
    }

    private class StopRunnable
    implements Runnable {
        private StopRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                log.debug("stopping bridge " + BridgeImpl.this);
                if (BridgeImpl.this.session != null) {
                    log.debug("Cleaning up session " + BridgeImpl.this.session);
                    BridgeImpl.this.session.removeFailureListener(BridgeImpl.this);
                    try {
                        BridgeImpl.this.session.close();
                        BridgeImpl.this.session = null;
                    }
                    catch (Exception dontcare) {
                        // empty catch block
                    }
                }
                if (BridgeImpl.this.csf != null) {
                    BridgeImpl.this.csf.cleanup();
                }
                BridgeImpl.this.queue.removeConsumer(BridgeImpl.this);
                BridgeImpl.this.internalCancelReferences();
                BridgeImpl dontcare = BridgeImpl.this;
                synchronized (dontcare) {
                    log.debug("Closing Session for bridge " + BridgeImpl.this.name);
                    BridgeImpl.this.started = false;
                    BridgeImpl.this.active = false;
                }
                if (isTrace) {
                    log.trace("Removing consumer on stopRunnable " + this + " from queue " + BridgeImpl.this.queue);
                }
                log.info("stopped bridge " + BridgeImpl.this.name);
            }
            catch (Exception e) {
                log.error("Failed to stop bridge", e);
            }
        }
    }
}

