/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.journal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientRequestor;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.utils.Base64;
import org.hornetq.utils.UUID;
import org.hornetq.utils.UUIDGenerator;

public class XmlDataImporter {
    private static final Logger log = Logger.getLogger(XmlDataImporter.class);
    XMLStreamReader reader;
    ClientSession session;
    ClientSession managementSession;
    boolean localSession = false;
    Map<String, String> addressMap = new HashMap<String, String>();
    Map<String, Long> queueIDs = new HashMap<String, Long>();
    String tempFileName = "";

    public XmlDataImporter(InputStream inputStream, ClientSession session) {
        this(inputStream, session, null);
    }

    public XmlDataImporter(InputStream inputStream, ClientSession session, ClientSession managementSession) {
        try {
            this.reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            this.session = session;
            this.managementSession = managementSession != null ? managementSession : session;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XmlDataImporter(InputStream inputStream, String host, String port, boolean transactional) {
        try {
            this.reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            HashMap<String, Object> connectionParams = new HashMap<String, Object>();
            connectionParams.put("host", host);
            connectionParams.put("port", port);
            ServerLocator serverLocator = HornetQClient.createServerLocatorWithoutHA(new TransportConfiguration(NettyConnectorFactory.class.getName(), connectionParams));
            ClientSessionFactory sf = serverLocator.createSessionFactory();
            this.session = sf.createSession(false, !transactional, true);
            this.managementSession = sf.createSession(false, true, true);
            this.localSession = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XmlDataImporter(String inputFile, String host, String port, boolean transactional) throws FileNotFoundException {
        this(new FileInputStream(inputFile), host, port, transactional);
    }

    public static void main(String[] arg) {
        if (arg.length < 3) {
            System.out.println("Use: java -cp hornetq-core.jar " + XmlDataImporter.class + " <inputFile> <host> <port> [<transactional>]");
            System.exit(-1);
        }
        try {
            XmlDataImporter xmlDataImporter = new XmlDataImporter(arg[0], arg[1], arg[2], arg.length > 3 && Boolean.parseBoolean(arg[3]));
            xmlDataImporter.processXml();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXml() throws Exception {
        try {
            while (this.reader.hasNext()) {
                log.debug("EVENT:[" + this.reader.getLocation().getLineNumber() + "][" + this.reader.getLocation().getColumnNumber() + "] ");
                if (this.reader.getEventType() == 1) {
                    if ("binding".equals(this.reader.getLocalName())) {
                        this.bindQueue();
                    }
                    if ("message".equals(this.reader.getLocalName())) {
                        this.processMessage();
                    }
                }
                this.reader.next();
            }
            if (!this.session.isAutoCommitSends()) {
                this.session.commit();
            }
        }
        finally {
            if (this.localSession) {
                this.session.close();
                this.managementSession.close();
            }
        }
    }

    private void processMessage() throws Exception {
        Byte type = 0;
        Byte priority = 0;
        Long expiration = 0L;
        Long timestamp = 0L;
        UUID userId = null;
        ArrayList<String> queues = new ArrayList<String>();
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName = this.reader.getAttributeLocalName(i);
            if ("type".equals(attributeName)) {
                type = this.getMessageType(this.reader.getAttributeValue(i));
                continue;
            }
            if ("priority".equals(attributeName)) {
                priority = Byte.parseByte(this.reader.getAttributeValue(i));
                continue;
            }
            if ("expiration".equals(attributeName)) {
                expiration = Long.parseLong(this.reader.getAttributeValue(i));
                continue;
            }
            if ("timestamp".equals(attributeName)) {
                timestamp = Long.parseLong(this.reader.getAttributeValue(i));
                continue;
            }
            if (!"user-id".equals(attributeName)) continue;
            userId = UUIDGenerator.getInstance().generateUUID();
        }
        ClientMessage message = this.session.createMessage(type, true, expiration, timestamp, priority);
        message.setUserID(userId);
        boolean endLoop = false;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if ("body".equals(this.reader.getLocalName())) {
                        this.processMessageBody(message);
                        break;
                    }
                    if ("property".equals(this.reader.getLocalName())) {
                        this.processMessageProperties(message);
                        break;
                    }
                    if (!"queue".equals(this.reader.getLocalName())) break;
                    this.processMessageQueues(queues);
                    break;
                }
                case 2: {
                    if (!"message".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        this.sendMessage(queues, message);
    }

    private Byte getMessageType(String value) {
        Byte type = 0;
        if (value.equals("default")) {
            type = 0;
        } else if (value.equals("bytes")) {
            type = 4;
        } else if (value.equals("map")) {
            type = 5;
        } else if (value.equals("object")) {
            type = 2;
        } else if (value.equals("stream")) {
            type = 6;
        } else if (value.equals("text")) {
            type = 3;
        }
        return type;
    }

    private void sendMessage(ArrayList<String> queues, Message message) throws Exception {
        File tempFile;
        StringBuilder logMessage = new StringBuilder();
        String destination = this.addressMap.get(queues.get(0));
        logMessage.append("Sending ").append(message).append(" to address: ").append(destination).append("; routed to queues: ");
        ByteBuffer buffer = ByteBuffer.allocate(queues.size() * 8);
        for (String queue : queues) {
            long queueID = 0L;
            if (this.queueIDs.containsKey(queue)) {
                queueID = this.queueIDs.get(queue);
            } else {
                ClientRequestor requestor = new ClientRequestor(this.managementSession, "jms.queue.hornetq.management");
                ClientMessage managementMessage = this.managementSession.createMessage(false);
                ManagementHelper.putAttribute(managementMessage, "core.queue." + queue, "ID");
                this.managementSession.start();
                log.debug("Requesting ID for: " + queue);
                ClientMessage reply = requestor.request(managementMessage);
                queueID = ((Integer)ManagementHelper.getResult(reply)).intValue();
                requestor.close();
                log.debug("ID for " + queue + " is: " + queueID);
                this.queueIDs.put(queue, queueID);
            }
            logMessage.append(queue).append(", ");
            buffer.putLong(queueID);
        }
        logMessage.delete(logMessage.length() - 2, logMessage.length());
        log.debug(logMessage);
        message.putBytesProperty(MessageImpl.HDR_ROUTE_TO_IDS, buffer.array());
        ClientProducer producer = this.session.createProducer(destination);
        producer.send(message);
        producer.close();
        if (this.tempFileName.length() > 0 && !(tempFile = new File(this.tempFileName)).delete()) {
            log.warn("Could not delete: " + this.tempFileName);
        }
    }

    private void processMessageQueues(ArrayList<String> queues) {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!"name".equals(this.reader.getAttributeLocalName(i))) continue;
            queues.add(this.reader.getAttributeValue(i));
        }
    }

    private void processMessageProperties(Message message) {
        String key = "";
        String value = "";
        String propertyType = "";
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName = this.reader.getAttributeLocalName(i);
            if ("name".equals(attributeName)) {
                key = this.reader.getAttributeValue(i);
                continue;
            }
            if ("value".equals(attributeName)) {
                value = this.reader.getAttributeValue(i);
                continue;
            }
            if (!"type".equals(attributeName)) continue;
            propertyType = this.reader.getAttributeValue(i);
        }
        if (propertyType.equals("short")) {
            message.putShortProperty(key, Short.parseShort(value));
        } else if (propertyType.equals("boolean")) {
            message.putBooleanProperty(key, Boolean.parseBoolean(value));
        } else if (propertyType.equals("byte")) {
            message.putByteProperty(key, Byte.parseByte(value));
        } else if (propertyType.equals("bytes")) {
            message.putBytesProperty(key, XmlDataImporter.decode(value));
        } else if (propertyType.equals("double")) {
            message.putDoubleProperty(key, Double.parseDouble(value));
        } else if (propertyType.equals("float")) {
            message.putFloatProperty(key, Float.parseFloat(value));
        } else if (propertyType.equals("integer")) {
            message.putIntProperty(key, Integer.parseInt(value));
        } else if (propertyType.equals("long")) {
            message.putLongProperty(key, Long.parseLong(value));
        } else if (propertyType.equals("simple-string")) {
            message.putStringProperty(new SimpleString(key), new SimpleString(value));
        } else if (propertyType.equals("string")) {
            message.putStringProperty(key, value);
        }
    }

    private void processMessageBody(Message message) throws XMLStreamException, IOException {
        boolean isLarge = false;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName = this.reader.getAttributeLocalName(i);
            if (!"isLarge".equals(attributeName)) continue;
            isLarge = Boolean.parseBoolean(this.reader.getAttributeValue(i));
        }
        this.reader.next();
        if (isLarge) {
            this.tempFileName = java.util.UUID.randomUUID().toString() + ".tmp";
            log.debug("Creating temp file " + this.tempFileName + " for large message.");
            FileOutputStream out = new FileOutputStream(this.tempFileName);
            while (this.reader.hasNext() && this.reader.getEventType() != 2) {
                String characters = new String(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                String trimmedCharacters = characters.trim();
                if (trimmedCharacters.length() > 0) {
                    byte[] data = XmlDataImporter.decode(trimmedCharacters);
                    ((OutputStream)out).write(data);
                }
                this.reader.next();
            }
            ((OutputStream)out).close();
            FileInputStream fileInputStream = new FileInputStream(this.tempFileName);
            BufferedInputStream bufferedInput = new BufferedInputStream(fileInputStream);
            ((ClientMessage)message).setBodyInputStream(bufferedInput);
        } else {
            this.reader.next();
            String characters = new String(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
            message.getBodyBuffer().writeBytes(XmlDataImporter.decode(characters.trim()));
        }
    }

    private void bindQueue() throws Exception {
        String queueName = "";
        String address = "";
        String filter = "";
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName = this.reader.getAttributeLocalName(i);
            if ("address".equals(attributeName)) {
                address = this.reader.getAttributeValue(i);
                continue;
            }
            if ("queue-name".equals(attributeName)) {
                queueName = this.reader.getAttributeValue(i);
                continue;
            }
            if (!"filter-string".equals(attributeName)) continue;
            filter = this.reader.getAttributeValue(i);
        }
        ClientSession.QueueQuery queueQuery = this.session.queueQuery(new SimpleString(queueName));
        if (!queueQuery.isExists()) {
            this.session.createQueue(address, queueName, filter, true);
            log.debug("Binding queue(name=" + queueName + ", address=" + address + ", filter=" + filter + ")");
        } else {
            log.debug("Binding " + queueName + " already exists so won't re-bind.");
        }
        this.addressMap.put(queueName, address);
    }

    private static byte[] decode(String data) {
        return Base64.decode(data, 24);
    }
}

