/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class VERIFY_SUSPECT
extends Protocol
implements Runnable {
    private Address local_addr = null;
    private long timeout = 2000L;
    private int num_msgs = 1;
    final ConcurrentMap<Address, Long> suspects = new ConcurrentHashMap<Address, Long>();
    private Thread timer = null;
    private boolean use_icmp = false;
    private InetAddress bind_addr;
    private NetworkInterface intf = null;
    static final String name = "VERIFY_SUSPECT";
    protected boolean shutting_down = false;

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        boolean ignore_systemprops = Util.isBindAddressPropertyIgnored();
        String str = Util.getProperty(new String[]{"jgroups.bind_addr", "bind.address"}, props, "bind_addr", ignore_systemprops, null);
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)("(bind_addr): host " + str + " not known"));
                }
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = props.getProperty("timeout")) != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_msgs")) != null) {
            this.num_msgs = Integer.parseInt(str);
            if (this.num_msgs <= 0) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("num_msgs is invalid (" + this.num_msgs + "): setting it to 1"));
                }
                this.num_msgs = 1;
            }
            props.remove("num_msgs");
        }
        if ((str = props.getProperty("use_icmp")) != null) {
            this.use_icmp = Boolean.valueOf(str);
            props.remove("use_icmp");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 79: {
                this.shutting_down = true;
                break;
            }
            case 6: {
                View v = (View)evt.getArg();
                this.adjustSuspectedMembers(v.getMembers());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.shutting_down = false;
                break;
            }
            case 9: {
                if (this.shutting_down) {
                    return null;
                }
                Address suspected_mbr = (Address)evt.getArg();
                if (suspected_mbr == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"suspected member is null");
                    }
                    return null;
                }
                if (this.local_addr != null && this.local_addr.equals(suspected_mbr)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"I was suspected; ignoring SUSPECT message");
                    }
                    return null;
                }
                if (!this.use_icmp) {
                    this.verifySuspect(suspected_mbr);
                } else {
                    this.verifySuspectWithICMP(suspected_mbr);
                }
                return null;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                VerifyHeader hdr = (VerifyHeader)msg.getHeader(name);
                if (hdr == null) break;
                if (this.shutting_down) {
                    return null;
                }
                switch (hdr.type) {
                    case 1: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"ARE_YOU_DEAD: hdr.from is null");
                            }
                        } else {
                            for (int i = 0; i < this.num_msgs; ++i) {
                                Message rsp = new Message(hdr.from, null, null);
                                rsp.setFlag((byte)1);
                                rsp.putHeader(name, new VerifyHeader(2, this.local_addr));
                                this.down_prot.down(new Event(1, rsp));
                            }
                        }
                        return null;
                    }
                    case 2: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"I_AM_NOT_DEAD: hdr.from is null");
                            }
                            return null;
                        }
                        this.unsuspect(hdr.from);
                        return null;
                    }
                }
                return null;
            }
            case 56: {
                if (this.bind_addr != null) break;
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.suspects.isEmpty()) {
            long diff = 0L;
            LinkedList<Address> confirmed_suspects = new LinkedList<Address>();
            ConcurrentMap<Address, Long> concurrentMap = this.suspects;
            synchronized (concurrentMap) {
                for (Address mbr : this.suspects.keySet()) {
                    long val = (Long)this.suspects.get(mbr);
                    diff = System.currentTimeMillis() - val;
                    if (diff >= this.timeout) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("diff=" + diff + ", mbr " + mbr + " is dead (passing up SUSPECT event)"));
                        }
                        confirmed_suspects.add(mbr);
                        this.suspects.remove(mbr);
                        continue;
                    }
                    diff = Math.max(diff, this.timeout - diff);
                }
            }
            for (Address suspect : confirmed_suspects) {
                this.up_prot.up(new Event(9, suspect));
            }
            if (diff <= 0L) continue;
            Util.sleep(diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifySuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        ConcurrentMap<Address, Long> concurrentMap = this.suspects;
        synchronized (concurrentMap) {
            if (this.suspects.containsKey(mbr)) {
                return;
            }
            this.suspects.put(mbr, new Long(System.currentTimeMillis()));
        }
        this.startTimer();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("verifying that " + mbr + " is dead"));
        }
        for (int i = 0; i < this.num_msgs; ++i) {
            Message msg = new Message(mbr, null, null);
            msg.setFlag((byte)1);
            msg.putHeader(name, new VerifyHeader(1, this.local_addr));
            this.down_prot.down(new Event(1, msg));
        }
    }

    void verifySuspectWithICMP(Address suspected_mbr) {
        block8: {
            InetAddress host;
            InetAddress inetAddress = host = suspected_mbr instanceof IpAddress ? ((IpAddress)suspected_mbr).getIpAddress() : null;
            if (host == null) {
                throw new IllegalArgumentException("suspected_mbr is not of type IpAddress - FD_ICMP only works with these");
            }
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("pinging host " + suspected_mbr + " using interface " + this.intf));
                }
                long start = System.currentTimeMillis();
                boolean rc = host.isReachable(this.intf, 0, (int)this.timeout);
                long stop = System.currentTimeMillis();
                if (rc) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("successfully received response from " + host + " (after " + (stop - start) + "ms)"));
                    }
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.debug((Object)("could not ping " + suspected_mbr + " after " + (stop - start) + "ms; " + "passing up SUSPECT event"));
                    }
                    this.suspects.remove(suspected_mbr);
                    this.up_prot.up(new Event(9, suspected_mbr));
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block8;
                this.log.error((Object)("failed pinging " + suspected_mbr), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        boolean removed = false;
        ConcurrentMap<Address, Long> concurrentMap = this.suspects;
        synchronized (concurrentMap) {
            if (this.suspects.containsKey(mbr)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("member " + mbr + " is not dead !"));
                }
                this.suspects.remove(mbr);
                removed = true;
            }
        }
        if (removed) {
            this.down_prot.down(new Event(51, mbr));
            this.up_prot.up(new Event(51, mbr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustSuspectedMembers(List new_mbrship) {
        ConcurrentMap<Address, Long> concurrentMap = this.suspects;
        synchronized (concurrentMap) {
            for (Address s : this.suspects.keySet()) {
                if (new_mbrship.contains(s)) continue;
                this.suspects.remove(s);
            }
        }
    }

    private synchronized void startTimer() {
        if (this.timer == null || !this.timer.isAlive()) {
            this.timer = this.getThreadFactory().newThread(this, "VERIFY_SUSPECT.TimerThread");
            this.timer.setDaemon(true);
            this.timer.start();
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.bind_addr != null) {
            this.intf = NetworkInterface.getByInetAddress(this.bind_addr);
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.shutting_down = false;
    }

    @Override
    public synchronized void stop() {
        if (this.timer != null && this.timer.isAlive()) {
            Thread tmp = this.timer;
            this.timer = null;
            tmp.interrupt();
            Object var1_1 = null;
        }
        this.timer = null;
    }

    public static class VerifyHeader
    extends Header
    implements Streamable {
        static final short ARE_YOU_DEAD = 1;
        static final short I_AM_NOT_DEAD = 2;
        short type = 1;
        Address from = null;

        public VerifyHeader() {
        }

        VerifyHeader(short type) {
            this.type = type;
        }

        VerifyHeader(short type, Address from) {
            this(type);
            this.from = from;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[VERIFY_SUSPECT: ARE_YOU_DEAD]";
                }
                case 2: {
                    return "[VERIFY_SUSPECT: I_AM_NOT_DEAD]";
                }
            }
            return "[VERIFY_SUSPECT: unknown type (" + this.type + ")]";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeShort(this.type);
            out.writeObject(this.from);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readShort();
            this.from = (Address)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeShort(this.type);
            Util.writeAddress(this.from, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readShort();
            this.from = Util.readAddress(in);
        }
    }
}

