/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jms;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.jboss.test.jms.JMSTestAdmin;
import org.jboss.test.jms.TestRole;
import org.jboss.util.NestedRuntimeException;

public class LegacyJMSTestAdmin
extends JMSTestAdmin {
    private final MBeanServerConnection jmx;
    protected final ObjectName mainDeployer = new ObjectName("jboss.system:service=MainDeployer");
    protected static final ObjectName namingService;
    protected static final ObjectName namingService2;
    protected static final ObjectName serverPeer;
    private static final Logger staticLog;

    public LegacyJMSTestAdmin() throws Exception {
        InitialContext ctx = new InitialContext();
        String adaptorName = System.getProperty("jbosstest.server.name", "jmx/invoker/RMIAdaptor");
        this.jmx = (MBeanServerConnection)ctx.lookup(adaptorName);
        ctx.close();
    }

    public boolean isSupported() {
        try {
            this.createQueue("deleteMeTest", new TestRole[0]);
            this.destroyCreatedDestinations();
            staticLog.info((Object)"Legacy is supported!!!");
            return true;
        }
        catch (Throwable e) {
            staticLog.debug((Object)"LegacyJMSTestAdmin is not support because an exception happened", e);
            return false;
        }
    }

    public void createQueue(String name, TestRole ... securityConfig) throws Exception {
        this.createQueue(name, new String[]{"/queue/" + name, name}, securityConfig);
    }

    public void createQueue(String name, String[] jndiArray, TestRole ... securityConfig) throws Exception {
        this.createDestination(false, name, securityConfig);
        this.deployedQueues.put(name, securityConfig);
    }

    public void createTopic(String name, TestRole ... securityConfig) throws Exception {
        this.createTopic(name, new String[]{"/topic/" + name, name}, securityConfig);
    }

    public void createTopic(String name, String[] jndiArray, TestRole ... securityConfig) throws Exception {
        this.createDestination(true, name, securityConfig);
        this.deployedTopics.put(name, securityConfig);
    }

    public void deleteQueue(String name) throws Exception {
        try {
            this.deployedQueues.remove(name);
            this.undeploy(false, name);
        }
        catch (Exception e) {
            staticLog.warn((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void deleteTopic(String name) throws Exception {
        try {
            this.deployedTopics.remove(name);
            this.undeploy(true, name);
        }
        catch (Exception e) {
            staticLog.warn((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void destroyEveryDestination() throws Exception {
        this.destroyCreatedDestinations();
    }

    public void destroyCreatedDestinations() throws Exception {
        for (Map.Entry queue : this.deployedQueues.entrySet()) {
            this.undeploy(false, (String)queue.getKey());
        }
        for (Map.Entry topic : this.deployedTopics.entrySet()) {
            this.undeploy(true, (String)topic.getKey());
        }
        this.deployedQueues.clear();
        this.deployedTopics.clear();
    }

    public ObjectName createQueueJMXName(String queueName) {
        try {
            return new ObjectName("jboss.mq.destination:service=Queue,name=" + queueName);
        }
        catch (Exception e) {
            staticLog.warn((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public ObjectName createTopicJMXName(String queueName) {
        try {
            return new ObjectName("jboss.mq.destination:service=Topic,name=" + queueName);
        }
        catch (Exception e) {
            staticLog.warn((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public ObjectName createDestinationJMXName(boolean isTopic, String destName) {
        if (isTopic) {
            return this.createTopicJMXName(destName);
        }
        return this.createQueueJMXName(destName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeploy(boolean isTopic, String destinationName) throws Exception {
        ObjectName objname = isTopic ? new ObjectName("jboss.mq.destination:service=Topic,name=" + destinationName) : new ObjectName("jboss.mq.destination:service=Queue,name=" + destinationName);
        try {
            this.jmx.invoke(objname, "removeAllMessages", null, null);
            if (isTopic) {
                this.jmx.invoke(serverPeer, "destroyTopic", new Object[]{destinationName}, new String[]{String.class.getName()});
            } else {
                this.jmx.invoke(serverPeer, "destroyQueue", new Object[]{destinationName}, new String[]{String.class.getName()});
            }
        }
        catch (Exception e) {
            staticLog.warn((Object)e.getMessage(), (Throwable)e);
        }
        File destFile = this.createFile(isTopic, destinationName);
        try {
            this.jmx.invoke(this.mainDeployer, "undeploy", new Object[]{destFile.toURI().toURL()}, new String[]{"java.net.URL"});
        }
        finally {
            try {
                destFile.delete();
            }
            catch (Exception ignored) {}
        }
    }

    private void createDestination(boolean isTopic, String name, TestRole ... securityConfig) throws Exception {
        File fileout = this.createFile(isTopic, name);
        if (fileout.exists()) {
            fileout.delete();
        }
        FileOutputStream out = new FileOutputStream(fileout);
        PrintStream str = new PrintStream(out);
        str.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        str.println("<server>");
        if (isTopic) {
            str.println("  <mbean code=\"org.jboss.mq.server.jmx.Topic\" name=\"jboss.mq.destination:service=Topic,name=" + name + "\">");
        } else {
            str.println("  <mbean code=\"org.jboss.mq.server.jmx.Queue\" name=\"jboss.mq.destination:service=Queue,name=" + name + "\">");
        }
        str.println("    <attribute name=\"JNDIName\">" + name + "</attribute>");
        str.println("    <depends optional-attribute-name=\"DestinationManager\">jboss.mq:service=DestinationManager</depends>");
        str.println("    <depends optional-attribute-name=\"SecurityManager\">jboss.mq:service=SecurityManager</depends>");
        if (securityConfig != null && securityConfig.length > 0) {
            str.println("    <attribute name=\"SecurityConf\">");
            str.println("      <security>");
            for (TestRole role : securityConfig) {
                str.println("        <role name=" + LegacyJMSTestAdmin.q(role.getName()) + " read=" + LegacyJMSTestAdmin.q(role.isConsume()) + " write=" + LegacyJMSTestAdmin.q(role.isSend()) + " create=" + LegacyJMSTestAdmin.q(role.isCreateDurableQueue() || role.isCreateNonDurableQueue()) + "/>");
            }
            str.println("      </security>");
            str.println("    </attribute>");
        }
        str.println("  </mbean>");
        str.println("</server>");
        this.jmx.invoke(this.mainDeployer, "deploy", new Object[]{fileout.toURI().toURL()}, new String[]{"java.net.URL"});
        String newName = isTopic ? "/topic/" + name : "/queue/" + name;
        try {
            this.jmx.invoke(namingService, "createAlias", new Object[]{newName, name}, new String[]{String.class.getName(), String.class.getName()});
        }
        catch (Throwable e) {
            staticLog.debug((Object)"error creating alias", e);
        }
    }

    private File createFile(boolean isTopic, String destinationName) {
        String deployDir = System.getProperty("jbosstest.deploy.dir");
        if (deployDir == null) {
            deployDir = "output/lib";
        }
        File fileout = new File(deployDir + "/" + "tmpdest_" + (isTopic ? "topic_" : "queue_") + destinationName + "-destination-service.xml");
        return fileout;
    }

    private static final String q(Object s) {
        return "\"" + s + "\"";
    }

    static {
        try {
            namingService = new ObjectName("jboss:service=Naming");
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        try {
            namingService2 = new ObjectName("jboss:service=NamingBeanImpl");
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        try {
            serverPeer = new ObjectName("jboss.messaging:service=ServerPeer");
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        staticLog = Logger.getLogger(LegacyJMSTestAdmin.class);
    }
}

