/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jmx;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.jmx.HibernateServiceMBean;
import org.hibernate.jmx.SessionFactoryStub;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.util.ExternalSessionFactoryConfig;
import org.hibernate.util.NamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateService
extends ExternalSessionFactoryConfig
implements HibernateServiceMBean {
    private static final Logger log = LoggerFactory.getLogger(HibernateServiceMBean.class);
    private String boundName;
    private Properties properties = new Properties();

    @Override
    public void start() throws HibernateException {
        this.boundName = this.getJndiName();
        try {
            this.buildSessionFactory();
        }
        catch (HibernateException he) {
            log.info("Could not build SessionFactory using the MBean classpath - will try again using client classpath: " + he.getMessage());
            log.debug("Error was", (Throwable)he);
            new SessionFactoryStub(this);
        }
    }

    @Override
    public void stop() {
        log.info("stopping service");
        try {
            InitialContext context = NamingHelper.getInitialContext((Properties)this.buildProperties());
            ((SessionFactory)context.lookup(this.boundName)).close();
        }
        catch (Exception e) {
            log.warn("exception while stopping service", (Throwable)e);
        }
    }

    SessionFactory buildSessionFactory() throws HibernateException {
        log.info("starting service at JNDI name: " + this.boundName);
        log.info("service properties: " + this.properties);
        return this.buildConfiguration().buildSessionFactory();
    }

    protected Map getExtraProperties() {
        return this.properties;
    }

    @Override
    public String getTransactionStrategy() {
        return this.getProperty("hibernate.transaction.factory_class");
    }

    @Override
    public void setTransactionStrategy(String txnStrategy) {
        this.setProperty("hibernate.transaction.factory_class", txnStrategy);
    }

    @Override
    public String getUserTransactionName() {
        return this.getProperty("jta.UserTransaction");
    }

    @Override
    public void setUserTransactionName(String utName) {
        this.setProperty("jta.UserTransaction", utName);
    }

    @Override
    public String getTransactionManagerLookupStrategy() {
        return this.getProperty("hibernate.transaction.manager_lookup_class");
    }

    @Override
    public void setTransactionManagerLookupStrategy(String lkpStrategy) {
        this.setProperty("hibernate.transaction.manager_lookup_class", lkpStrategy);
    }

    @Override
    public String getPropertyList() {
        return this.buildProperties().toString();
    }

    @Override
    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    @Override
    public void setProperty(String property, String value) {
        this.properties.setProperty(property, value);
    }

    @Override
    public void dropSchema() {
        new SchemaExport(this.buildConfiguration()).drop(false, true);
    }

    @Override
    public void createSchema() {
        new SchemaExport(this.buildConfiguration()).create(false, true);
    }

    public String getName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    @Override
    public String getDatasource() {
        return this.getProperty("hibernate.connection.datasource");
    }

    @Override
    public void setDatasource(String datasource) {
        this.setProperty("hibernate.connection.datasource", datasource);
    }

    @Override
    public String getJndiName() {
        return this.getProperty("hibernate.session_factory_name");
    }

    @Override
    public void setJndiName(String jndiName) {
        this.setProperty("hibernate.session_factory_name", jndiName);
    }

    @Override
    public String getUserName() {
        return this.getProperty("hibernate.connection.username");
    }

    @Override
    public void setUserName(String userName) {
        this.setProperty("hibernate.connection.username", userName);
    }

    @Override
    public String getPassword() {
        return this.getProperty("hibernate.connection.password");
    }

    @Override
    public void setPassword(String password) {
        this.setProperty("hibernate.connection.password", password);
    }

    @Override
    public void setFlushBeforeCompletionEnabled(String enabled) {
        this.setProperty("hibernate.transaction.flush_before_completion", enabled);
    }

    @Override
    public String getFlushBeforeCompletionEnabled() {
        return this.getProperty("hibernate.transaction.flush_before_completion");
    }

    @Override
    public void setAutoCloseSessionEnabled(String enabled) {
        this.setProperty("hibernate.transaction.auto_close_session", enabled);
    }

    @Override
    public String getAutoCloseSessionEnabled() {
        return this.getProperty("hibernate.transaction.auto_close_session");
    }

    public Properties getProperties() {
        return this.buildProperties();
    }
}

