/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.validation;

import java.io.ByteArrayInputStream;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.ws.core.utils.JBossWSEntityResolver;
import org.jboss.ws.extensions.validation.LSInputImpl;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaResourceResolver
implements LSResourceResolver {
    private static Logger log = Logger.getLogger(SchemaResourceResolver.class);
    private Map<String, byte[]> streamMap;

    public SchemaResourceResolver(Map<String, byte[]> map) {
        this.streamMap = map;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LSInputImpl lsInput = null;
        if (this.streamMap.get(namespaceURI) != null) {
            byte[] value = this.streamMap.get(namespaceURI);
            lsInput = new LSInputImpl();
            lsInput.setByteStream(new ByteArrayInputStream(value));
        }
        try {
            JBossWSEntityResolver entityResolver = new JBossWSEntityResolver();
            InputSource ins = entityResolver.resolveEntity(publicId, systemId);
            if (ins != null) {
                lsInput = new LSInputImpl();
                lsInput.setByteStream(ins.getByteStream());
            }
        }
        catch (Exception e) {
            log.warn((Object)"Failed to resolve the schema", (Throwable)e);
        }
        return lsInput;
    }
}

