/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.entity;

import java.util.List;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.modules.ejb.AbstractEjbCodeGeneratorSubTask;
import xdoclet.modules.ejb.XDocletModulesEjbMessages;
import xdoclet.modules.ejb.entity.ValueObjectTagsHandler;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XTag;

public class ValueObjectSubTask
extends AbstractEjbCodeGeneratorSubTask {
    public static final String DEFAULT_DATAOBJECT_CLASS_PATTERN = "{0}Value";
    protected static final String DEFAULT_TEMPLATE_FILE = "resources/valueobject.xdt";
    private static String currentValueObjectClass;
    private static String currentValueObjectName;
    private static String currentValueObjectMatch;
    private static String currentValueObjectImplements;
    private static String currentValueObjectExtends;
    protected String valueObjectClassPattern;
    protected XTag currentDataObjectTag;
    private boolean generatePKConstructor = false;

    public ValueObjectSubTask() {
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(this.getValueObjectClassPattern() + ".java");
        this.addOfType("javax.ejb.EntityBean");
    }

    public static String getCurrentValueObjectClass() {
        return currentValueObjectClass;
    }

    public static String getCurrentValueObjectImplements() {
        return currentValueObjectImplements;
    }

    public static String getCurrentValueObjectExtends() {
        return currentValueObjectExtends;
    }

    public static String getCurrentValueObjectName() {
        return currentValueObjectName;
    }

    public static String getCurrentValueObjectMatch() {
        return currentValueObjectMatch;
    }

    public String getValueObjectClassPattern() {
        if (this.valueObjectClassPattern != null) {
            return this.valueObjectClassPattern;
        }
        return DEFAULT_DATAOBJECT_CLASS_PATTERN;
    }

    public boolean getGeneratePKConstructor() {
        return this.generatePKConstructor;
    }

    public void setPattern(String new_pattern) {
        this.valueObjectClassPattern = new_pattern;
    }

    public void setGeneratePKConstructor(String generatePKConstructor) {
        this.generatePKConstructor = generatePKConstructor.substring(0, 1).equalsIgnoreCase("t");
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getValueObjectClassPattern() == null || this.getValueObjectClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString(XDocletMessages.class, (String)"PARAMETER_MISSING_OR_EMPTY", (String[])new String[]{"pattern"}));
        }
        if (this.getValueObjectClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"PATTERN_HAS_NO_PLACEHOLDER"));
        }
    }

    protected String getGeneratedFileName(XClass clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor((String)ValueObjectSubTask.getCurrentValueObjectClass()) + ".java";
    }

    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException {
        if (!super.matchesGenerationRules(clazz)) {
            return false;
        }
        return ValueObjectTagsHandler.isGenerationNeeded(this.getCurrentClass());
    }

    protected void generateForClass(XClass clazz) throws XDocletException {
        List dos = this.getCurrentClass().getDoc().getTags("ejb:value-object");
        for (XTag tag : dos) {
            currentValueObjectClass = ValueObjectTagsHandler.getCurrentValueObjectClass(this.getCurrentClass(), tag);
            currentValueObjectName = ValueObjectTagsHandler.getCurrentValueObjectName(tag);
            currentValueObjectMatch = ValueObjectTagsHandler.getCurrentValueObjectMatch(tag);
            currentValueObjectImplements = ValueObjectTagsHandler.getCurrentValueObjectImplements(tag);
            currentValueObjectExtends = ValueObjectTagsHandler.getCurrentValueObjectExtends(tag);
            super.generateForClass(clazz);
        }
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString(XDocletModulesEjbMessages.class, (String)"GENERATING_VALUEOBJECT_FOR", (String[])new String[]{this.getCurrentClass().getQualifiedName() + "--> " + ValueObjectSubTask.getCurrentValueObjectClass()}));
    }
}

