/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.DNSListener;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpWebResponse;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;

public class WebConversation
extends WebClient {
    private String _proxyHost;
    private int _proxyPort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected WebResponse newResponse(WebRequest request, FrameSelector targetFrame) throws MalformedURLException, IOException {
        Properties savedProperties = (Properties)System.getProperties().clone();
        try {
            if (this._proxyHost != null) {
                System.setProperty("proxyHost", this._proxyHost);
                System.setProperty("proxyPort", Integer.toString(this._proxyPort));
            }
            URLConnection connection = this.openConnection(this.getRequestURL(request));
            if (HttpUnitOptions.isLoggingHttpHeaders()) {
                String urlString = request.getURLString();
                System.out.println("\nConnecting to " + request.getURL().getHost());
                System.out.println("Sending:: " + request.getMethod() + " " + urlString);
            }
            this.sendHeaders(connection, this.getHeaderFields(request.getURL()));
            this.sendHeaders(connection, request.getHeaderDictionary());
            request.completeRequest(connection);
            HttpWebResponse httpWebResponse = new HttpWebResponse(this, targetFrame, request, connection, this.getExceptionsThrownOnErrorStatus());
            return httpWebResponse;
        }
        finally {
            System.setProperties(savedProperties);
        }
    }

    @Override
    public void clearProxyServer() {
        this._proxyHost = null;
    }

    @Override
    public void setProxyServer(String proxyHost, int proxyPort) {
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
    }

    private URL getRequestURL(WebRequest request) throws MalformedURLException {
        DNSListener dnsListener = this.getClientProperties().getDnsListener();
        if (dnsListener == null) {
            return request.getURL();
        }
        String hostName = request.getURL().getHost();
        String portPortion = request.getURL().getPort() == -1 ? "" : ":" + request.getURL().getPort();
        this.setHeaderField("Host", hostName + portPortion);
        String actualHost = dnsListener.getIpAddress(hostName);
        if (HttpUnitOptions.isLoggingHttpHeaders()) {
            System.out.println("Rerouting request to :: " + actualHost);
        }
        return new URL(request.getURL().getProtocol(), actualHost, request.getURL().getPort(), request.getURL().getFile());
    }

    private URLConnection openConnection(URL url) throws MalformedURLException, IOException {
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setInstanceFollowRedirects(false);
        }
        connection.setUseCaches(false);
        return connection;
    }

    private void sendHeaders(URLConnection connection, Dictionary headers) {
        Enumeration e = headers.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            connection.setRequestProperty(key, (String)headers.get(key));
            if (!HttpUnitOptions.isLoggingHttpHeaders()) continue;
            if (key.equalsIgnoreCase("authorization") || key.equalsIgnoreCase("proxy-authorization")) {
                System.out.println("Sending:: " + key + ": " + headers.get(key));
                continue;
            }
            System.out.println("Sending:: " + key + ": " + connection.getRequestProperty(key));
        }
    }
}

