/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import java.util.Arrays;
import java.util.Map;
import javax.jms.JMSException;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.FailoverCommandCenter;
import org.jboss.jms.client.container.ConnectionFailureListener;
import org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
import org.jboss.jms.client.plugin.LoadBalancingPolicy;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.delegate.CreateConnectionResult;
import org.jboss.jms.exception.MessagingNetworkFailureException;
import org.jboss.logging.Logger;

public class ClusteringAspect {
    private static final Logger log = Logger.getLogger(ClusteringAspect.class);
    private boolean trace = log.isTraceEnabled();
    public static final int MAX_RECONNECT_HOP_COUNT = 10;
    private ClientClusteredConnectionFactoryDelegate clusteredDelegate;

    public Object handleCreateConnectionDelegate(Invocation invocation) throws Throwable {
        if (this.trace) {
            log.trace((Object)(this + " handleCreateConnectionDelegate"));
        }
        if (this.clusteredDelegate == null) {
            this.clusteredDelegate = (ClientClusteredConnectionFactoryDelegate)invocation.getTargetObject();
        }
        boolean supportsFailover = this.clusteredDelegate.isSupportsFailover();
        MethodInvocation mi = (MethodInvocation)invocation;
        String username = (String)mi.getArguments()[0];
        String password = (String)mi.getArguments()[1];
        Integer failedNodeID = (Integer)mi.getArguments()[2];
        int attemptCount = 0;
        ClientConnectionFactoryDelegate delegate = null;
        while (attemptCount < 10) {
            ++attemptCount;
            int nextHopingServer = -1;
            try {
                int failedNodeIDToServer = -1;
                if (delegate == null) {
                    if (failedNodeID != null && failedNodeID >= 0) {
                        delegate = this.getFailoverDelegateForNode(failedNodeID);
                        failedNodeIDToServer = failedNodeID;
                        nextHopingServer = delegate.getServerID();
                    } else {
                        LoadBalancingPolicy loadBalancingPolicy = this.clusteredDelegate.getLoadBalancingPolicy();
                        delegate = (ClientConnectionFactoryDelegate)loadBalancingPolicy.getNext();
                    }
                }
                log.trace((Object)(this + " has chosen " + delegate + " as target, " + (attemptCount == 0 ? "first connection attempt" : attemptCount + " connection attempts")));
                CreateConnectionResult res = delegate.createConnectionDelegate(username, password, failedNodeIDToServer);
                ClientConnectionDelegate cd = res.getDelegate();
                if (cd != null) {
                    log.trace((Object)(this + " got local connection delegate " + cd));
                    if (supportsFailover) {
                        ConnectionState state = (ConnectionState)cd.getState();
                        state.initializeFailoverCommandCenter();
                        FailoverCommandCenter fcc = state.getFailoverCommandCenter();
                        state.getRemotingConnection().getConnectionListener().setDelegateListener(new ConnectionFailureListener(fcc, state.getRemotingConnection()));
                        log.trace((Object)(this + " installed failure listener on " + cd));
                        state.setUsername(username);
                        state.setPassword(password);
                        state.setClusteredConnectionFactoryDeleage(this.clusteredDelegate);
                        log.trace((Object)"Successfully initialised new connection");
                    }
                    return res;
                }
                if (!supportsFailover) {
                    throw new IllegalStateException("Doesn't support failover so must return a connection delegate");
                }
                int actualServerID = res.getActualFailoverNodeID();
                if (actualServerID == -1) {
                    log.debug((Object)"Client attempted failover, but no failover attempt has been detected on the server side. We will now try again on the original server in case there was a temporary glitch on the client--server network");
                    delegate = this.getDelegateForNode(failedNodeID);
                    Thread.sleep(2000L);
                } else {
                    log.trace((Object)("Server side failover occurred, but we were non the wrong node! Actual node = " + actualServerID));
                    delegate = this.getDelegateForNode(actualServerID);
                }
                if (delegate != null) continue;
                throw new JMSException("Cannot find a cached connection factory delegate for node " + actualServerID);
            }
            catch (MessagingNetworkFailureException e) {
                failedNodeID = new Integer(nextHopingServer);
                delegate = null;
                log.warn((Object)("Exception captured on createConnection... hopping to a new connection factory on server (" + failedNodeID + ")"), (Throwable)((Object)e));
                Thread.sleep(2000L);
            }
        }
        throw new JMSException("Maximum number of failover attempts exceeded. Cannot find a server to failover onto.");
    }

    public String toString() {
        return "ClusteringAspect[" + this.clusteredDelegate + "]";
    }

    private synchronized ClientConnectionFactoryDelegate getFailoverDelegateForNode(Integer nodeID) {
        log.trace((Object)("Getting failover delegate for node id " + nodeID));
        ClientConnectionFactoryDelegate[] delegates = this.clusteredDelegate.getDelegates();
        if (nodeID < 0) {
            throw new IllegalArgumentException("nodeID must be 0 or positive");
        }
        Map failoverMap = this.clusteredDelegate.getFailoverMap();
        if (this.trace) {
            this.dumpFailoverMap(failoverMap);
        }
        Integer failoverNodeID = (Integer)failoverMap.get(nodeID);
        log.trace((Object)("Found failover node id = " + failoverNodeID));
        if (failoverNodeID == null) {
            log.trace((Object)"Couldn't find failover node id on map so guessing it");
            failoverNodeID = ClusteringAspect.guessFailoverID(failoverMap, nodeID);
            log.trace((Object)("Guess is " + failoverNodeID));
        }
        for (int i = 0; i < delegates.length; ++i) {
            if (delegates[i].getServerID() != failoverNodeID.intValue()) continue;
            return delegates[i];
        }
        return null;
    }

    private void dumpFailoverMap(Map failoverMap) {
        log.trace((Object)"Dumping failover map");
        for (Map.Entry entry : failoverMap.entrySet()) {
            log.trace((Object)(entry.getKey() + "-->" + entry.getValue()));
        }
    }

    private static Integer guessFailoverID(Map failoverMap, Integer nodeID) {
        log.trace((Object)("Guessing failover id for node " + nodeID));
        Object failoverNodeID = null;
        Object[] nodes = failoverMap.keySet().toArray(new Integer[failoverMap.size()]);
        Arrays.sort(nodes);
        for (int i = 0; i < nodes.length; ++i) {
            if (nodeID >= (Integer)nodes[i]) continue;
            failoverNodeID = nodes[i];
            break;
        }
        if (failoverNodeID == null) {
            failoverNodeID = nodes[0];
        }
        log.trace((Object)("Returning guess " + failoverNodeID));
        return failoverNodeID;
    }

    private synchronized ClientConnectionFactoryDelegate getDelegateForNode(int nodeID) {
        log.trace((Object)("Getting delegate for node id " + nodeID));
        ClientConnectionFactoryDelegate[] delegates = this.clusteredDelegate.getDelegates();
        for (int i = 0; i < delegates.length; ++i) {
            if (delegates[i].getServerID() != nodeID) continue;
            log.trace((Object)("Found " + delegates[i]));
            return delegates[i];
        }
        log.trace((Object)"Didn't find any delegate");
        return null;
    }
}

