/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.plugins.values;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.plugins.values.DefaultMetaValueFactory;

public class MetaValueFactoryBuilder {
    private static final MetaValueFactory singleton = AccessController.doPrivileged(new PrivilegedAction<MetaValueFactory>(){

        @Override
        public MetaValueFactory run() {
            MetaValueFactory mvf = null;
            String defaultMVF = DefaultMetaValueFactory.class.getName();
            String className = System.getProperty(MetaValueFactory.class.getName(), defaultMVF);
            try {
                Class<?> clazz;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    try {
                        clazz = this.getClass().getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException ignored) {
                        throw e;
                    }
                }
                Object result = clazz.newInstance();
                mvf = (MetaValueFactory)MetaValueFactory.class.cast(result);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error("Unexpected error loading MetaValueFactory " + className, e);
            }
            return mvf;
        }
    });

    public static MetaValueFactory create() {
        return singleton;
    }
}

