/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.AbstractVFSContext;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.plugins.context.jar.JarHandler;
import org.jboss.virtual.spi.VirtualFileHandler;

public class JarContext
extends AbstractVFSContext {
    private final VirtualFileHandler root;
    private final VirtualFile rootFile;

    public JarContext(URL rootURL) throws IOException, URISyntaxException {
        super(rootURL);
        this.root = this.createVirtualFileHandler(null, rootURL);
        this.rootFile = this.root.getVirtualFile();
    }

    public String getName() {
        return this.root.getName();
    }

    public VirtualFileHandler getRoot() throws IOException {
        return this.root;
    }

    protected VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        String urlStr = url.toString();
        String jarName = JarContext.extractJarName(urlStr);
        String entryPath = urlStr;
        if ((entryPath = JarContext.entryPath(entryPath)) != null) {
            String s = url.toExternalForm();
            url = new URL(s.substring(0, s.length() - entryPath.length()));
        }
        JarHandler jar = new JarHandler(this, parent, url, jarName);
        if (entryPath == null) {
            return jar;
        }
        AbstractVirtualFileHandler result = (AbstractVirtualFileHandler)jar.getChild(JarContext.removeQuery(entryPath));
        if (result == null) {
            throw new IllegalArgumentException("Null child, entryPath: " + entryPath);
        }
        result.setPathName("");
        return result;
    }

    public static String entryPath(String entryName) {
        int index = entryName.indexOf("!/");
        if ((entryName = index != -1 ? entryName.substring(index + 2) : null) == null || "".equals(entryName.trim())) {
            return null;
        }
        return entryName;
    }

    protected static String removeQuery(String entryPath) {
        int index = entryPath.indexOf("?");
        if (index != -1) {
            entryPath = entryPath.substring(0, index);
        }
        return entryPath;
    }

    public static String extractJarName(String urlStr) {
        String jarName = urlStr;
        int index = jarName.indexOf(33);
        if (index != -1) {
            jarName = jarName.substring(0, index);
        }
        if ((index = jarName.lastIndexOf(47)) != -1 && index < jarName.length() - 1) {
            jarName = jarName.substring(index + 1);
        }
        return jarName;
    }

    protected void finalize() throws Throwable {
        if (this.rootFile != null) {
            this.rootFile.close();
        }
        super.finalize();
    }
}

