/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.cluster;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import java.util.Vector;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.tomcat.util.res.StringManager;
import org.jboss.logging.Logger;
import org.jboss.web.cluster.ClusterListener;
import org.jboss.web.cluster.JSSEKeyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSSESocketFactory {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.jsse.res");
    static Logger log = Logger.getLogger(JSSESocketFactory.class);
    protected boolean initialized;
    protected SSLSocketFactory sslProxy = null;
    protected String[] enabledCiphers;
    protected ClusterListener listener = null;

    public JSSESocketFactory(ClusterListener listener) {
        this.listener = listener;
    }

    public Socket createSocket(InetAddress ifAddress, int port) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        Socket socket = this.sslProxy.createSocket(ifAddress, port);
        this.initSocket(socket);
        return socket;
    }

    public void handshake(Socket sock) throws IOException {
        ((SSLSocket)sock).startHandshake();
    }

    protected String[] getEnabledCiphers(String requestedCiphers, String[] supportedCiphers) {
        Object[] enabledCiphers = null;
        if (requestedCiphers != null) {
            Vector<String> vec = null;
            String cipher = requestedCiphers;
            int index = requestedCiphers.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    cipher = requestedCiphers.substring(fromIndex, index).trim();
                    if (cipher.length() > 0) {
                        for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                            if (!supportedCiphers[i].equals(cipher)) continue;
                            if (vec == null) {
                                vec = new Vector();
                            }
                            vec.addElement(cipher);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedCiphers.indexOf(44, fromIndex);
                }
                cipher = requestedCiphers.substring(fromIndex);
            }
            if (cipher != null && (cipher = cipher.trim()).length() > 0) {
                for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                    if (!supportedCiphers[i].equals(cipher)) continue;
                    if (vec == null) {
                        vec = new Vector<String>();
                    }
                    vec.addElement(cipher);
                    break;
                }
            }
            if (vec != null) {
                enabledCiphers = new String[vec.size()];
                vec.copyInto(enabledCiphers);
            }
        } else {
            enabledCiphers = this.sslProxy.getDefaultCipherSuites();
        }
        return enabledCiphers;
    }

    protected KeyStore getKeystore(String type, String provider, String pass) throws IOException {
        return this.getStore(type, provider, this.listener.getSslKeyStore(), pass);
    }

    protected KeyStore getTrustStore(String keystoreType, String keystoreProvider) throws IOException {
        String truststoreProvider;
        KeyStore trustStore = null;
        String truststorePassword = this.listener.getSslTrustStorePassword();
        if (truststorePassword == null) {
            truststorePassword = this.listener.getSslKeyStorePass();
        } else if (truststorePassword.equals("")) {
            truststorePassword = null;
        }
        String truststoreType = this.listener.getSslTrustStoreType();
        if (truststoreType == null) {
            truststoreType = keystoreType;
        }
        if ((truststoreProvider = this.listener.getSslTrustStoreProvider()) == null) {
            truststoreProvider = keystoreProvider;
        }
        if (this.listener.getSslTrustStore() != null) {
            trustStore = this.getStore(truststoreType, truststoreProvider, this.listener.getSslTrustStore(), truststorePassword);
        }
        return trustStore;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore getStore(String type, String provider, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            try {
                ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
                if (!"PKCS11".equalsIgnoreCase(type) && !"".equalsIgnoreCase(path)) {
                    File keyStoreFile = new File(path);
                    if (!keyStoreFile.isAbsolute()) {
                        keyStoreFile = new File(System.getProperty("catalina.base"), path);
                    }
                    istream = new FileInputStream(keyStoreFile);
                }
                if (pass == null) {
                    ks.load(istream, null);
                } else {
                    ks.load(istream, pass.toCharArray());
                }
            }
            catch (FileNotFoundException fnfe) {
                log.error((Object)sm.getString("jsse.keystore_load_failed", type, path, fnfe.getMessage()), (Throwable)fnfe);
                throw fnfe;
            }
            catch (IOException ioe) {
                log.error((Object)sm.getString("jsse.keystore_load_failed", type, path, ioe.getMessage()), (Throwable)ioe);
                throw ioe;
            }
            catch (Exception ex) {
                String msg = sm.getString("jsse.keystore_load_failed", type, path, ex.getMessage());
                log.error((Object)msg, (Throwable)ex);
                throw new IOException(msg);
            }
            Object var10_11 = null;
            if (istream == null) return ks;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (istream == null) throw throwable;
            try {
                istream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        istream.close();
        return ks;
    }

    void init() throws IOException {
        try {
            SSLContext context = SSLContext.getInstance(this.listener.getSslProtocol());
            context.init(this.getKeyManagers(this.listener.getSslKeyStoreType(), this.listener.getSslKeyStoreProvider(), this.listener.getSslCertificateEncodingAlgorithm(), this.listener.getSslKeyAlias()), this.getTrustManagers(this.listener.getSslKeyStoreType(), this.listener.getSslKeyStoreProvider(), this.listener.getSslTrustAlgorithm()), new SecureRandom());
            this.sslProxy = context.getSocketFactory();
            this.enabledCiphers = this.getEnabledCiphers(this.listener.getSslCiphers(), this.sslProxy.getSupportedCipherSuites());
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    protected KeyManager[] getKeyManagers(String keystoreType, String keystoreProvider, String algorithm, String keyAlias) throws Exception {
        KeyManager[] kms = null;
        KeyStore ks = this.getKeystore(keystoreType, keystoreProvider, this.listener.getSslKeyStorePass());
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException(sm.getString("jsse.alias_no_key_entry", keyAlias));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, this.listener.getSslKeyStorePass().toCharArray());
        kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            if ("JKS".equals(keystoreType)) {
                keyAlias = keyAlias.toLowerCase();
            }
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], keyAlias);
            }
        }
        return kms;
    }

    protected TrustManager[] getTrustManagers(String keystoreType, String keystoreProvider, String algorithm) throws Exception {
        TrustManager[] tms = null;
        KeyStore trustStore = this.getTrustStore(keystoreType, keystoreProvider);
        if (trustStore != null) {
            if (this.listener.getSslCrlFile() == null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                CertPathParameters params = this.getParameters(algorithm, this.listener.getSslCrlFile(), trustStore);
                CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
                tmf.init(mfp);
                tms = tmf.getTrustManagers();
            }
        }
        return tms;
    }

    protected CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        PKIXBuilderParameters params = null;
        if (!"PKIX".equalsIgnoreCase(algorithm)) {
            throw new CRLException("CRLs not supported for type: " + algorithm);
        }
        PKIXBuilderParameters xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
        Collection<? extends CRL> crls = this.getCRLs(crlf);
        CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
        CertStore store = CertStore.getInstance("Collection", csp);
        xparams.addCertStore(store);
        xparams.setRevocationEnabled(true);
        xparams.setMaxPathLength(this.listener.getSslTrustMaxCertLength());
        params = xparams;
        return params;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection<? extends CRL> getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        File crlFile = new File(crlf);
        if (!crlFile.isAbsolute()) {
            crlFile = new File(System.getProperty("catalina.base"), crlf);
        }
        Collection<? extends CRL> crls = null;
        FileInputStream is = null;
        try {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                is = new FileInputStream(crlFile);
                crls = cf.generateCRLs(is);
            }
            catch (IOException iex) {
                throw iex;
            }
            catch (CRLException crle) {
                throw crle;
            }
            catch (CertificateException ce) {
                throw ce;
            }
            Object var7_9 = null;
            if (is == null) return crls;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        ((InputStream)is).close();
        return crls;
    }

    protected void setEnabledProtocols(SSLSocket socket, String[] protocols) {
        if (protocols != null) {
            socket.setEnabledProtocols(protocols);
        }
    }

    protected String[] getEnabledProtocols(SSLSocket socket, String requestedProtocols) {
        String[] supportedProtocols = socket.getSupportedProtocols();
        Object[] enabledProtocols = null;
        if (requestedProtocols != null) {
            Vector<String> vec = null;
            String protocol = requestedProtocols;
            int index = requestedProtocols.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    protocol = requestedProtocols.substring(fromIndex, index).trim();
                    if (protocol.length() > 0) {
                        for (int i = 0; supportedProtocols != null && i < supportedProtocols.length; ++i) {
                            if (!supportedProtocols[i].equals(protocol)) continue;
                            if (vec == null) {
                                vec = new Vector();
                            }
                            vec.addElement(protocol);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedProtocols.indexOf(44, fromIndex);
                }
                protocol = requestedProtocols.substring(fromIndex);
            }
            if (protocol != null && (protocol = protocol.trim()).length() > 0) {
                for (int i = 0; supportedProtocols != null && i < supportedProtocols.length; ++i) {
                    if (!supportedProtocols[i].equals(protocol)) continue;
                    if (vec == null) {
                        vec = new Vector<String>();
                    }
                    vec.addElement(protocol);
                    break;
                }
            }
            if (vec != null) {
                enabledProtocols = new String[vec.size()];
                vec.copyInto(enabledProtocols);
            }
        }
        return enabledProtocols;
    }

    private void initSocket(Socket ssocket) {
        SSLSocket socket = (SSLSocket)ssocket;
        if (this.enabledCiphers != null) {
            socket.setEnabledCipherSuites(this.enabledCiphers);
        }
        this.setEnabledProtocols(socket, this.getEnabledProtocols(socket, this.listener.getSslProtocol()));
    }
}

