/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.jms;

import java.lang.reflect.Constructor;

import org.jboss.test.AbstractTestDelegate;
import org.objectweb.jtests.jms.admin.Admin;

/**
 * JoramTestDelegate.
 * 
 * @author <a href="adrian@jboss.x`com">Adrian Brock</a>
 * @version $Revision: 1.2 $
 */
public class JoramTestDelegate extends AbstractTestDelegate
{
   protected String adminName;
   
   public JoramTestDelegate(Class clazz, String adminName)
   {
      super(clazz);
      this.adminName = adminName;
   }

   public void setUp() throws Exception
   {
      super.setUp();
      Class adminClass = Thread.currentThread().getContextClassLoader().loadClass(adminName);
      Constructor constructor = adminClass.getConstructor(new Class[] { Class.class });
      Admin admin = (Admin) constructor.newInstance(new Object[] { clazz } );
      GenericAdmin.delegate = admin; 
   }
}
