/*
 * Copyright 2009 Red Hat, Inc.
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *    http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */

package org.hornetq.utils.concurrent;

import java.lang.reflect.Array;

import org.hornetq.utils.HQDeque;
import org.hornetq.utils.PriorityLinkedListImpl;

/**
 * A concurrent priority linked list implementation.
 * 
 * Requires Java 6.
 * 
 * @author <a href="mailto:jmesnil@redhat.com>Jeff Mesnil</a>
 * @version <tt>$Revision: 1174 $</tt>
 *
 * $Id: BasicPrioritizedDeque.java 1174 2006-08-02 14:14:32Z timfox $
 */
public class ConcurrentPriorityLinkedListImpl<T> extends PriorityLinkedListImpl<T>
{
   public ConcurrentPriorityLinkedListImpl(final int priorities)
   {
      super(priorities);

      levels = (HQDeque<T>[])Array.newInstance(HQDeque.class, priorities);

      for (int i = 0; i < priorities; i++)
      {
         levels[i] = new ConcurrentHQDeque<T>();
      }
   }
}
