/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.layout;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class MavenJPackageDepmap {
    private static MavenJPackageDepmap instance;
    private static Hashtable jppArtifactMap;

    private MavenJPackageDepmap() {
        jppArtifactMap = new Hashtable();
        MavenJPackageDepmap.buildJppArtifactMap();
    }

    public static MavenJPackageDepmap getInstance() {
        if (instance == null) {
            instance = new MavenJPackageDepmap();
        }
        return instance;
    }

    public Hashtable getMappedInfo(Hashtable mavenDep) {
        return this.getMappedInfo((String)mavenDep.get("group"), (String)mavenDep.get("artifact"), (String)mavenDep.get("version"));
    }

    public Hashtable getMappedInfo(String groupId, String artifactId, String version) {
        String idToCheck = System.getProperty("maven2.ignore.versions") == null && System.getProperty("maven2.jpp.mode") == null ? groupId + "," + artifactId + "," + version : groupId + "," + artifactId;
        String jppCombination = (String)jppArtifactMap.get(idToCheck);
        Hashtable<String, String> jppDep = new Hashtable<String, String>();
        if (jppCombination != null && jppCombination != "") {
            StringTokenizer st = new StringTokenizer(jppCombination, ",");
            jppDep.put("group", st.nextToken());
            jppDep.put("artifact", st.nextToken());
            jppDep.put("version", st.nextToken());
        } else {
            jppDep.put("group", groupId);
            jppDep.put("artifact", artifactId);
            jppDep.put("version", version);
        }
        return jppDep;
    }

    public boolean shouldEliminate(String groupId, String artifactId, String version) {
        String idToCheck = System.getProperty("maven2.ignore.versions") == null && System.getProperty("maven2.jpp.mode") == null ? groupId + "," + artifactId + "," + version : groupId + "," + artifactId;
        return jppArtifactMap.get(idToCheck) != null && jppArtifactMap.get(idToCheck).equals("");
    }

    private static void buildJppArtifactMap() {
        if (System.getProperty("maven2.ignore.versions") != null || System.getProperty("maven2.jpp.mode") != null) {
            MavenJPackageDepmap.processDepmapFile("/etc/maven/maven2-versionless-depmap.xml");
        }
        MavenJPackageDepmap.processDepmapFile("/etc/maven/maven2-depmap.xml");
        String customFileName = System.getProperty("maven2.jpp.depmap.file", null);
        if (customFileName != null) {
            MavenJPackageDepmap.processDepmapFile(customFileName);
        }
    }

    private static void processDepmapFile(String fileName) {
        Document mapDocument;
        try {
            mapDocument = new SAXBuilder().build(new InputSource(new FileInputStream(fileName)));
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("ERROR: Unable to find map file: " + fileName);
            fnfe.printStackTrace();
            return;
        }
        catch (IOException ioe) {
            System.err.println("ERROR: I/O exception occured when opening map file");
            ioe.printStackTrace();
            return;
        }
        catch (JDOMException jde) {
            System.err.println("ERROR: Unable to instantiate parser");
            jde.printStackTrace();
            return;
        }
        List l = mapDocument.getRootElement().getChildren("dependency");
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Element depElement = (Element)i.next();
            Element mElem = depElement.getChild("maven");
            Element jppElem = depElement.getChild("jpp");
            String mG = mElem.getChildText("groupId");
            String mA = mElem.getChildText("artifactId");
            String mV = mElem.getChildText("version");
            if (jppElem != null) {
                String jppG = jppElem.getChildText("groupId");
                String jppA = jppElem.getChildText("artifactId");
                String jppV = jppElem.getChildText("version");
                String string = jppV = jppV != null && jppV.length() > 0 ? jppV : mV;
                if (System.getProperty("maven2.ignore.versions") == null && System.getProperty("maven2.jpp.mode") == null) {
                    jppArtifactMap.put(mG + "," + mA + "," + mV, jppG + "," + jppA + "," + jppV);
                    continue;
                }
                jppArtifactMap.put(mG + "," + mA, jppG + "," + jppA + "," + jppV);
                continue;
            }
            jppArtifactMap.put(mG + "," + mA, "JPP/maven2,empty-dep," + mV);
        }
    }
}

