/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.layout;

import java.util.Hashtable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.MavenJPackageDepmap;

public class DefaultRepositoryLayout
implements ArtifactRepositoryLayout {
    private static final char PATH_SEPARATOR = '/';
    private static final char GROUP_SEPARATOR = '.';
    private static final char ARTIFACT_SEPARATOR = '-';

    public String pathOf(Artifact artifact) {
        ArtifactHandler artifactHandler = artifact.getArtifactHandler();
        StringBuffer path = new StringBuffer();
        String baseVersion = artifact.getBaseVersion();
        String version = artifact.getVersion();
        if (System.getProperty("maven2.offline.mode") != null && System.getProperty("maven2.ignore.versions") != null || System.getProperty("maven2.jpp.mode") != null) {
            MavenJPackageDepmap map = MavenJPackageDepmap.getInstance();
            Hashtable newInfo = map.getMappedInfo(artifact.getGroupId(), artifact.getArtifactId(), version);
            version = baseVersion = (String)newInfo.get("version");
        }
        path.append(this.formatAsDirectory(artifact.getGroupId())).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(baseVersion).append('/');
        path.append(artifact.getArtifactId()).append('-').append(version);
        if (artifact.hasClassifier()) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifactHandler.getExtension() != null && artifactHandler.getExtension().length() > 0) {
            path.append('.').append(artifactHandler.getExtension());
        }
        return path.toString();
    }

    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.pathOfRepositoryMetadata(metadata, metadata.getLocalFilename(repository));
    }

    private String pathOfRepositoryMetadata(ArtifactMetadata metadata, String filename) {
        StringBuffer path = new StringBuffer();
        path.append(this.formatAsDirectory(metadata.getGroupId())).append('/');
        if (!metadata.storedInGroupDirectory()) {
            path.append(metadata.getArtifactId()).append('/');
            if (metadata.storedInArtifactVersionDirectory()) {
                String baseVersion = metadata.getBaseVersion();
                if (System.getProperty("maven2.offline.mode") != null && System.getProperty("maven2.ignore.versions") != null || System.getProperty("maven2.jpp.mode") != null) {
                    MavenJPackageDepmap map = MavenJPackageDepmap.getInstance();
                    Hashtable newInfo = map.getMappedInfo(metadata.getGroupId(), metadata.getArtifactId(), baseVersion);
                    baseVersion = (String)newInfo.get("version");
                }
                path.append(baseVersion).append('/');
            }
        }
        path.append(filename);
        return path.toString();
    }

    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata metadata) {
        return this.pathOfRepositoryMetadata(metadata, metadata.getRemoteFilename());
    }

    private String formatAsDirectory(String directory) {
        return directory.replace('.', '/');
    }
}

