/*
 * Decompiled with CFR 0.152.
 */
package xdoclet;

import org.apache.commons.logging.Log;
import xdoclet.DocletContext;
import xdoclet.SubTask;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.template.TemplateException;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XJavaDoc;

public class XDocletMain {
    protected void start(XJavaDoc xJavaDoc) throws XDocletException {
        Log log = LogUtil.getLog(XDocletMain.class, "start");
        try {
            log.debug((Object)"Context successfully loaded.");
            SubTask[] subtasks = DocletContext.getInstance().getSubTasks();
            for (int i = 0; i < subtasks.length; ++i) {
                if (subtasks[i] == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SubTask " + subtasks[i].getSubTaskName() + " initialized."));
                }
                subtasks[i].init(xJavaDoc);
                DocletContext.getInstance().setActiveSubTask(subtasks[i]);
                log.info((Object)Translator.getString(XDocletMessages.class, "RUNNING_TASKNAME", new String[]{"<" + subtasks[i].getSubTaskName() + "/>"}));
                subtasks[i].execute();
            }
        }
        catch (XDocletException e) {
            log.error((Object)Translator.getString(XDocletMessages.class, "RUNNING_FAILED"));
            log.error((Object)("<<" + e.getMessage() + ">>"));
            if (e.getNestedException() != null) {
                e.getNestedException().printStackTrace();
            }
            if (e.getNestedException() instanceof TemplateException) {
                TemplateException te = (TemplateException)e.getNestedException();
                if (log.isDebugEnabled()) {
                    log.error((Object)("Template Exception = " + te));
                    log.error((Object)("Nested Exception = " + te.getNestedException()));
                }
            }
            throw e;
        }
    }
}

