/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.type.ImmutableType;

public class TextType
extends ImmutableType {
    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        String str = (String)value;
        st.setCharacterStream(index, (Reader)new StringReader(str), str.length());
    }

    public int sqlType() {
        return 2005;
    }

    public String getName() {
        return "text";
    }

    public Object fromStringValue(String xml) throws HibernateException {
        return xml;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        Reader charReader = rs.getCharacterStream(name);
        if (charReader == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            try {
                char[] buffer = new char[2048];
                while (true) {
                    int amountRead;
                    if ((amountRead = charReader.read(buffer, 0, buffer.length)) == -1) {
                        Object var8_8 = null;
                        break;
                    }
                    sb.append(buffer, 0, amountRead);
                }
            }
            catch (IOException ioe) {
                throw new HibernateException("IOException occurred reading text", ioe);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                charReader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new HibernateException("IOException occurred closing stream", e);
            }
        }
        try {}
        catch (IOException e) {
            throw new HibernateException("IOException occurred closing stream", e);
        }
        charReader.close();
        return sb.toString();
    }

    public String toString(Object value) throws HibernateException {
        return (String)value;
    }

    public Class getReturnedClass() {
        return String.class;
    }
}

