/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.action.EntityDeleteAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.Status;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.OnUpdateVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.IdentitySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeleteEventListener
implements DeleteEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeleteEventListener.class);

    public void onDelete(DeleteEvent event) throws HibernateException {
        this.onDelete(event, new IdentitySet());
    }

    public void onDelete(DeleteEvent event, Set transientEntities) throws HibernateException {
        Object version;
        Serializable id;
        EntityPersister persister;
        Object entity;
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(entity = persistenceContext.unproxyAndReassociate(event.getObject()));
        if (entityEntry == null) {
            log.trace("entity was not persistent in delete processing");
            persister = source.getEntityPersister(event.getEntityName(), entity);
            if (ForeignKeys.isTransient(persister.getEntityName(), entity, null, source)) {
                this.deleteTransientEntity(source, entity, event.isCascadeDeleteEnabled(), persister, transientEntities);
                return;
            }
            this.performDetachedEntityDeletionCheck(event);
            id = persister.getIdentifier(entity, source.getEntityMode());
            if (id == null) {
                throw new TransientObjectException("the detached instance passed to delete() had a null identifier");
            }
            EntityKey key = new EntityKey(id, persister, source.getEntityMode());
            persistenceContext.checkUniqueness(key, entity);
            new OnUpdateVisitor(source, id, entity).process(entity, persister);
            version = persister.getVersion(entity, source.getEntityMode());
            entityEntry = persistenceContext.addEntity(entity, Status.MANAGED, persister.getPropertyValues(entity, source.getEntityMode()), key, version, LockMode.NONE, true, persister, false, false);
        } else {
            log.trace("deleting a persistent instance");
            if (entityEntry.getStatus() == Status.DELETED || entityEntry.getStatus() == Status.GONE) {
                log.trace("object was already deleted");
                return;
            }
            persister = entityEntry.getPersister();
            id = entityEntry.getId();
            version = entityEntry.getVersion();
        }
        if (this.invokeDeleteLifecycle(source, entity, persister)) {
            return;
        }
        this.deleteEntity(source, entity, entityEntry, event.isCascadeDeleteEnabled(), persister, transientEntities);
        if (source.getFactory().getSettings().isIdentifierRollbackEnabled()) {
            persister.resetIdentifier(entity, id, version, source.getEntityMode());
        }
    }

    protected void performDetachedEntityDeletionCheck(DeleteEvent event) {
    }

    protected void deleteTransientEntity(EventSource session, Object entity, boolean cascadeDeleteEnabled, EntityPersister persister, Set transientEntities) {
        log.info("handling transient entity in delete processing");
        if (transientEntities.contains(entity)) {
            log.trace("already handled transient entity; skipping");
            return;
        }
        transientEntities.add(entity);
        this.cascadeBeforeDelete(session, persister, entity, null, transientEntities);
        this.cascadeAfterDelete(session, persister, entity, transientEntities);
    }

    protected final void deleteEntity(EventSource session, Object entity, EntityEntry entityEntry, boolean isCascadeDeleteEnabled, EntityPersister persister, Set transientEntities) {
        if (log.isTraceEnabled()) {
            log.trace("deleting " + MessageHelper.infoString(persister, entityEntry.getId(), session.getFactory()));
        }
        PersistenceContext persistenceContext = session.getPersistenceContext();
        Type[] propTypes = persister.getPropertyTypes();
        Object version = entityEntry.getVersion();
        Object[] currentState = entityEntry.getLoadedState() == null ? persister.getPropertyValues(entity, session.getEntityMode()) : entityEntry.getLoadedState();
        Object[] deletedState = this.createDeletedState(persister, currentState, session);
        entityEntry.setDeletedState(deletedState);
        session.getInterceptor().onDelete(entity, entityEntry.getId(), deletedState, persister.getPropertyNames(), propTypes);
        persistenceContext.setEntryStatus(entityEntry, Status.DELETED);
        EntityKey key = new EntityKey(entityEntry.getId(), persister, session.getEntityMode());
        this.cascadeBeforeDelete(session, persister, entity, entityEntry, transientEntities);
        new ForeignKeys.Nullifier(entity, true, false, session).nullifyTransientReferences(entityEntry.getDeletedState(), propTypes);
        new Nullability(session).checkNullability(entityEntry.getDeletedState(), persister, true);
        persistenceContext.getNullifiableEntityKeys().add(key);
        session.getActionQueue().addAction(new EntityDeleteAction(entityEntry.getId(), deletedState, version, entity, persister, isCascadeDeleteEnabled, session));
        this.cascadeAfterDelete(session, persister, entity, transientEntities);
    }

    private Object[] createDeletedState(EntityPersister persister, Object[] currentState, EventSource session) {
        Type[] propTypes = persister.getPropertyTypes();
        Object[] deletedState = new Object[propTypes.length];
        boolean[] copyability = new boolean[propTypes.length];
        Arrays.fill(copyability, true);
        TypeFactory.deepCopy(currentState, propTypes, copyability, deletedState, session);
        return deletedState;
    }

    protected boolean invokeDeleteLifecycle(EventSource session, Object entity, EntityPersister persister) {
        if (persister.implementsLifecycle(session.getEntityMode())) {
            log.debug("calling onDelete()");
            if (((Lifecycle)entity).onDelete(session)) {
                log.debug("deletion vetoed by onDelete()");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeDelete(EventSource session, EntityPersister persister, Object entity, EntityEntry entityEntry, Set transientEntities) throws HibernateException {
        CacheMode cacheMode = session.getCacheMode();
        session.setCacheMode(CacheMode.GET);
        session.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.DELETE, 1, session).cascade(persister, entity, transientEntities);
        }
        finally {
            session.getPersistenceContext().decrementCascadeLevel();
            session.setCacheMode(cacheMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterDelete(EventSource session, EntityPersister persister, Object entity, Set transientEntities) throws HibernateException {
        CacheMode cacheMode = session.getCacheMode();
        session.setCacheMode(CacheMode.GET);
        session.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.DELETE, 2, session).cascade(persister, entity, transientEntities);
        }
        finally {
            session.getPersistenceContext().decrementCascadeLevel();
            session.setCacheMode(cacheMode);
        }
    }
}

