/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Enhanced;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.raw.RawField;
import com.sleepycat.persist.raw.RawType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Format
implements RawType,
Serializable {
    private static final long serialVersionUID = 545633644568489850L;
    static final int ID_NULL = 0;
    static final int ID_OBJECT = 1;
    static final int ID_BOOL = 2;
    static final int ID_BOOL_W = 3;
    static final int ID_BYTE = 4;
    static final int ID_BYTE_W = 5;
    static final int ID_SHORT = 6;
    static final int ID_SHORT_W = 7;
    static final int ID_INT = 8;
    static final int ID_INT_W = 9;
    static final int ID_LONG = 10;
    static final int ID_LONG_W = 11;
    static final int ID_FLOAT = 12;
    static final int ID_FLOAT_W = 13;
    static final int ID_DOUBLE = 14;
    static final int ID_DOUBLE_W = 15;
    static final int ID_CHAR = 16;
    static final int ID_CHAR_W = 17;
    static final int ID_STRING = 18;
    static final int ID_BIGINT = 19;
    static final int ID_BIGDEC = 20;
    static final int ID_DATE = 21;
    static final int ID_SIMPLE_MIN = 2;
    static final int ID_SIMPLE_MAX = 21;
    static final int ID_PREDEFINED = 30;
    private int id;
    private String className;
    private int version;
    private Format superFormat;
    private Set<String> supertypes;
    private transient Class type;
    private transient Format evolveToFormat;
    private transient Format proxiedFormat;
    private transient boolean initialized;

    static boolean isPredefined(Format format) {
        return format.getId() <= 30;
    }

    Format(Class type) {
        this.type = type;
        this.className = type.getName();
        this.supertypes = new HashSet<String>();
        this.addSupertypes();
    }

    final int getId() {
        return this.id;
    }

    final void setId(int id) {
        this.id = id;
    }

    final Class getType() {
        return this.type;
    }

    final Format getSuperFormat() {
        return this.superFormat;
    }

    final void setSuperFormat(Format superFormat) {
        this.superFormat = superFormat;
    }

    final Format getProxiedFormat() {
        return this.proxiedFormat;
    }

    final void setProxiedFormat(Format proxiedFormat) {
        this.proxiedFormat = proxiedFormat;
    }

    final void initializeIfNeeded(Catalog catalog) {
        if (!this.initialized) {
            try {
                this.type = SimpleCatalog.classForName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            this.initialize(catalog);
            this.initialized = true;
        }
    }

    private void addSupertypes() {
        this.addInterfaces(this.type);
        for (Class stype = this.type.getSuperclass(); stype != null && stype != Object.class; stype = stype.getSuperclass()) {
            this.supertypes.add(stype.getName());
            this.addInterfaces(stype);
        }
    }

    private void addInterfaces(Class cls) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            if (iface == Enhanced.class) continue;
            this.supertypes.add(iface.getName());
            this.addInterfaces(iface);
        }
    }

    Format evolveTo(Format newFormat) {
        this.evolveToFormat = newFormat;
        return this;
    }

    boolean isCurrentVersion() {
        return this.evolveToFormat == null;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Format getSuperType() {
        return this.superFormat;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public List<String> getEnumConstants() {
        return null;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public int getDimensions() {
        return 0;
    }

    @Override
    public Format getComponentType() {
        return null;
    }

    @Override
    public Map<String, RawField> getFields() {
        return null;
    }

    boolean isAssignableTo(Format format) {
        if (this.proxiedFormat != null) {
            return this.proxiedFormat.isAssignableTo(format);
        }
        return format == this || format.id == 1 || this.supertypes.contains(format.getClassName());
    }

    Format getWrapperFormat() {
        return null;
    }

    boolean isEntity() {
        return false;
    }

    boolean isModelClass() {
        return false;
    }

    ClassMetadata getClassMetadata() {
        return null;
    }

    EntityMetadata getEntityMetadata() {
        return null;
    }

    Format getEntityFormat() {
        return null;
    }

    public boolean equals(Object other) {
        if (other instanceof Format) {
            Format o = (Format)other;
            if (this.superFormat != null ? o.superFormat == null || !this.superFormat.getClassName().equals(o.superFormat.getClassName()) : o.superFormat != null) {
                return false;
            }
            boolean equalSupertypes = ((Object)this.supertypes).equals(o.supertypes);
            if (!equalSupertypes) {
                o.supertypes.remove(Enhanced.class.getName());
                equalSupertypes = ((Object)this.supertypes).equals(o.supertypes);
            }
            return this.version == o.version && this.className.equals(o.className) && equalSupertypes;
        }
        return false;
    }

    abstract void initialize(Catalog var1);

    abstract void collectRelatedFormats(Catalog var1, Map<String, Format> var2);

    abstract Object newArray(int var1);

    abstract Object newInstance(EntityInput var1, boolean var2);

    abstract void readObject(Object var1, EntityInput var2, boolean var3);

    abstract void writeObject(Object var1, EntityOutput var2, boolean var3);

    abstract void skipContents(EntityInput var1);

    Format skipToSecKey(EntityInput input, String keyName) {
        throw new UnsupportedOperationException(this.className);
    }

    void copySecKey(EntityInput input, EntityOutput output) {
        throw new UnsupportedOperationException(this.className);
    }

    void copySecMultiKey(EntityInput input, Format keyFormat, Set results) {
        throw new UnsupportedOperationException(this.className);
    }

    boolean nullifySecKey(Catalog catalog, Object entity, String keyName, Object keyElement) {
        throw new UnsupportedOperationException(this.className);
    }

    boolean isPriKeyNullOrZero(Object o, boolean rawAccess) {
        throw new UnsupportedOperationException(this.className);
    }

    void writePriKey(Object o, EntityOutput output, boolean rawAccess) {
        throw new UnsupportedOperationException(this.className);
    }

    void readPriKey(Object o, EntityInput input, boolean rawAccess) {
        throw new UnsupportedOperationException(this.className);
    }
}

